/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.biomesoplenty;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.terrain.GroundEffect;
import rtg.world.gen.terrain.HeightEffect;
import rtg.world.gen.terrain.HeightVariation;
import rtg.world.gen.terrain.RaiseEffect;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.VariableRuggednessEffect;

public class TerrainBOPOutback
extends TerrainBase {
    private float minHeight;
    private float mesaWavelength;
    private float hillStrength;
    private float topBumpinessHeight = 4.0f;
    private float topBumpinessWavelength = 25.0f;
    private HeightEffect height;
    private HeightEffect groundEffect;

    public TerrainBOPOutback(float minHeight, float wavelength, float hillStrength) {
        this.minHeight = minHeight;
        this.mesaWavelength = wavelength;
        this.hillStrength = hillStrength;
        this.groundEffect = new GroundEffect(4.0f);
        HeightVariation topVariation = new HeightVariation();
        topVariation.height = hillStrength / 2.0f;
        topVariation.octave = 1;
        topVariation.wavelength = VariableRuggednessEffect.STANDARD_RUGGEDNESS_WAVELENGTH;
        HeightVariation topBumpiness = new HeightVariation();
        topBumpiness.height = this.topBumpinessHeight;
        topBumpiness.wavelength = this.topBumpinessWavelength;
        topBumpiness.octave = 3;
        VariableRuggednessEffect mesaTops = new VariableRuggednessEffect(new RaiseEffect(0.0f), topVariation.plus(new RaiseEffect(hillStrength)).plus(topBumpiness), 0.3f, 0.15f, this.mesaWavelength);
        this.height = new VariableRuggednessEffect(new RaiseEffect(0.0f), mesaTops, -0.3f, 0.06f);
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        return TerrainBOPOutback.riverized(this.minHeight + this.groundEffect.added(simplex, cell, x, y), river) + this.height.added(simplex, cell, x, y);
    }
}

