/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.biomesoplenty;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.util.SimplexOctave;
import rtg.world.gen.terrain.TerrainBase;

public class TerrainBOPCrag
extends TerrainBase {
    private float pointHeightVariation = 20.0f;
    private float pointHeightWavelength = 400.0f;
    private float pointHeight = 50.0f;
    private float pointWavelength = 50.0f;

    public TerrainBOPCrag(float baseHeight) {
        this.base = baseHeight;
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        SimplexOctave.Derivative jitter = new SimplexOctave.Derivative();
        simplex.riverJitter().evaluateNoise((double)x / 20.0, (double)y / 20.0, jitter);
        double pX = (double)x + jitter.deltax() * 1.0;
        double pY = (double)y + jitter.deltay() * 1.0;
        double multiplier = ((double)border - 0.5) * 10.0;
        if (multiplier < 0.0) {
            multiplier = 0.0;
        }
        if (multiplier > 1.0) {
            multiplier = 1.0;
        }
        double[] points = cell.octave(1).eval((float)pX / this.pointWavelength, (float)pY / this.pointWavelength);
        float raise = (float)((points[1] - points[0]) / points[1]);
        raise *= 3.0f;
        if ((raise -= 0.2f) < 0.0f) {
            raise = 0.0f;
        }
        if (raise > 1.0f) {
            raise = 1.0f;
        }
        float topHeight = (float)((double)this.pointHeight + (double)this.pointHeightVariation * simplex.noise((float)x / this.pointHeightWavelength, (float)y / this.pointHeightWavelength));
        float p = raise * topHeight;
        if (border >= 1.0f) {
            return this.base + p;
        }
        if ((double)border > 0.65) {
            float missingBase = (1.0f - border) * (this.base - 70.0f);
            float pStretch = (topHeight + missingBase) / topHeight;
            p *= pStretch;
            p = TerrainBOPCrag.borderAdjusted(p, border, 0.75f, 0.65f);
            return this.base + p;
        }
        return this.base;
    }
}

