/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.biomesoplenty;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.terrain.HeightVariation;
import rtg.world.gen.terrain.HillockEffect;
import rtg.world.gen.terrain.TerrainBase;

public class TerrainBOPBog
extends TerrainBase {
    private final float bottom = 58.0f;
    private final HeightVariation bottomVariation = new HeightVariation();
    private final HillockEffect smallHills;
    private final HillockEffect mediumHills;

    public TerrainBOPBog() {
        this.bottomVariation.height = 2.0f;
        this.bottomVariation.octave = 0;
        this.bottomVariation.wavelength = 40.0f;
        this.smallHills = new HillockEffect();
        this.smallHills.height = 6.0f;
        this.smallHills.wavelength = 15.0f;
        this.smallHills.minimumSimplex = 0.2f;
        this.smallHills.octave = 1;
        this.mediumHills = new HillockEffect();
        this.mediumHills.height = 12.0f;
        this.mediumHills.wavelength = 25.0f;
        this.mediumHills.minimumSimplex = 0.2f;
        this.mediumHills.octave = 2;
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        float increment = this.bottomVariation.added(simplex, cell, x, y) + this.smallHills.added(simplex, cell, x, y);
        return TerrainBOPBog.riverized(58.0f + (increment += this.mediumHills.added(simplex, cell, x, y)), river);
    }
}

