/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.surface.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.api.biome.BiomeConfig;
import rtg.util.CanyonColour;
import rtg.util.CellNoise;
import rtg.util.CliffCalculator;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.surface.SurfaceBase;

public class SurfaceVanillaMesaPlateauM
extends SurfaceBase {
    private int grassRaise = 0;

    public SurfaceVanillaMesaPlateauM(BiomeConfig config, Block top, byte topByte, Block fill, byte fillByte, int grassHeight) {
        super(config, top, topByte, fill, fillByte);
        this.grassRaise = grassHeight;
    }

    @Override
    public void paintTerrain(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, OpenSimplexNoise simplex, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        float c = CliffCalculator.calc(x, y, noise);
        boolean cliff = c > 1.3f;
        float noiseHeight = noise[y * 16 + x];
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b != Blocks.field_150348_b) continue;
            float effectiveHeight = noiseHeight - (float)(++depth);
            if (depth > -1 && depth < 12) {
                if (cliff) {
                    blocks[(y * 16 + x) * 256 + k] = CanyonColour.MESA.getBlockForHeight(i, effectiveHeight, j);
                    metadata[(y * 16 + x) * 256 + k] = CanyonColour.MESA.getMetaForHeight(i, effectiveHeight, j);
                    continue;
                }
                if (depth > 4) {
                    blocks[(y * 16 + x) * 256 + k] = CanyonColour.MESA.getBlockForHeight(i, effectiveHeight, j);
                    metadata[(y * 16 + x) * 256 + k] = CanyonColour.MESA.getMetaForHeight(i, effectiveHeight, j);
                    continue;
                }
                if (k > 74 + this.grassRaise) {
                    if (rand.nextInt(5) == 0) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
                        metadata[(y * 16 + x) * 256 + k] = 1;
                        continue;
                    }
                    if (depth == 0) {
                        blocks[(y * 16 + x) * 256 + k] = this.topBlock;
                        metadata[(y * 16 + x) * 256 + k] = this.topBlockMeta;
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = this.fillerBlock;
                    metadata[(y * 16 + x) * 256 + k] = this.fillerBlockMeta;
                    continue;
                }
                if (k < 62) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
                    metadata[(y * 16 + x) * 256 + k] = 0;
                    continue;
                }
                if (k < 62 + this.grassRaise) {
                    if (depth == 0) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                        metadata[(y * 16 + x) * 256 + k] = 0;
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
                    metadata[(y * 16 + x) * 256 + k] = 0;
                    continue;
                }
                if (k < 75 + this.grassRaise) {
                    if (depth == 0) {
                        int r = (int)((float)(k - (62 + this.grassRaise)) / 2.0f);
                        if (rand.nextInt(r + 1) == 0) {
                            blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                            metadata[(y * 16 + x) * 256 + k] = 0;
                            continue;
                        }
                        if (rand.nextInt((int)((float)r / 2.0f) + 1) == 0) {
                            blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
                            metadata[(y * 16 + x) * 256 + k] = 1;
                            continue;
                        }
                        blocks[(y * 16 + x) * 256 + k] = this.topBlock;
                        metadata[(y * 16 + x) * 256 + k] = this.topBlockMeta;
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = this.fillerBlock;
                    metadata[(y * 16 + x) * 256 + k] = this.fillerBlockMeta;
                    continue;
                }
                if (depth == 0) {
                    blocks[(y * 16 + x) * 256 + k] = this.topBlock;
                    metadata[(y * 16 + x) * 256 + k] = this.topBlockMeta;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = this.fillerBlock;
                metadata[(y * 16 + x) * 256 + k] = this.fillerBlockMeta;
                continue;
            }
            if (k <= 63) continue;
            blocks[(y * 16 + x) * 256 + k] = CanyonColour.MESA.getBlockForHeight(i, effectiveHeight, j);
            metadata[(y * 16 + x) * 256 + k] = CanyonColour.MESA.getMetaForHeight(i, effectiveHeight, j);
        }
    }
}

