/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.feature;

import cpw.mods.fml.common.registry.GameData;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import rtg.config.rtg.ConfigRTG;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.util.TerrainMath;

public class WorldGenVolcano {
    protected static Block volcanoBlock = (Block)GameData.getBlockRegistry().func_82594_a(ConfigRTG.volcanoBlockId);
    protected static byte volcanoBlockMeta = (byte)ConfigRTG.volcanoBlockMeta;
    protected static Block volcanoPatchBlock = (Block)GameData.getBlockRegistry().func_82594_a(ConfigRTG.volcanoMix1BlockId);
    protected static byte volcanoPatchBlockMeta = (byte)ConfigRTG.volcanoMix1BlockMeta;
    protected static Block volcanoPatchBlock2 = (Block)GameData.getBlockRegistry().func_82594_a(ConfigRTG.volcanoMix2BlockId);
    protected static byte volcanoPatchBlockMeta2 = (byte)ConfigRTG.volcanoMix2BlockMeta;
    protected static Block volcanoPatchBlock3 = (Block)GameData.getBlockRegistry().func_82594_a(ConfigRTG.volcanoMix3BlockId);
    protected static byte volcanoPatchBlockMeta3 = (byte)ConfigRTG.volcanoMix3BlockMeta;
    protected static Block lavaBlock = ConfigRTG.enableVolcanoEruptions ? Blocks.field_150356_k : Blocks.field_150353_l;
    private static final float ventEccentricity = 8.0f;
    private static final float ventRadius = 7.0f;
    private static final int lavaHeight = 141 + (ConfigRTG.enableVolcanoEruptions ? 5 : 0);
    private static final int baseVolcanoHeight = 150;

    public static void build(Block[] blocks, byte[] metadata, World world, Random mapRand, int baseX, int baseY, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float[] noise) {
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                int y;
                int i = chunkX * 16 + x;
                int j = chunkY * 16 + z;
                float distanceEll = (float)TerrainMath.dis2Elliptic(i, j, baseX * 16, baseY * 16, simplex.noise2((float)i / 250.0f, (float)j / 250.0f) * 8.0f, simplex.octave(1).noise2((float)i / 250.0f, (float)j / 250.0f) * 8.0f);
                float obsidian = -5.0f + distanceEll;
                obsidian += simplex.octave(1).noise2((float)i / 55.0f, (float)j / 55.0f) * 12.0f;
                obsidian += simplex.octave(2).noise2((float)i / 25.0f, (float)j / 25.0f) * 5.0f;
                obsidian += simplex.octave(3).noise2((float)i / 9.0f, (float)j / 9.0f) * 3.0f;
                float ventNoise = simplex.noise2((float)i / 12.0f, (float)j / 12.0f) * 3.0f;
                if (distanceEll < 7.0f + (ventNoise += simplex.octave(1).noise2((float)i / 4.0f, (float)j / 4.0f) * 1.5f)) {
                    float height = simplex.noise2((float)i / 5.0f, (float)j / 5.0f) * 2.0f;
                    for (y = 255; y > -1; --y) {
                        if (y > lavaHeight) {
                            if (blocks[WorldGenVolcano.cta(x, y, z)] == Blocks.field_150350_a) continue;
                            blocks[WorldGenVolcano.cta((int)x, (int)y, (int)z)] = Blocks.field_150350_a;
                            continue;
                        }
                        if ((float)y > obsidian && (float)y < (float)(lavaHeight - 9) + height) {
                            blocks[WorldGenVolcano.cta((int)x, (int)y, (int)z)] = volcanoBlock;
                            metadata[WorldGenVolcano.cta((int)x, (int)y, (int)z)] = volcanoBlockMeta;
                            continue;
                        }
                        if (y < lavaHeight + 1) {
                            if (!(distanceEll + (float)y < (float)(lavaHeight + 3))) continue;
                            blocks[WorldGenVolcano.cta((int)x, (int)y, (int)z)] = lavaBlock;
                            continue;
                        }
                        if (!((float)y < obsidian + 1.0f)) continue;
                        if (blocks[WorldGenVolcano.cta(x, y, z)] != Blocks.field_150350_a) continue block1;
                        blocks[WorldGenVolcano.cta((int)x, (int)y, (int)z)] = Blocks.field_150348_b;
                        metadata[WorldGenVolcano.cta((int)x, (int)y, (int)z)] = 0;
                    }
                    continue;
                }
                float terrainHeight = 150.0f - (float)Math.pow(distanceEll, 0.89f);
                terrainHeight += simplex.octave(1).noise2((float)i / 112.0f, (float)j / 112.0f) * 5.5f;
                terrainHeight += simplex.octave(2).noise2((float)i / 46.0f, (float)j / 46.0f) * 4.5f;
                terrainHeight += simplex.octave(3).noise2((float)i / 16.0f, (float)j / 16.0f) * 2.5f;
                if ((terrainHeight += simplex.octave(4).noise2((float)i / 5.0f, (float)j / 5.0f) * 1.0f) > noise[x * 16 + z]) {
                    noise[x * 16 + z] = terrainHeight;
                }
                for (y = 255; y > -1; --y) {
                    if (!((float)y <= terrainHeight)) continue;
                    Block b = blocks[WorldGenVolcano.cta(x, y, z)];
                    byte meta = metadata[WorldGenVolcano.cta(x, y, z)];
                    if (b != Blocks.field_150350_a && b != Blocks.field_150355_j) continue block1;
                    if ((float)y > obsidian) {
                        if (distanceEll > 10.0f) {
                            float patchNoise;
                            if (distanceEll < 50.0f && WorldGenVolcano.isOnSurface(x, y, z, blocks)) {
                                patchNoise = simplex.noise2((float)i / 10.0f, (float)j / 10.0f) * 1.3f;
                                patchNoise = (float)((double)patchNoise + (double)simplex.octave(2).noise2((float)i / 30.0f, (float)j / 30.0f) * 0.9);
                                if ((double)(patchNoise = (float)((double)patchNoise + (double)simplex.octave(3).noise2((float)i / 5.0f, (float)j / 5.0f) * 0.6)) > 0.85) {
                                    blocks[WorldGenVolcano.cta((int)x, (int)y, (int)z)] = volcanoPatchBlock;
                                    metadata[WorldGenVolcano.cta((int)x, (int)y, (int)z)] = volcanoPatchBlockMeta;
                                    continue;
                                }
                            }
                            if (distanceEll < 75.0f && WorldGenVolcano.isOnSurface(x, y, z, blocks)) {
                                patchNoise = simplex.noise2((float)i / 10.0f, (float)j / 10.0f) * 1.3f;
                                patchNoise = (float)((double)patchNoise + (double)simplex.octave(4).noise2((float)i / 30.0f, (float)j / 30.0f) * 0.9);
                                if ((double)(patchNoise = (float)((double)patchNoise + (double)simplex.octave(5).noise2((float)i / 5.0f, (float)j / 5.0f) * 0.5)) > 0.92) {
                                    blocks[WorldGenVolcano.cta((int)x, (int)y, (int)z)] = volcanoPatchBlock2;
                                    metadata[WorldGenVolcano.cta((int)x, (int)y, (int)z)] = volcanoPatchBlockMeta2;
                                    continue;
                                }
                            }
                            if (distanceEll < 75.0f && WorldGenVolcano.isOnSurface(x, y, z, blocks)) {
                                patchNoise = simplex.noise2((float)i / 10.0f, (float)j / 10.0f) * 1.3f;
                                patchNoise = (float)((double)patchNoise + (double)simplex.octave(6).noise2((float)i / 30.0f, (float)j / 30.0f) * 0.7);
                                if ((double)(patchNoise = (float)((double)patchNoise + (double)simplex.octave(7).noise2((float)i / 5.0f, (float)j / 5.0f) * 0.7)) > 0.93) {
                                    blocks[WorldGenVolcano.cta((int)x, (int)y, (int)z)] = volcanoPatchBlock3;
                                    metadata[WorldGenVolcano.cta((int)x, (int)y, (int)z)] = volcanoPatchBlockMeta3;
                                    continue;
                                }
                            }
                        }
                        if (distanceEll < 70.0f + simplex.noise2((float)x / 26.0f, (float)y / 26.0f) * 5.0f) {
                            if (mapRand.nextInt(20) == 0) {
                                b = volcanoPatchBlock3;
                                meta = volcanoPatchBlockMeta3;
                            } else {
                                b = volcanoBlock;
                                meta = volcanoBlockMeta;
                            }
                        } else if (distanceEll < 75.0f + simplex.noise2((float)x / 26.0f, (float)y / 26.0f) * 5.0f) {
                            float powerNoise = simplex.octave(3).noise2(i / 40, (float)j / 40.0f) * 2.0f;
                            if (mapRand.nextInt(1 + (int)Math.pow(Math.abs(distanceEll - (75.0f + simplex.noise2((float)x / 26.0f, (float)y / 26.0f) * 5.0f)), 1.5 + (double)powerNoise) + 1) == 0) {
                                if (mapRand.nextInt(20) == 0) {
                                    b = volcanoPatchBlock2;
                                    meta = volcanoPatchBlockMeta2;
                                } else {
                                    b = Blocks.field_150348_b;
                                    meta = 0;
                                }
                            } else {
                                b = volcanoBlock;
                                meta = volcanoBlockMeta;
                            }
                        } else {
                            b = Blocks.field_150348_b;
                            meta = 0;
                        }
                    } else {
                        b = Blocks.field_150348_b;
                        meta = 0;
                    }
                    blocks[WorldGenVolcano.cta((int)x, (int)y, (int)z)] = b;
                    metadata[WorldGenVolcano.cta((int)x, (int)y, (int)z)] = meta;
                }
            }
        }
    }

    private static boolean isOnSurface(int x, int y, int z, Block[] blocks) {
        return blocks[WorldGenVolcano.cta(x, y + 1, z)] == Blocks.field_150350_a;
    }

    public static int cta(int x, int y, int z) {
        return (x * 16 + z) * 256 + y;
    }
}

