/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import rtg.config.rtg.ConfigRTG;
import rtg.util.BoulderUtil;
import rtg.util.RandomUtil;

public class WorldGenBlob
extends WorldGenerator {
    private Block blobBlock;
    private byte blobMeta;
    private int blobSize;
    private boolean booShouldGenerate;
    private static final String __OBFID = "CL_00000402";
    protected boolean water;
    protected BoulderUtil boulderUtil;

    public WorldGenBlob(Block b, int s, Random rand) {
        super(false);
        this.blobBlock = b;
        this.blobMeta = 0;
        this.blobSize = s;
        this.booShouldGenerate = true;
        this.water = true;
        this.boulderUtil = new BoulderUtil();
        if (this.blobBlock == Blocks.field_150341_Y || this.blobBlock == Blocks.field_150347_e) {
            if (!ConfigRTG.enableCobblestoneBoulders) {
                this.booShouldGenerate = false;
            } else if (!WorldGenBlob.shouldGenerateCobblestoneBoulder(rand)) {
                this.booShouldGenerate = false;
            }
        }
    }

    public WorldGenBlob(Block b, byte m, int s, Random rand) {
        this(b, s, rand);
        this.blobMeta = m;
    }

    public WorldGenBlob(Block b, byte m, int s, Random rand, boolean water) {
        this(b, m, s, rand);
        this.blobMeta = m;
        this.water = water;
    }

    public void generate(World world, Random rand, int x, int y, int z, boolean honourConfig) {
        if (honourConfig) {
            this.booShouldGenerate = true;
            if (!ConfigRTG.enableCobblestoneBoulders) {
                this.booShouldGenerate = false;
            } else if (!WorldGenBlob.shouldGenerateCobblestoneBoulder(rand)) {
                this.booShouldGenerate = false;
            }
        }
        this.func_76484_a(world, rand, x, y, z);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        if (!this.booShouldGenerate) {
            return false;
        }
        Block boulderBlock = this.boulderUtil.getBoulderBlock(this.blobBlock, x, y, z);
        byte boulderMeta = this.boulderUtil.getBoulderMeta(this.blobBlock, this.blobMeta, x, y, z);
        while (y > 3) {
            if (!world.func_147437_c(x, y - 1, z)) {
                Block block = world.func_147439_a(x, y - 1, z);
                if (!this.water) {
                    if (block.func_149688_o() == Material.field_151586_h) {
                        return false;
                    }
                    if (world.func_147439_a(x, y - 1, z - 1).func_149688_o() == Material.field_151586_h) {
                        return false;
                    }
                    if (world.func_147439_a(x, y - 1, z + 1).func_149688_o() == Material.field_151586_h) {
                        return false;
                    }
                    if (world.func_147439_a(x - 1, y - 1, z).func_149688_o() == Material.field_151586_h) {
                        return false;
                    }
                    if (world.func_147439_a(x - 1, y - 1, z - 1).func_149688_o() == Material.field_151586_h) {
                        return false;
                    }
                    if (world.func_147439_a(x - 1, y - 1, z + 1).func_149688_o() == Material.field_151586_h) {
                        return false;
                    }
                    if (world.func_147439_a(x + 1, y - 1, z).func_149688_o() == Material.field_151586_h) {
                        return false;
                    }
                    if (world.func_147439_a(x + 1, y - 1, z - 1).func_149688_o() == Material.field_151586_h) {
                        return false;
                    }
                    if (world.func_147439_a(x + 1, y - 1, z + 1).func_149688_o() == Material.field_151586_h) {
                        return false;
                    }
                }
                if (block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150348_b || block == Blocks.field_150351_n || block == Blocks.field_150354_m) break;
            }
            --y;
        }
        if (y <= 3) {
            return false;
        }
        int k2 = this.blobSize;
        for (int l = 0; k2 >= 0 && l < 3; ++l) {
            int i1 = k2 + rand.nextInt(2);
            int j1 = k2 + rand.nextInt(2);
            int k1 = k2 + rand.nextInt(2);
            float f = (float)(i1 + j1 + k1) * 0.333f + 0.5f;
            for (int l1 = x - i1; l1 <= x + i1; ++l1) {
                for (int i2 = z - k1; i2 <= z + k1; ++i2) {
                    for (int j2 = y - j1; j2 <= y + j1; ++j2) {
                        float f1 = l1 - x;
                        float f2 = i2 - z;
                        float f3 = j2 - y;
                        if (!(f1 * f1 + f2 * f2 + f3 * f3 <= f * f)) continue;
                        world.func_147465_d(l1, j2, i2, boulderBlock, (int)boulderMeta, 2);
                    }
                }
            }
            x += -(k2 + 1) + rand.nextInt(2 + k2 * 2);
            z += -(k2 + 1) + rand.nextInt(2 + k2 * 2);
            y += 0 - rand.nextInt(2);
        }
        return true;
    }

    public static boolean shouldGenerateCobblestoneBoulder(Random rand) {
        int chance = ConfigRTG.cobblestoneBoulderChance;
        chance = chance < 1 ? 1 : (chance > 100 ? 100 : chance);
        int random = RandomUtil.getRandomInt(rand, 1, chance);
        boolean booGenerate = random == 1;
        return booGenerate;
    }
}

