/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.vanilla;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.api.biome.BiomeConfig;
import rtg.world.biome.deco.DecoBaseBiomeDecorations;
import rtg.world.biome.deco.DecoFallenTree;
import rtg.world.biome.deco.DecoGrass;
import rtg.world.biome.deco.DecoPumpkin;
import rtg.world.biome.deco.DecoShrub;
import rtg.world.biome.deco.DecoTree;
import rtg.world.biome.realistic.vanilla.RealisticBiomeVanillaBase;
import rtg.world.gen.feature.tree.rtg.TreeRTGPinusPonderosa;
import rtg.world.gen.feature.tree.rtg.TreeRTGSalixMyrtilloides;
import rtg.world.gen.surface.vanilla.SurfaceVanillaSwampland;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.vanilla.TerrainVanillaSwampland;

public class RealisticBiomeVanillaSwampland
extends RealisticBiomeVanillaBase {
    public static Block topBlock = BiomeGenBase.field_76780_h.field_76752_A;
    public static Block fillerBlock = BiomeGenBase.field_76780_h.field_76753_B;

    public RealisticBiomeVanillaSwampland(BiomeConfig config) {
        super(config, BiomeGenBase.field_76780_h, BiomeGenBase.field_76781_i, (TerrainBase)new TerrainVanillaSwampland(), new SurfaceVanillaSwampland(config, topBlock, fillerBlock));
        TreeRTGSalixMyrtilloides myrtilloidesTree = new TreeRTGSalixMyrtilloides();
        myrtilloidesTree.logBlock = Blocks.field_150364_r;
        myrtilloidesTree.logMeta = 0;
        myrtilloidesTree.leavesBlock = Blocks.field_150362_t;
        myrtilloidesTree.leavesMeta = 0;
        this.addTree(myrtilloidesTree);
        DecoTree decoTrees = new DecoTree(myrtilloidesTree);
        decoTrees.strengthNoiseFactorXForLoops = true;
        decoTrees.strengthFactorForLoops = 1.0f;
        decoTrees.distribution.noiseDivisor = 80.0f;
        decoTrees.distribution.noiseFactor = 60.0f;
        decoTrees.distribution.noiseAddend = -15.0f;
        decoTrees.treeType = DecoTree.TreeType.RTG_TREE;
        decoTrees.treeCondition = DecoTree.TreeCondition.RANDOM_CHANCE;
        decoTrees.treeConditionChance = 12;
        decoTrees.maxY = 70;
        this.addDeco(decoTrees);
        TreeRTGPinusPonderosa ponderosaTree = new TreeRTGPinusPonderosa();
        ponderosaTree.logBlock = Blocks.field_150364_r;
        ponderosaTree.logMeta = 0;
        ponderosaTree.leavesBlock = Blocks.field_150362_t;
        ponderosaTree.leavesMeta = 0;
        ponderosaTree.minTrunkSize = 3;
        ponderosaTree.maxTrunkSize = 6;
        ponderosaTree.minCrownSize = 6;
        ponderosaTree.maxCrownSize = 14;
        ponderosaTree.noLeaves = true;
        this.addTree(ponderosaTree);
        DecoTree deadPineTree = new DecoTree(ponderosaTree);
        deadPineTree.treeType = DecoTree.TreeType.RTG_TREE;
        deadPineTree.treeCondition = DecoTree.TreeCondition.RANDOM_CHANCE;
        deadPineTree.treeConditionChance = 18;
        deadPineTree.maxY = 100;
        this.addDeco(deadPineTree);
        DecoShrub decoShrub = new DecoShrub();
        decoShrub.maxY = 100;
        decoShrub.strengthFactor = 3.0f;
        this.addDeco(decoShrub);
        DecoFallenTree decoFallenTree = new DecoFallenTree();
        decoFallenTree.distribution.noiseDivisor = 80.0f;
        decoFallenTree.distribution.noiseFactor = 60.0f;
        decoFallenTree.distribution.noiseAddend = -15.0f;
        decoFallenTree.logCondition = DecoFallenTree.LogCondition.NOISE_GREATER_AND_RANDOM_CHANCE;
        decoFallenTree.logConditionNoise = 0.0f;
        decoFallenTree.logConditionChance = 6;
        decoFallenTree.logBlock = Blocks.field_150363_s;
        decoFallenTree.logMeta = 1;
        decoFallenTree.leavesBlock = Blocks.field_150361_u;
        decoFallenTree.leavesMeta = (byte)-1;
        decoFallenTree.minSize = 3;
        decoFallenTree.maxSize = 6;
        this.addDeco(decoFallenTree, this.config._boolean("decorationLogs"));
        DecoBaseBiomeDecorations decoBaseBiomeDecorations = new DecoBaseBiomeDecorations();
        this.addDeco(decoBaseBiomeDecorations);
        DecoPumpkin decoPumpkin = new DecoPumpkin();
        decoPumpkin.maxY = 90;
        decoPumpkin.randomType = DecoPumpkin.RandomType.X_DIVIDED_BY_STRENGTH;
        decoPumpkin.randomFloat = 50.0f;
        this.addDeco(decoPumpkin);
        DecoGrass decoGrass = new DecoGrass();
        decoGrass.maxY = 128;
        decoGrass.strengthFactor = 12.0f;
        this.addDeco(decoGrass);
    }
}

