/*
 * Decompiled with CFR 0.152.
 */
package wildCaves.generation.structureGen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import wildCaves.Utils;
import wildCaves.WildCaves;

public class DecorationHelper {
    public static void generateFloodedCaves(World world, Random random, int x, int y, int z) {
        int k;
        int i;
        int blocks = 0;
        for (i = x - 3; i < x + 3; ++i) {
            for (k = z - 3; k < z + 3; ++k) {
                if ((blocks += Utils.getNumEmptyBlocks(world, i, y, k)) <= 400) continue;
                return;
            }
        }
        if (blocks > 150) {
            y -= Utils.getNumEmptyBlocks(world, x, y, z) / 3 * 2;
            for (i = x - 3; i < x + 3; ++i) {
                for (k = z - 3; k < z + 3; ++k) {
                    if (!world.func_147437_c(i, y, k)) continue;
                    world.func_147465_d(i, y, k, (Block)Blocks.field_150358_i, 0, 2);
                }
            }
        }
    }

    public static boolean generateGlowcaps(World world, Random random, int x, int y, int z) {
        int vary = Utils.getNumEmptyBlocks(world, x, y, z);
        if (vary != 0) {
            y = y - vary + 1;
        }
        if (!world.func_147437_c(x, y - 1, z)) {
            int glowcapNum = world.func_147437_c(x, y + 1, z) ? random.nextInt(5) : random.nextInt(4);
            world.func_147465_d(x, y, z, WildCaves.blockFlora, glowcapNum, 2);
            if (glowcapNum == 4) {
                world.func_147465_d(x, y + 1, z, WildCaves.blockFlora, glowcapNum + 1, 2);
            }
            return true;
        }
        return false;
    }

    public static void generateIceshrooms(World world, Random random, int x, int y, int z) {
        int vary = Utils.getNumEmptyBlocks(world, x, y, z);
        if (vary != 0) {
            y = y - vary + 1;
        }
        if (!world.func_147437_c(x, y - 1, z)) {
            if (!world.func_147439_a(x, y, z).func_149688_o().func_76224_d()) {
                world.func_147465_d(x, y - 1, z, Utils.frozen, 0, 2);
                world.func_147465_d(x, y, z, WildCaves.blockFlora, Utils.randomChoise(6, 7, 8, 9), 2);
            }
            Utils.convertToFrozenType(world, random, x, y, z);
        }
    }

    public static void generateIcicles(World world, Random random, int x, int y, int z, int distance) {
        world.func_147465_d(x, y + 1, z, Utils.frozen, 0, 2);
        world.func_147465_d(x, y, z, WildCaves.blockDecorations, Utils.randomChoise(0, 1, 2), 2);
        Utils.convertToFrozenType(world, random, x, y, z);
        int botY = y - distance + 1;
        if (distance != 0 && !world.func_147439_a(x, botY, z).func_149688_o().func_76224_d()) {
            Utils.convertToFrozenType(world, random, x, botY, z);
        }
    }

    public static void generateSkulls(World world, Random random, int x, int y, int z, int numEmptyBlocks) {
        int auxY;
        if (numEmptyBlocks > 0 && (auxY = y - numEmptyBlocks + 1) > 0 && numEmptyBlocks > 0) {
            world.func_147465_d(x, auxY, z, Blocks.field_150465_bP, 1, 2);
            TileEntity skullTE = world.func_147438_o(x, auxY, z);
            if (skullTE instanceof TileEntitySkull) {
                ((TileEntitySkull)skullTE).func_145903_a(random.nextInt(360));
            }
        }
    }

    public static void generateVines(World world, Random random, int x, int y, int z) {
        int distance = Utils.getNumEmptyBlocks(world, x, y, z);
        int aux = distance > 5 ? random.nextInt(distance - 5) + 5 : distance;
        int side = random.nextInt(4) + 2;
        for (int i = 0; i < aux && !world.func_147439_a(x, y - i, z).func_149688_o().func_76224_d(); ++i) {
            world.func_147465_d(x, y - i, z, Blocks.field_150395_bd, 1 << Direction.field_71579_d[side], 0);
        }
    }
}

