/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.script.command;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.Collection;
import java.util.Iterator;
import me.superckl.api.biometweaker.event.BiomeTweakEvent;
import me.superckl.api.biometweaker.script.pack.IBiomePackage;
import me.superckl.api.biometweaker.util.SpawnListType;
import me.superckl.api.superscript.command.IScriptCommand;
import me.superckl.biometweaker.config.Config;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;

public class ScriptCommandAddRemoveSpawn
implements IScriptCommand {
    private final IBiomePackage pack;
    private final boolean remove;
    private final SpawnListType type;
    private final String entityClass;
    private final int weight;
    private final int minCount;
    private final int maxCount;

    public ScriptCommandAddRemoveSpawn(IBiomePackage pack, String entityClass, SpawnListType type, int weight, int minCount, int maxCount) {
        this(pack, false, type, entityClass, weight, minCount, maxCount);
    }

    public ScriptCommandAddRemoveSpawn(IBiomePackage pack, String entityClass, SpawnListType type) {
        this(pack, true, type, entityClass, 0, 0, 0);
    }

    @Override
    public void perform() throws Exception {
        Class<?> clazz;
        try {
            clazz = Class.forName(this.entityClass);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to load entity class: " + this.entityClass, e);
        }
        BiomeGenBase.SpawnListEntry entry = new BiomeGenBase.SpawnListEntry(clazz, this.weight, this.minCount, this.maxCount);
        Iterator<BiomeGenBase> it = this.pack.getIterator();
        while (it.hasNext()) {
            BiomeGenBase gen = it.next();
            if (this.remove && MinecraftForge.EVENT_BUS.post((Event)new BiomeTweakEvent.RemoveSpawn(this, gen, this.type, clazz)) || !this.remove && MinecraftForge.EVENT_BUS.post((Event)new BiomeTweakEvent.AddSpawn(this, gen, entry))) continue;
            this.handleTypeSwitch(gen, entry, clazz);
            Config.INSTANCE.onTweak(gen.field_76756_M);
        }
    }

    private void handleTypeSwitch(BiomeGenBase gen, BiomeGenBase.SpawnListEntry entry, Class<?> clazz) {
        switch (this.type) {
            case CAVE_CREATURE: {
                if (this.remove) {
                    this.removeEntry(clazz, gen.field_82914_M);
                    break;
                }
                gen.field_82914_M.add(entry);
                break;
            }
            case CREATURE: {
                if (this.remove) {
                    this.removeEntry(clazz, gen.field_76762_K);
                    break;
                }
                gen.field_76762_K.add(entry);
                break;
            }
            case MONSTER: {
                if (this.remove) {
                    this.removeEntry(clazz, gen.field_76761_J);
                    break;
                }
                gen.field_76761_J.add(entry);
                break;
            }
            case WATER_CREATURE: {
                if (this.remove) {
                    this.removeEntry(clazz, gen.field_76755_L);
                    break;
                }
                gen.field_76755_L.add(entry);
                break;
            }
        }
    }

    private void removeEntry(Class<?> clazz, Collection<BiomeGenBase.SpawnListEntry> coll) {
        Iterator<BiomeGenBase.SpawnListEntry> it = coll.iterator();
        while (it.hasNext()) {
            if (!it.next().field_76300_b.getName().equals(clazz.getName())) continue;
            it.remove();
        }
    }

    private ScriptCommandAddRemoveSpawn(IBiomePackage pack, boolean remove, SpawnListType type, String entityClass, int weight, int minCount, int maxCount) {
        this.pack = pack;
        this.remove = remove;
        this.type = type;
        this.entityClass = entityClass;
        this.weight = weight;
        this.minCount = minCount;
        this.maxCount = maxCount;
    }
}

