/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.common.handler;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import me.superckl.biometweaker.common.world.gen.layer.GenLayerReplacement;
import me.superckl.biometweaker.util.LogHelper;
import me.superckl.biometweaker.util.NumberHelper;
import net.minecraft.block.Block;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.WorldTypeEvent;
import org.apache.commons.lang3.tuple.Pair;

public class BiomeEventHandler {
    public static byte globalSize = (byte)-1;
    public static final Map<WorldType, Byte> sizes = Maps.newIdentityHashMap();
    private static final TIntObjectMap<List<Pair<Pair<Block, Integer>, List<WeightedBlockEntry>>>> blockReplacements = new TIntObjectHashMap();
    private static final TIntObjectMap<List<Pair<Block, Pair<Block, Integer>>>> villageBlockReplacements = new TIntObjectHashMap();
    private static final boolean[] contigReplaces = new boolean[256];
    private static final TIntIntMap biomeReplacements = new TIntIntHashMap();
    private static final TIntObjectMap<List<String>> decorateTypes = new TIntObjectHashMap();
    private static final TIntObjectMap<List<String>> populateTypes = new TIntObjectHashMap();
    private static final TIntIntMap waterlilyPerChunk = new TIntIntHashMap();
    private static final TIntIntMap treesPerChunk = new TIntIntHashMap();
    private static final TIntIntMap flowersPerChunk = new TIntIntHashMap();
    private static final TIntIntMap grassPerChunk = new TIntIntHashMap();
    private static final TIntIntMap deadBushPerChunk = new TIntIntHashMap();
    private static final TIntIntMap mushroomPerChunk = new TIntIntHashMap();
    private static final TIntIntMap reedsPerChunk = new TIntIntHashMap();
    private static final TIntIntMap cactiPerChunk = new TIntIntHashMap();
    private static final TIntIntMap sandPerChunk = new TIntIntHashMap();
    private static final TIntIntMap clayPerChunk = new TIntIntHashMap();
    private static final TIntIntMap bigMushroomsPerChunk = new TIntIntHashMap();
    private Field grassColor;
    private Field foliageColor;
    private Field waterColor;
    private final int[] colorCache = new int[768];
    private final Map<World, Map<ChunkCoordIntPair, TIntObjectMap<Map<Block, TIntObjectMap<WeightedBlockEntry>>>>> replacedBiomes = Maps.newHashMap();

    public BiomeEventHandler() {
        Arrays.fill(this.colorCache, -2);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onReplaceBlocks(ChunkProviderEvent.ReplaceBiomeBlocks e) {
        try {
            if (!this.replacedBiomes.containsKey(e.world)) {
                this.replacedBiomes.put(e.world, Maps.newHashMap());
            }
            if (blockReplacements.isEmpty()) {
                return;
            }
            TIntObjectMap<Map<Block, TIntObjectMap<WeightedBlockEntry>>> shouldDoBMap = this.findMap(e.world, new ChunkCoordIntPair(e.chunkX, e.chunkZ));
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    BiomeGenBase biomegenbase = e.biomeArray[l + k * 16];
                    if (!blockReplacements.containsKey(biomegenbase.field_76756_M)) continue;
                    if (!shouldDoBMap.containsKey(biomegenbase.field_76756_M)) {
                        shouldDoBMap.put(biomegenbase.field_76756_M, (Object)Maps.newIdentityHashMap());
                    }
                    Map shouldDoMap = (Map)shouldDoBMap.get(biomegenbase.field_76756_M);
                    List list = (List)blockReplacements.get(biomegenbase.field_76756_M);
                    int i1 = k;
                    int j1 = l;
                    int k1 = e.blockArray.length / 256;
                    for (int l1 = k1 - 1; l1 >= 0; --l1) {
                        Integer meta;
                        int i2 = (j1 * 16 + i1) * k1 + l1;
                        Block block2 = e.blockArray[i2];
                        WeightedBlockEntry toUse = null;
                        if (shouldDoMap.containsKey(block2)) {
                            TIntObjectMap map = (TIntObjectMap)shouldDoMap.get(block2);
                            if (map.containsKey(e.metaArray == null ? 0 : e.metaArray[i2])) {
                                toUse = (WeightedBlockEntry)((Object)map.get(e.metaArray == null ? 0 : e.metaArray[i2]));
                            } else if (map.containsKey(-1)) {
                                toUse = (WeightedBlockEntry)((Object)map.get(-1));
                            }
                        }
                        if (toUse == null) {
                            for (Pair pair : list) {
                                boolean shouldDo;
                                if (((Pair)pair.getKey()).getKey() != block2 || !(shouldDo = (meta = (Integer)((Pair)pair.getKey()).getValue()) == null || e.metaArray == null && meta == 0 || e.metaArray[i2] == meta)) continue;
                                toUse = (WeightedBlockEntry)WeightedRandom.func_76271_a((Random)e.world.field_73012_v, (Collection)((Collection)pair.getValue()));
                                if (!shouldDoMap.containsKey(block2)) {
                                    shouldDoMap.put(block2, new TIntObjectHashMap());
                                }
                                TIntObjectMap map = (TIntObjectMap)shouldDoMap.get(block2);
                                map.put(meta == null ? -1 : meta, (Object)toUse);
                            }
                        }
                        if (toUse == null) continue;
                        e.blockArray[i2] = (Block)toUse.block.getKey();
                        if (e.metaArray == null) continue;
                        meta = (Integer)toUse.block.getValue();
                        e.metaArray[i2] = (byte)(meta == null ? 0 : meta);
                    }
                }
            }
            TIntIterator it = shouldDoBMap.keySet().iterator();
            while (it.hasNext()) {
                if (contigReplaces[it.next()]) continue;
                it.remove();
            }
            this.replacedBiomes.get(e.world).put(new ChunkCoordIntPair(e.chunkX, e.chunkZ), shouldDoBMap);
        }
        catch (Exception e1) {
            LogHelper.error("Failed to process replace biome blocks event.");
            e1.printStackTrace();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onGetGrassColor(BiomeEvent.GetGrassColor e) {
        try {
            int newColor;
            if (this.grassColor == null) {
                this.grassColor = BiomeGenBase.class.getDeclaredField("grassColor");
            }
            if ((newColor = this.colorCache[e.biome.field_76756_M]) == -1) {
                return;
            }
            newColor = this.colorCache[e.biome.field_76756_M];
            if (newColor != -2) {
                e.newColor = newColor;
            } else {
                this.colorCache[e.biome.field_76756_M] = newColor = this.grassColor.getInt(e.biome);
                if (newColor == -1) {
                    return;
                }
                e.newColor = newColor;
            }
        }
        catch (Exception e1) {
            LogHelper.error("Failed to process getGrassColor event!");
            e1.printStackTrace();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onGetFoliageColor(BiomeEvent.GetFoliageColor e) {
        try {
            int newColor;
            if (this.foliageColor == null) {
                this.foliageColor = BiomeGenBase.class.getDeclaredField("foliageColor");
            }
            if ((newColor = this.colorCache[e.biome.field_76756_M + 256]) == -1) {
                return;
            }
            newColor = this.colorCache[e.biome.field_76756_M + 256];
            if (newColor != -2) {
                e.newColor = newColor;
            } else {
                this.colorCache[e.biome.field_76756_M + 256] = newColor = this.foliageColor.getInt(e.biome);
                if (newColor == -1) {
                    return;
                }
                e.newColor = newColor;
            }
        }
        catch (Exception e1) {
            LogHelper.error("Failed to process getFoliageColor event!");
            e1.printStackTrace();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onGetWaterColor(BiomeEvent.GetWaterColor e) {
        try {
            int newColor;
            if (this.waterColor == null) {
                this.waterColor = BiomeGenBase.class.getDeclaredField("waterColor");
            }
            if ((newColor = this.colorCache[e.biome.field_76756_M + 512]) == -1) {
                return;
            }
            newColor = this.colorCache[e.biome.field_76756_M + 512];
            if (newColor != -2) {
                e.newColor = newColor;
            } else {
                this.colorCache[e.biome.field_76756_M + 512] = newColor = this.waterColor.getInt(e.biome);
                if (newColor == -1) {
                    return;
                }
                e.newColor = newColor;
            }
        }
        catch (Exception e1) {
            LogHelper.error("Failed to process getWaterColor event!");
            e1.printStackTrace();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBiomeDecorate(DecorateBiomeEvent.Decorate e) {
        if (decorateTypes.isEmpty()) {
            return;
        }
        BiomeGenBase gen = e.world.func_72807_a(e.chunkX, e.chunkZ);
        boolean isAll = decorateTypes.containsKey(-1);
        if ((isAll || decorateTypes.containsKey(gen.field_76756_M)) && (((List)decorateTypes.get(isAll ? -1 : gen.field_76756_M)).contains(e.type.name()) || ((List)decorateTypes.get(isAll ? -1 : gen.field_76756_M)).contains("all"))) {
            e.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBiomePopulate(PopulateChunkEvent.Populate e) {
        if (populateTypes.isEmpty()) {
            return;
        }
        BiomeGenBase gen = e.world.func_72807_a(e.chunkX, e.chunkZ);
        boolean isAll = populateTypes.containsKey(-1);
        if ((isAll || populateTypes.containsKey(gen.field_76756_M)) && (((List)populateTypes.get(isAll ? -1 : gen.field_76756_M)).contains(e.type.name()) || ((List)populateTypes.get(isAll ? -1 : gen.field_76756_M)).contains("all"))) {
            e.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onCreateBiomeDecorator(BiomeEvent.CreateDecorator e) {
        int id = e.biome.field_76756_M;
        if (waterlilyPerChunk.containsKey(id)) {
            e.newBiomeDecorator.field_76833_y = waterlilyPerChunk.get(id);
        }
        if (treesPerChunk.containsKey(id)) {
            e.newBiomeDecorator.field_76832_z = treesPerChunk.get(id);
        }
        if (flowersPerChunk.containsKey(id)) {
            e.newBiomeDecorator.field_76802_A = flowersPerChunk.get(id);
        }
        if (grassPerChunk.containsKey(id)) {
            e.newBiomeDecorator.field_76803_B = grassPerChunk.get(id);
        }
        if (deadBushPerChunk.containsKey(id)) {
            e.newBiomeDecorator.field_76804_C = deadBushPerChunk.get(id);
        }
        if (mushroomPerChunk.containsKey(id)) {
            e.newBiomeDecorator.field_76798_D = mushroomPerChunk.get(id);
        }
        if (reedsPerChunk.containsKey(id)) {
            e.newBiomeDecorator.field_76799_E = reedsPerChunk.get(id);
        }
        if (cactiPerChunk.containsKey(id)) {
            e.newBiomeDecorator.field_76800_F = cactiPerChunk.get(id);
        }
        if (sandPerChunk.containsKey(id)) {
            e.newBiomeDecorator.field_76801_G = sandPerChunk.get(id);
        }
        if (clayPerChunk.containsKey(id)) {
            e.newBiomeDecorator.field_76806_I = clayPerChunk.get(id);
        }
        if (bigMushroomsPerChunk.containsKey(id)) {
            e.newBiomeDecorator.field_76807_J = bigMushroomsPerChunk.get(id);
        }
    }

    @SubscribeEvent
    public void onGetBiomeSize(WorldTypeEvent.BiomeSize e) {
        if (globalSize != -1) {
            e.newSize = globalSize;
        } else if (sizes.containsKey(e.worldType)) {
            e.newSize = sizes.get(e.worldType);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onInitBiomeGens(WorldTypeEvent.InitBiomeGens e) {
        e.newBiomeGens[0] = new GenLayerReplacement(e.newBiomeGens[0]);
        e.newBiomeGens[1] = new GenLayerReplacement(e.newBiomeGens[1]);
    }

    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=true)
    public void onReplaceVillageBlockID(BiomeEvent.GetVillageBlockID e) {
        if (e.biome == null || e.original == null) {
            return;
        }
        List list = (List)villageBlockReplacements.get(e.biome.field_76756_M);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (Pair fPair : list) {
            if (fPair.getKey() != (e.replacement == null ? e.original : e.replacement)) continue;
            e.replacement = (Block)((Pair)fPair.getValue()).getKey();
            e.setResult(Event.Result.DENY);
            break;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=true)
    public void onReplaceVillageBlockMeta(BiomeEvent.GetVillageBlockMeta e) {
        if (e.biome == null || e.original == null) {
            return;
        }
        List list = (List)villageBlockReplacements.get(e.biome.field_76756_M);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (Pair fPair : list) {
            if (fPair.getKey() != e.original) continue;
            Integer i = (Integer)((Pair)fPair.getValue()).getValue();
            e.replacement = i == null ? 0 : i;
            e.setResult(Event.Result.DENY);
            break;
        }
    }

    private TIntObjectMap<Map<Block, TIntObjectMap<WeightedBlockEntry>>> findMap(World world, ChunkCoordIntPair pair) {
        ChunkCoordIntPair[] pairs;
        Map<ChunkCoordIntPair, TIntObjectMap<Map<Block, TIntObjectMap<WeightedBlockEntry>>>> map = this.replacedBiomes.get(world);
        for (ChunkCoordIntPair search : pairs = NumberHelper.fillGrid(4, pair)) {
            if (!map.containsKey(search)) continue;
            return map.get(search);
        }
        return new TIntObjectHashMap();
    }

    public static TIntObjectMap<List<Pair<Pair<Block, Integer>, List<WeightedBlockEntry>>>> getBlockReplacements() {
        return blockReplacements;
    }

    public static TIntObjectMap<List<Pair<Block, Pair<Block, Integer>>>> getVillageBlockReplacements() {
        return villageBlockReplacements;
    }

    public static boolean[] getContigReplaces() {
        return contigReplaces;
    }

    public static TIntIntMap getBiomeReplacements() {
        return biomeReplacements;
    }

    public static TIntObjectMap<List<String>> getDecorateTypes() {
        return decorateTypes;
    }

    public static TIntObjectMap<List<String>> getPopulateTypes() {
        return populateTypes;
    }

    public static TIntIntMap getWaterlilyPerChunk() {
        return waterlilyPerChunk;
    }

    public static TIntIntMap getTreesPerChunk() {
        return treesPerChunk;
    }

    public static TIntIntMap getFlowersPerChunk() {
        return flowersPerChunk;
    }

    public static TIntIntMap getGrassPerChunk() {
        return grassPerChunk;
    }

    public static TIntIntMap getDeadBushPerChunk() {
        return deadBushPerChunk;
    }

    public static TIntIntMap getMushroomPerChunk() {
        return mushroomPerChunk;
    }

    public static TIntIntMap getReedsPerChunk() {
        return reedsPerChunk;
    }

    public static TIntIntMap getCactiPerChunk() {
        return cactiPerChunk;
    }

    public static TIntIntMap getSandPerChunk() {
        return sandPerChunk;
    }

    public static TIntIntMap getClayPerChunk() {
        return clayPerChunk;
    }

    public static TIntIntMap getBigMushroomsPerChunk() {
        return bigMushroomsPerChunk;
    }

    public static class WeightedBlockEntry
    extends WeightedRandom.Item {
        private final Pair<Block, Integer> block;

        public WeightedBlockEntry(int weight, Pair<Block, Integer> block) {
            super(weight);
            this.block = block;
        }

        public Pair<Block, Integer> getBlock() {
            return this.block;
        }
    }
}

