/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.utils;

import com.chocolate.chocolateQuest.entity.EntityHumanBase;
import com.chocolate.chocolateQuest.items.ItemArmorBull;
import com.chocolate.chocolateQuest.items.ItemArmorMage;
import com.chocolate.chocolateQuest.items.ItemArmorSlime;
import com.chocolate.chocolateQuest.items.ItemArmorSpider;
import com.chocolate.chocolateQuest.items.ItemArmorTurtle;
import com.chocolate.chocolateQuest.items.ItemHookShoot;
import com.chocolate.chocolateQuest.items.ItemStaffBase;
import com.chocolate.chocolateQuest.items.gun.ItemPistol;
import com.chocolate.chocolateQuest.items.swords.ItemCQBlade;
import com.chocolate.chocolateQuest.magic.Awakements;
import com.chocolate.chocolateQuest.magic.Elements;
import com.chocolate.chocolateQuest.magic.IElementWeak;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;

public class BDHelper {
    public static final ResourceLocation texture = new ResourceLocation("chocolateQuest:textures/entity/items.png");
    public static final ResourceLocation guiButtonsTexture = new ResourceLocation("chocolateQuest:textures/entity/gui.png");
    public static final ResourceLocation guiParticleTexture = new ResourceLocation("chocolateQuest:textures/entity/particles.png");

    public static Elements getElementFromDamageSource(DamageSource ds) {
        Elements element = Elements.physic;
        if (ds.func_76347_k()) {
            element = Elements.fire;
        } else if (ds.func_82725_o()) {
            element = Elements.magic;
        } else if (ds.func_94541_c()) {
            element = Elements.blast;
        }
        return element;
    }

    public static double getDamageReductionForElement(EntityLivingBase entity, Elements element, boolean checkEnchantments) {
        double damageReduction = 1.0;
        if (checkEnchantments) {
            int enchantType = -1;
            if (element == Elements.fire) {
                enchantType = Enchantment.field_77329_d.field_77352_x;
            } else if (element == Elements.blast) {
                enchantType = Enchantment.field_77327_f.field_77352_x;
            }
            if (enchantType != -1) {
                damageReduction = BDHelper.getEnchantmentDamageReduction(entity, enchantType);
            }
        }
        damageReduction *= BDHelper.getNaturalDamageReduction(entity, element);
        return damageReduction *= BDHelper.getAwakementDamageReduction(entity, element);
    }

    public static double getEnchantmentDamageReduction(EntityLivingBase entity, int enchantType) {
        double epf = enchantType == Enchantment.field_77332_c.field_77352_x ? 0.75 : (enchantType == Enchantment.field_77329_d.field_77352_x ? 1.25 : 1.5);
        int totalEnchantProtection = 0;
        for (int i = 0; i < 4; ++i) {
            int enchantLevel;
            ItemStack is = entity.func_71124_b(1 + i);
            if (is == null || (enchantLevel = EnchantmentHelper.func_77506_a((int)enchantType, (ItemStack)is)) <= 0) continue;
            totalEnchantProtection = (int)((double)totalEnchantProtection + Math.floor((double)(6 + enchantLevel * enchantLevel) * epf / 3.0));
        }
        totalEnchantProtection = Math.min(totalEnchantProtection, 20);
        double avgDamage = 0.75;
        return 1.0 - (double)totalEnchantProtection * 0.04 * avgDamage;
    }

    public static double getNaturalDamageReduction(EntityLivingBase entity, Elements element) {
        double damageReduction = 1.0;
        if (entity instanceof IElementWeak) {
            double naturalDefense = 0.0;
            if (element == Elements.fire) {
                naturalDefense = (double)((IElementWeak)entity).getFireDefense() * 0.01;
            } else if (element == Elements.physic) {
                naturalDefense = (double)((IElementWeak)entity).getPhysicDefense() * 0.01;
            } else if (element == Elements.magic) {
                naturalDefense = (double)((IElementWeak)entity).getMagicDefense() * 0.01;
            } else if (element == Elements.blast) {
                naturalDefense = (double)((IElementWeak)entity).getBlastDefense() * 0.01;
            }
            damageReduction = 1.0 - naturalDefense;
        }
        return damageReduction;
    }

    public static double getAwakementDamageReduction(EntityLivingBase entity, Elements element) {
        double damageReduction = 1.0;
        for (int i = 0; i < 4; ++i) {
            ItemStack armor = entity.func_71124_b(1 + i);
            if (armor == null || Awakements.getEnchantLevel(armor, Awakements.elementProtection) <= 0) continue;
            damageReduction -= 0.05 + (double)Elements.getElementValue(armor, element) * 0.0375;
        }
        return damageReduction;
    }

    public static double getRandomValue(Random random) {
        int it = 3;
        double d = 0.0;
        for (int i = 0; i < it; ++i) {
            if (random.nextInt(it) < i) continue;
            d += random.nextDouble();
        }
        return d / (double)it;
    }

    public static void addAttribute(ItemStack is, String attributeName, AttributeModifier attribute) {
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        NBTTagList tagList = is.field_77990_d.func_74764_b("AttributeModifiers") ? is.field_77990_d.func_150295_c("AttributeModifiers", 10) : new NBTTagList();
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("AttributeName", attributeName);
        tag.func_74778_a("Name", attribute.func_111166_b());
        tag.func_74780_a("Amount", attribute.func_111164_d());
        tag.func_74768_a("Operation", attribute.func_111169_c());
        tag.func_74772_a("UUIDLeast", attribute.func_111167_a().getLeastSignificantBits());
        tag.func_74772_a("UUIDMost", attribute.func_111167_a().getMostSignificantBits());
        tagList.func_74742_a((NBTBase)tag);
        is.field_77990_d.func_74782_a("AttributeModifiers", (NBTBase)tagList);
    }

    public static float getEntityValue(EntityHumanBase entity) {
        float entityValue = 0.0f;
        float healthValue = entity.func_110138_aP() / 4.0f;
        float armorValue = 0.0f;
        for (int i = 0; i < 4; ++i) {
            ItemStack is = entity.func_71124_b(i + 1);
            if (is == null || !(is.func_77973_b() instanceof ItemArmor)) continue;
            armorValue += (float)((ItemArmor)is.func_77973_b()).func_82812_d().func_78044_b(i);
            if (is.func_77973_b() instanceof ItemArmorMage) {
                armorValue += 4.0f;
            }
            if (is.func_77973_b() instanceof ItemArmorTurtle) {
                armorValue += 2.0f;
            }
            if (is.func_77973_b() instanceof ItemArmorSpider) {
                armorValue += 1.0f;
            }
            if (is.func_77973_b() instanceof ItemArmorSlime) {
                armorValue += 2.0f;
            }
            if (!(is.func_77973_b() instanceof ItemArmorBull)) continue;
            armorValue += 2.0f;
        }
        entityValue = healthValue * (1.0f + (armorValue /= 10.0f));
        if (entity.isCaptain()) {
            entityValue += 1.0f;
        }
        ItemStack is = entity.func_71124_b(0);
        entityValue += BDHelper.getWeaponValue(is) / 3.0f;
        is = entity.getLeftHandItem();
        return entityValue += BDHelper.getWeaponValue(is) / 3.0f;
    }

    public static float getWeaponValue(ItemStack is) {
        float weaponDamage = 0.0f;
        if (is != null) {
            if (is.func_77973_b() instanceof ItemCQBlade) {
                weaponDamage = ((ItemCQBlade)is.func_77973_b()).getWeaponDamage();
            }
            if (is.func_77973_b() instanceof ItemSword) {
                weaponDamage = 1.0f + ((ItemSword)is.func_77973_b()).func_150931_i();
            }
            if (is.func_77973_b() instanceof ItemBow) {
                weaponDamage = 4.0f;
            }
            if (is.func_77973_b() instanceof ItemStaffBase) {
                weaponDamage = 1.0f + ItemStaffBase.getMagicDamage(is) + (float)Awakements.getEnchantLevel(is, Awakements.spellExpansion);
            }
            if (is.func_77973_b() instanceof ItemPistol) {
                weaponDamage = 5.0f;
            }
            if (is.func_77973_b() instanceof ItemHookShoot) {
                weaponDamage += 5.0f;
            }
        }
        return weaponDamage;
    }

    public static void colorArmor(ItemStack is, int color) {
        NBTTagCompound tag = is.field_77990_d == null ? new NBTTagCompound() : is.field_77990_d;
        NBTTagCompound tagDisplay = new NBTTagCompound();
        tagDisplay.func_74768_a("color", color);
        tag.func_74782_a("display", (NBTBase)tagDisplay);
        is.field_77990_d = tag;
    }

    public static ResourceLocation getItemTexture() {
        return texture;
    }

    public static ResourceLocation getParticleTexture() {
        return guiParticleTexture;
    }

    public static void println(String msg) {
        FMLLog.getLogger().info(msg);
    }

    public static void printWarn(String msg) {
        FMLLog.getLogger().warn(msg);
    }

    public static String getAppDir() {
        String s = Loader.instance().getConfigDir().getAbsolutePath();
        return s;
    }

    public static String getInfoDir() {
        return "/Chocolate/";
    }

    public static String getChocolateDir() {
        return BDHelper.getAppDir() + BDHelper.getInfoDir();
    }

    public static String getQuestDir() {
        return BDHelper.getInfoDir() + "Quest/";
    }

    public static boolean getBooleanProperty(Properties prop, String name, boolean defaultValue) {
        String s = prop.getProperty(name);
        if (s == null) {
            return defaultValue;
        }
        return (s = s.trim()).equals("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getIntegerProperty(Properties prop, String name, int defaultValue) {
        String s = prop.getProperty(name);
        if (s == null) {
            return defaultValue;
        }
        int ret = defaultValue;
        s = s.trim();
        ret = Integer.parseInt(s);
        return ret;
    }

    public static int getIntegerProperty(Properties prop, String name, int defaultValue, int minValue, int maxValue) {
        int i = BDHelper.getIntegerProperty(prop, name, defaultValue);
        i = Math.max(minValue, i);
        i = Math.min(maxValue, i);
        return i;
    }

    public static ItemStack EnchantItemRandomly(ItemStack itemstack, Random random) {
        if (itemstack.func_77973_b() instanceof ItemArmor) {
            ItemArmor armor = (ItemArmor)itemstack.func_77973_b();
            if (armor.field_77881_a == 0) {
                int cant = 7;
                if (random.nextInt(cant) == 0) {
                    itemstack.func_77966_a(Enchantment.field_77332_c, random.nextInt(4) + 1);
                }
                if (random.nextInt(cant) == 0) {
                    itemstack.func_77966_a(Enchantment.field_77329_d, random.nextInt(4) + 1);
                }
                if (random.nextInt(cant) == 0) {
                    itemstack.func_77966_a(Enchantment.field_77327_f, random.nextInt(4) + 1);
                }
                if (random.nextInt(cant) == 0) {
                    itemstack.func_77966_a(Enchantment.field_77328_g, random.nextInt(4) + 1);
                }
                if (random.nextInt(cant) == 0) {
                    itemstack.func_77966_a(Enchantment.field_77340_h, random.nextInt(3) + 1);
                }
                if (random.nextInt(cant) == 0) {
                    itemstack.func_77966_a(Enchantment.field_77341_i, 1);
                }
            } else if (armor.field_77881_a == 3) {
                int cant = 5;
                if (random.nextInt(cant) == 0) {
                    itemstack.func_77966_a(Enchantment.field_77332_c, random.nextInt(4) + 1);
                }
                if (random.nextInt(cant) == 0) {
                    itemstack.func_77966_a(Enchantment.field_77329_d, random.nextInt(4) + 1);
                }
                if (random.nextInt(cant) == 0) {
                    itemstack.func_77966_a(Enchantment.field_77327_f, random.nextInt(4) + 1);
                }
                if (random.nextInt(cant) == 0) {
                    itemstack.func_77966_a(Enchantment.field_77328_g, random.nextInt(4) + 1);
                }
                if (random.nextInt(cant) == 0) {
                    itemstack.func_77966_a(Enchantment.field_77330_e, random.nextInt(4) + 1);
                }
            } else {
                int cant = 6;
                if (random.nextInt(cant) == 0) {
                    itemstack.func_77966_a(Enchantment.field_77332_c, random.nextInt(4) + 1);
                }
                if (random.nextInt(cant) == 0) {
                    itemstack.func_77966_a(Enchantment.field_77329_d, random.nextInt(4) + 1);
                }
                if (random.nextInt(cant) == 0) {
                    itemstack.func_77966_a(Enchantment.field_77327_f, random.nextInt(4) + 1);
                }
                if (random.nextInt(cant) == 0) {
                    itemstack.func_77966_a(Enchantment.field_77328_g, random.nextInt(4) + 1);
                }
                if (random.nextInt(cant) == 0) {
                    itemstack.func_77966_a(Enchantment.field_92091_k, random.nextInt(3) + 1);
                }
            }
        } else if (itemstack.func_77973_b() instanceof ItemSword) {
            int cant = 7;
            if (random.nextInt(cant) == 0) {
                itemstack.func_77966_a(Enchantment.field_77338_j, random.nextInt(2) + 1);
            }
            if (random.nextInt(cant) == 0) {
                itemstack.func_77966_a(Enchantment.field_77334_n, random.nextInt(2) + 1);
            }
            if (random.nextInt(cant) == 0) {
                itemstack.func_77966_a(Enchantment.field_77339_k, random.nextInt(5) + 1);
            }
            if (random.nextInt(cant) == 0) {
                itemstack.func_77966_a(Enchantment.field_77336_l, random.nextInt(5) + 1);
            }
            if (random.nextInt(cant) == 0) {
                itemstack.func_77966_a(Enchantment.field_77337_m, 1);
            }
        }
        return itemstack;
    }

    public static int getRandomIndex(int[] weights, Random random) {
        int maxNum = 0;
        for (int i : weights) {
            maxNum += i;
        }
        int randomNum = random.nextInt(weights.length);
        int index = 0;
        for (int weightSum = weights[0]; weightSum <= randomNum; weightSum += weights[++index]) {
        }
        return index;
    }

    public static double getRotationDiffBetweenEntity(Entity entity, Entity target) {
        double angle;
        for (angle = (double)(entity.field_70177_z - target.field_70177_z); angle > 360.0; angle -= 360.0) {
        }
        while (angle < 0.0) {
            angle += 360.0;
        }
        angle = Math.abs(angle - 180.0);
        return angle;
    }

    public static double getAngleBetweenEntities(Entity entity, Entity target) {
        double d = entity.field_70165_t - target.field_70165_t;
        double d2 = entity.field_70161_v - target.field_70161_v;
        double angle = Math.atan2(d, d2);
        angle = angle * 180.0 / 3.141592;
        angle = -MathHelper.func_76138_g((double)(angle - 180.0));
        return angle;
    }

    @Deprecated
    public static String StringColor(String color) {
        return '\u00a7' + color;
    }

    public static double getWeaponDamage(ItemStack weapon) {
        double damage = 0.0;
        Multimap map = weapon.func_111283_C();
        if (map.containsKey((Object)"generic.attackDamage")) {
            AttributeModifier a = (AttributeModifier)map.get((Object)"generic.attackDamage").toArray()[0];
            damage += (double)((float)a.func_111164_d());
        }
        return damage;
    }

    public static void writeCompressed(NBTTagCompound tagCompound, File file) throws IOException {
        CompressedStreamTools.func_74799_a((NBTTagCompound)tagCompound, (OutputStream)new FileOutputStream(file));
    }

    public static NBTTagCompound readCompressed(File file) {
        try {
            return CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
        }
        catch (Exception exception) {
            BDHelper.printWarn("Error reading: " + file.getPath());
            return null;
        }
    }

    public static float getColorRed(int color) {
        return (float)(color >> 16 & 0xFF) / 256.0f;
    }

    public static float getColorGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 256.0f;
    }

    public static float getColorBlue(int color) {
        return (float)(color >> 0 & 0xFF) / 256.0f;
    }

    public static ItemStack getStackFromString(String itemText) {
        String[] textArray = itemText.split(" ");
        ItemStack stack = null;
        if (textArray.length > 0) {
            String name = textArray[0];
            Item currentItem = (Item)Item.field_150901_e.func_82594_a(name);
            if (currentItem != null) {
                int ammount = 1;
                int damage = 0;
                try {
                    if (textArray.length > 1) {
                        ammount = Integer.parseInt(textArray[1]);
                    }
                    if (textArray.length > 2) {
                        damage = Integer.parseInt(textArray[2]);
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                stack = new ItemStack(currentItem, ammount, damage);
            }
            if (textArray.length > 3 && stack != null) {
                String json = "";
                for (int i = 3; i < textArray.length; ++i) {
                    json = json + textArray[3];
                }
                try {
                    NBTBase nbt = BDHelper.JSONToNBT(json);
                    if (nbt instanceof NBTTagCompound) {
                        stack.field_77990_d = (NBTTagCompound)nbt;
                    }
                }
                catch (NBTException e) {
                    e.printStackTrace();
                }
            }
        }
        return stack;
    }

    public static NBTBase JSONToNBT(String value) throws NBTException {
        NBTBase nbt = JsonToNBT.func_150315_a((String)value);
        return nbt;
    }

    public static int getIntegerFromString(String value) {
        int i = 0;
        try {
            i = Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return i;
    }

    public static boolean compareTags(NBTTagCompound tagWithKeys, NBTTagCompound tagToCheck) {
        if (tagWithKeys == null && tagToCheck == null) {
            return true;
        }
        if (tagWithKeys == null || tagToCheck == null) {
            return false;
        }
        Set set = tagWithKeys.func_150296_c();
        for (String name : set) {
            if (tagWithKeys.func_74781_a(name).equals((Object)tagToCheck.func_74781_a(name))) continue;
            return false;
        }
        return true;
    }

    public static String formatNumberToDisplay(int ammount) {
        return BDHelper.formatNumberToDisplay(ammount, false);
    }

    public static String formatNumberToDisplay(int ammount, boolean invertColors) {
        String damage = "";
        damage = ammount >= 0 && !invertColors || invertColors && ammount <= 0 ? EnumChatFormatting.BLUE + " " : EnumChatFormatting.RED + " ";
        damage = damage + ammount;
        return damage;
    }

    public static String formatNumberToDisplay(float ammount) {
        return BDHelper.formatNumberToDisplay(ammount, false);
    }

    public static String formatNumberToDisplay(float ammount, boolean invertColors) {
        String damage = "";
        if (ammount >= 0.0f && !invertColors || invertColors && ammount <= 0.0f) {
            damage = EnumChatFormatting.BLUE + " ";
            if (!invertColors) {
                damage = damage + "";
            }
        } else {
            damage = EnumChatFormatting.RED + " ";
            if (invertColors) {
                damage = damage + "+";
            }
        }
        damage = damage + BDHelper.floatToString(ammount, 2);
        return damage;
    }

    public static String floatToString(double d, int decimals) {
        String value = Double.toString(d);
        int index = value.indexOf(".");
        if (index <= decimals) {
            index += decimals;
        }
        if (index > value.length()) {
            return value;
        }
        return value.substring(0, index);
    }

    public String toRomanNumber(int i) {
        String s = " ";
        while (i > 0) {
            if (i - 1000 >= 0) {
                s = s + "M";
                i -= 1000;
                continue;
            }
            if (i - 900 >= 0) {
                s = s + "CM";
                i -= 900;
                continue;
            }
            if (i - 500 >= 0) {
                s = s + "D";
                i -= 500;
                continue;
            }
            if (i - 400 >= 0) {
                s = s + "CD";
                i -= 400;
                continue;
            }
            if (i - 100 >= 0) {
                s = s + "C";
                i -= 100;
                continue;
            }
            if (i - 90 >= 0) {
                s = s + "XC";
                i -= 90;
                continue;
            }
            if (i - 50 >= 0) {
                s = s + "L";
                i -= 50;
                continue;
            }
            if (i - 40 >= 0) {
                s = s + "XL";
                i -= 40;
                continue;
            }
            if (i - 10 >= 0) {
                s = s + "X";
                i -= 10;
                continue;
            }
            if (i - 9 >= 0) {
                s = s + "IX";
                i -= 9;
                continue;
            }
            if (i - 5 >= 0) {
                s = s + "V";
                i -= 5;
                continue;
            }
            if (i - 4 >= 0) {
                s = s + "IV";
                i -= 4;
                continue;
            }
            if (i - 1 < 0) continue;
            s = s + "I";
            --i;
        }
        return s;
    }
}

