/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.quest.worldManager;

import com.chocolate.chocolateQuest.quest.worldManager.KillCounter;
import com.chocolate.chocolateQuest.quest.worldManager.Reputation;
import com.chocolate.chocolateQuest.quest.worldManager.WorldManagerBase;
import com.chocolate.chocolateQuest.utils.BDHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;

public class ReputationManager
extends WorldManagerBase {
    public static ReputationManager instance;
    Map reputation = new HashMap();
    Map<String, Integer> globals = new HashMap<String, Integer>();
    List<KillCounter> killCounters = new ArrayList<KillCounter>();

    public int getGlobal(String varName) {
        if (!this.globals.containsKey(varName)) {
            return 0;
        }
        return this.globals.get(varName);
    }

    public void setGlobal(String varName, int reputation) {
        this.globals.put(varName, reputation);
    }

    public void onEntityKilled(EntityLivingBase entity, EntityPlayer killer) {
        for (int i = 0; i < this.killCounters.size(); ++i) {
            KillCounter counter = this.killCounters.get(i);
            if (!counter.playerName.equals(killer.func_70005_c_()) || !counter.entityMatchesCounter(entity)) continue;
            ++counter.killAmmount;
        }
    }

    public void addKillCounter(String name, String player, String entity, String tags) {
        if (this.getKillCounter(name, player) == null) {
            KillCounter newCounter = new KillCounter(player, name, entity, tags);
            this.killCounters.add(newCounter);
        }
    }

    public void removeKillCounter(String name, String player) {
        KillCounter counter = this.getKillCounter(name, player);
        if (counter != null) {
            this.killCounters.remove(counter);
        }
    }

    public KillCounter getKillCounter(String name, String player) {
        for (KillCounter killCounter : this.killCounters) {
            if (!killCounter.name.equals(name) || !killCounter.playerName.equals(player)) continue;
            return killCounter;
        }
        return null;
    }

    public void getCounterNames(String player, List<String> list) {
        for (KillCounter killCounter : this.killCounters) {
            if (!killCounter.playerName.equals(player)) continue;
            list.add(killCounter.name);
        }
    }

    public int getKillAmmount(String name, String player) {
        for (KillCounter killCounter : this.killCounters) {
            if (!killCounter.name.equals(name) || !killCounter.playerName.equals(player)) continue;
            return killCounter.killAmmount;
        }
        return 0;
    }

    public int getPlayerReputation(String player, String team) {
        return this.getReputation((String)player, (String)team).reputation;
    }

    public void setReputation(String player, String team, int reputation) {
        Reputation rep = this.getReputation(player, team);
        rep.reputation = reputation;
    }

    public void addReputation(String player, String team, int reputationAddition) {
        Reputation rep = this.getReputation(player, team);
        rep.reputation += reputationAddition;
    }

    public void addReputation(EntityPlayer player, String team, int reputationAddition) {
        this.addReputation(player.func_70005_c_(), team, reputationAddition);
        int total = instance.getPlayerReputation(player.func_70005_c_(), team);
        String repAdditionString = this.colorNumber(reputationAddition);
        String repTotalString = this.colorNumber(total);
        String message = StatCollector.func_74838_a((String)"strings.reputation");
        message = String.format(team + " " + message, repAdditionString, repTotalString);
        player.func_145747_a((IChatComponent)new ChatComponentText(message));
    }

    public Reputation getReputation(String player, String team) {
        Map factionsMap = this.getTeamMap(player, team);
        Object object = factionsMap.get(team);
        if (object == null) {
            object = new Reputation(player, team);
            factionsMap.put(team, object);
        }
        Reputation reputation = (Reputation)object;
        return reputation;
    }

    public String colorNumber(int number) {
        String color = "+" + BDHelper.StringColor("2");
        if (number < 0) {
            color = BDHelper.StringColor("4");
        }
        color = color.concat(number + BDHelper.StringColor("r"));
        return color;
    }

    public Map getTeamMap(String player, String team) {
        HashMap factionsMap = (HashMap)this.reputation.get(player);
        if (factionsMap == null) {
            factionsMap = new HashMap();
            this.reputation.put(player, factionsMap);
        }
        return factionsMap;
    }

    @Override
    protected void readFromNBT(NBTTagCompound tag) {
        NBTTagCompound entry;
        int i;
        NBTTagList list = (NBTTagList)tag.func_74781_a("Reputation");
        if (list != null) {
            for (i = 0; i < list.func_74745_c(); ++i) {
                entry = list.func_150305_b(i);
                this.setReputation(entry.func_74779_i("Player"), entry.func_74779_i("Team"), entry.func_74762_e("Rep"));
            }
        }
        if ((list = (NBTTagList)tag.func_74781_a("Globals")) != null) {
            for (i = 0; i < list.func_74745_c(); ++i) {
                entry = list.func_150305_b(i);
                String name = entry.func_74779_i("name");
                int value = entry.func_74762_e("value");
                this.setGlobal(name, value);
            }
        }
        if ((list = (NBTTagList)tag.func_74781_a("Counters")) != null) {
            for (i = 0; i < list.func_74745_c(); ++i) {
                entry = list.func_150305_b(i);
                KillCounter counter = new KillCounter();
                counter.readFromNBT(entry);
                this.killCounters.add(counter);
            }
        }
    }

    @Override
    protected void writeToNBT(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        Set playersMap = this.reputation.entrySet();
        for (Map.Entry entry : playersMap) {
            String playerName = (String)entry.getKey();
            Set set = ((Map)entry.getValue()).entrySet();
            for (Map.Entry entry2 : set) {
                String teamName = (String)entry2.getKey();
                NBTTagCompound tagRep = new NBTTagCompound();
                tagRep.func_74768_a("Rep", ((Reputation)entry2.getValue()).reputation);
                tagRep.func_74778_a("Team", teamName);
                tagRep.func_74778_a("Player", playerName);
                list.func_74742_a((NBTBase)tagRep);
            }
        }
        tag.func_74782_a("Reputation", (NBTBase)list);
        NBTTagList listGlobal = new NBTTagList();
        Set<Map.Entry<String, Integer>> set = this.globals.entrySet();
        for (Map.Entry entry : set) {
            NBTTagCompound tagGlobal = new NBTTagCompound();
            tagGlobal.func_74778_a("name", (String)entry.getKey());
            tagGlobal.func_74768_a("value", ((Integer)entry.getValue()).intValue());
            listGlobal.func_74742_a((NBTBase)tagGlobal);
        }
        tag.func_74782_a("Globals", (NBTBase)listGlobal);
        NBTTagList listCounters = new NBTTagList();
        for (KillCounter counter : this.killCounters) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            counter.writeToNBT(nBTTagCompound);
            listCounters.func_74742_a((NBTBase)nBTTagCompound);
        }
        tag.func_74782_a("Counters", (NBTBase)listCounters);
    }
}

