/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.items.gun;

import com.chocolate.chocolateQuest.API.IRangedWeapon;
import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.entity.EntityHumanBase;
import com.chocolate.chocolateQuest.entity.npc.EntityGolemMecha;
import com.chocolate.chocolateQuest.entity.projectile.EntityBaseBall;
import com.chocolate.chocolateQuest.gui.InventoryBag;
import com.chocolate.chocolateQuest.items.gun.ILoadableGun;
import com.chocolate.chocolateQuest.magic.Awakements;
import com.chocolate.chocolateQuest.packets.PacketSpawnParticlesAround;
import com.chocolate.chocolateQuest.utils.BDHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;

public class ItemGun
extends Item
implements IRangedWeapon,
ILoadableGun {
    static final int NONE = -1;
    int cooldownBase = 20;
    private final float accuracy;
    private final float range;
    final float projectileDamage;
    protected boolean canPickAmmoFromLoader = false;
    protected boolean canPickAmmoFromInventory = false;
    protected boolean usesStats = true;
    public static final String TAG_POWER = "power";
    public static final String TAG_ACCURACY = "accuracy";
    public static final String TAG_COOLDOWN = "cooldown";
    public int fireRounds = 1;

    public ItemGun() {
        this(30, 100.0f, 50.0f);
    }

    public ItemGun(int cooldown, float range, float accuracy) {
        this(cooldown, range, accuracy, 1.0f);
    }

    public ItemGun(int cooldown, float range, float accuracy, float damage) {
        this.cooldownBase = cooldown;
        this.range = range;
        this.accuracy = accuracy;
        this.projectileDamage = damage;
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
    }

    public WeightedRandomChestContent getChestGenBase(ChestGenHooks chest, Random rnd, WeightedRandomChestContent original) {
        if (this.usesStats) {
            ItemStack is = original.field_76297_b;
            is.field_77990_d = new NBTTagCompound();
            float damage = this.projectileDamage * 1.75f;
            float damageBase = this.projectileDamage * 0.5f;
            int accuracy = (int)this.accuracy * 2;
            int cooldown = this.cooldownBase * 2;
            int type = rnd.nextInt(3);
            if (type == 0) {
                damage += this.projectileDamage * 0.75f;
            }
            if (type == 1) {
                accuracy = (int)((float)accuracy - this.accuracy / 2.0f);
            }
            if (type == 2) {
                cooldown -= this.cooldownBase / 2;
            }
            int maxAccuracy = accuracy;
            int maxCooldown = cooldown;
            is.field_77990_d.func_74776_a(TAG_POWER, damageBase + (float)BDHelper.getRandomValue(rnd) * damage);
            is.field_77990_d.func_74768_a(TAG_COOLDOWN, maxCooldown - (int)(BDHelper.getRandomValue(rnd) * (double)cooldown));
            is.field_77990_d.func_74768_a(TAG_ACCURACY, maxAccuracy - (int)(BDHelper.getRandomValue(rnd) * (double)accuracy));
            return original;
        }
        return super.getChestGenBase(chest, rnd, original);
    }

    public void func_77624_a(ItemStack is, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(is, player, list, par4);
        if (this.usesStats) {
            for (Awakements a : Awakements.awekements) {
                if (!Awakements.hasEnchant(is, a)) continue;
                list.add(a.getDescription(is));
            }
            float damage = 6.0f * this.getPower(is) + (float)this.getExtraBulletDamage(0);
            String rounds = "";
            if (this.getFireRounds() > 1) {
                rounds = "x" + this.getFireRounds();
            }
            list.add(BDHelper.formatNumberToDisplay(damage) + rounds + " " + StatCollector.func_74838_a((String)"weaponbonus.bullet_damage.name").trim());
            float cooldown = this.getCooldown(is);
            list.add(BDHelper.formatNumberToDisplay(-cooldown) + " " + StatCollector.func_74838_a((String)"weaponbonus.fire_rate.name").trim());
            float accuracy = this.getAccuracy(is);
            list.add(BDHelper.formatNumberToDisplay(-accuracy) + "% " + StatCollector.func_74838_a((String)"weaponbonus.accuracy.name").trim());
            if (player.field_71075_bZ.field_75098_d) {
                list.add("Tags: power(float), ");
                list.add("cooldown(Integer), accuracy(Integer)");
            }
        }
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityPlayer) {
        entityPlayer.func_71008_a(itemstack, this.func_77626_a(itemstack));
        return super.func_77659_a(itemstack, world, entityPlayer);
    }

    public void func_77615_a(ItemStack itemstack, World world, EntityPlayer entityPlayer, int useTime) {
        if (entityPlayer.func_70093_af() && !this.freeAmmo()) {
            entityPlayer.openGui((Object)ChocolateQuest.instance, 3, entityPlayer.field_70170_p, 0, 0, 0);
            return;
        }
        long lastShootTick = itemstack.field_77990_d == null ? 0L : itemstack.field_77990_d.func_74763_f("ticks");
        long currentTick = world.func_72820_D();
        if (lastShootTick + (long)this.getCooldown(itemstack) < currentTick || currentTick < lastShootTick) {
            if (this.shoot(itemstack, world, entityPlayer)) {
                if (itemstack.field_77990_d == null) {
                    itemstack.field_77990_d = new NBTTagCompound();
                }
                itemstack.field_77990_d.func_74772_a("ticks", currentTick);
            }
        } else {
            entityPlayer.field_70170_p.func_72956_a((Entity)entityPlayer, "random.click", 1.0f, 1.0f);
        }
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    public boolean shoot(ItemStack itemstack, World world, EntityPlayer entityPlayer) {
        int bulletType = ItemGun.getAmmo(itemstack, !entityPlayer.field_71075_bZ.field_75098_d);
        if (this.freeAmmo()) {
            bulletType = this.getDefaultAmmo();
        }
        if (entityPlayer.field_71075_bZ.field_75098_d && bulletType == -1) {
            bulletType = this.getDefaultAmmo();
        }
        if (bulletType == -1 && this.canPickAmmoFromLoader) {
            bulletType = ItemGun.getAmmoFromAmmoLoader(itemstack, entityPlayer);
        }
        if (bulletType == -1 && this.canPickAmmoFromInventory) {
            bulletType = ItemGun.getAmmoFromInventory(itemstack, entityPlayer);
        }
        if (bulletType != -1) {
            if (!world.field_72995_K) {
                for (int i = 0; i < this.getFireRounds(); ++i) {
                    EntityBaseBall ball = new EntityBaseBall(world, (EntityLivingBase)entityPlayer, 1, bulletType);
                    float accuracy = this.getAccuracy(itemstack) / 10.0f;
                    ball.func_70186_c(entityPlayer.func_70040_Z().field_72450_a, entityPlayer.func_70040_Z().field_72448_b, entityPlayer.func_70040_Z().field_72449_c, 2.0f, accuracy);
                    ball.setDamageMultiplier(this.getPower(itemstack));
                    world.func_72838_d((Entity)ball);
                    double rPitch = Math.toRadians(entityPlayer.field_70125_A);
                    double rYaw = Math.toRadians(entityPlayer.field_70759_as + 35.0f);
                    float dist = 1.4f;
                    double x = -Math.sin(rYaw) * Math.cos(rPitch) * (double)dist;
                    double z = Math.cos(rYaw) * Math.cos(rPitch) * (double)dist;
                    double y = -Math.sin(rPitch) * (double)dist;
                    if (i != 0) continue;
                    PacketSpawnParticlesAround packet = new PacketSpawnParticlesAround(7, x += entityPlayer.field_70165_t, (y += entityPlayer.field_70163_u) + 1.0, z += entityPlayer.field_70161_v);
                    ChocolateQuest.channel.sendToAllAround((Entity)entityPlayer, packet, 64);
                }
            }
            return true;
        }
        return false;
    }

    public int getDefaultAmmo() {
        return 1;
    }

    public boolean freeAmmo() {
        return false;
    }

    public static int getAmmo(ItemStack itemstack, boolean useBullet) {
        int bulletType = -1;
        ItemStack[] ammo = InventoryBag.getCargo(itemstack);
        for (int i = 0; i < ammo.length; ++i) {
            int ammoSaver;
            if (ammo[i] == null || ammo[i].func_77973_b() != ChocolateQuest.bullet) continue;
            bulletType = ammo[i].func_77960_j();
            if (!useBullet || (ammoSaver = Awakements.getEnchantLevel(itemstack, Awakements.ammoSaver)) != 0 && field_77697_d.nextInt(2 + ammoSaver) < 2) break;
            --ammo[i].field_77994_a;
            if (ammo[i].field_77994_a <= 0) {
                ammo[i] = null;
            }
            InventoryBag.saveCargo(itemstack, ammo);
            break;
        }
        return bulletType;
    }

    public static int getAmmoFromAmmoLoader(ItemStack is, EntityPlayer entityPlayer) {
        int bulletType = -1;
        for (int index = 0; index < entityPlayer.field_71071_by.func_70302_i_(); ++index) {
            ItemStack currentIs = entityPlayer.field_71071_by.func_70301_a(index);
            if (currentIs == null || currentIs.field_77990_d == null || currentIs.func_77973_b() != ChocolateQuest.ammoLoader || (bulletType = ItemGun.getAmmo(currentIs, !entityPlayer.field_71075_bZ.field_75098_d)) == -1) continue;
            return bulletType;
        }
        return bulletType;
    }

    public static int getAmmoFromInventory(ItemStack is, EntityPlayer entityPlayer) {
        int bulletType = -1;
        for (int index = 0; index < entityPlayer.field_71071_by.func_70302_i_(); ++index) {
            ItemStack currentIs = entityPlayer.field_71071_by.func_70301_a(index);
            if (currentIs == null || currentIs.func_77973_b() != ChocolateQuest.bullet) continue;
            bulletType = currentIs.func_77960_j();
            int ammoSaver = Awakements.getEnchantLevel(currentIs, Awakements.ammoSaver);
            if (ammoSaver == 0 || field_77697_d.nextInt(2 + ammoSaver) >= 2) {
                --currentIs.field_77994_a;
                if (currentIs.field_77994_a <= 0) {
                    currentIs = null;
                }
            }
            if (bulletType == -1) continue;
            return bulletType;
        }
        return bulletType;
    }

    @Override
    public int getAmmoLoaderStackSize(ItemStack is) {
        return 8;
    }

    @Override
    public int getAmmoLoaderAmmount(ItemStack is) {
        int loaders = Awakements.getEnchantLevel(is, Awakements.ammoCapacity);
        return 1 + loaders;
    }

    @Override
    public boolean isValidAmmo(ItemStack is) {
        if (is == null) {
            return false;
        }
        return is.func_77973_b() == ChocolateQuest.bullet && is.func_77960_j() != 4;
    }

    @Override
    public int getStackIcon(ItemStack is) {
        return 85;
    }

    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.rare;
    }

    public boolean func_77645_m() {
        return true;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (itemStack.func_77960_j() > 0) {
            itemStack.func_77964_b(itemStack.func_77960_j() - 1);
        }
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    public int func_77612_l() {
        return this.cooldownBase;
    }

    protected int getExtraBulletDamage(int bullet) {
        return 0;
    }

    public boolean func_77629_n_() {
        return false;
    }

    public boolean func_77662_d() {
        return false;
    }

    public int getCooldown(ItemStack is) {
        float cooldown = this.getCooldownBase(is);
        if (is.field_77990_d != null) {
            if (is.field_77990_d.func_74764_b(TAG_COOLDOWN)) {
                cooldown = is.field_77990_d.func_74760_g(TAG_COOLDOWN);
            }
        }
        return (int)cooldown;
    }

    public int getCooldownBase(ItemStack is) {
        return this.cooldownBase;
    }

    public float getAccuracy(ItemStack is) {
        float accuracy = this.accuracy;
        if (is.field_77990_d != null) {
            if (is.field_77990_d.func_74764_b(TAG_ACCURACY)) {
                accuracy = is.field_77990_d.func_74760_g(TAG_ACCURACY);
            }
        }
        return accuracy;
    }

    public float getPower(ItemStack is) {
        float basePower = this.getBasePower();
        if (is.field_77990_d != null) {
            if (is.field_77990_d.func_74764_b(TAG_POWER)) {
                basePower = is.field_77990_d.func_74760_g(TAG_POWER);
            }
        }
        int power = Awakements.getEnchantLevel(is, Awakements.power);
        return basePower * (1.0f + (float)power * 0.5f);
    }

    public float getBasePower() {
        return this.projectileDamage;
    }

    public int getFireRounds() {
        return this.fireRounds;
    }

    @Override
    public float getRange(EntityLivingBase shooter, ItemStack is) {
        return this.range;
    }

    @Override
    public int getCooldown(EntityLivingBase shooter, ItemStack is) {
        return this.getCooldown(is);
    }

    @Override
    public void shootFromEntity(EntityLivingBase shooter, ItemStack is, int angle, Entity target) {
        if (!shooter.field_70170_p.field_72995_K) {
            double armDist = shooter.field_70130_N * 2.0f;
            double offsetY = shooter.field_70131_O;
            if (shooter instanceof EntityGolemMecha) {
                offsetY = 1.6;
            }
            double posX = shooter.field_70165_t - Math.sin(Math.toRadians(shooter.field_70177_z + (float)angle)) * armDist;
            double posY = shooter.field_70163_u + offsetY;
            double posZ = shooter.field_70161_v + Math.cos(Math.toRadians(shooter.field_70177_z + (float)angle)) * armDist;
            for (int i = 0; i < this.getFireRounds(); ++i) {
                EntityBaseBall ball;
                if (target != null) {
                    ball = this.getBall(shooter.field_70170_p, shooter, is, target.field_70165_t - posX, target.field_70163_u + (double)target.field_70131_O - posY, target.field_70161_v - posZ);
                } else {
                    double ry = Math.toRadians(shooter.field_70177_z - 180.0f);
                    double x = Math.sin(ry);
                    double z = -Math.cos(ry);
                    double y = -Math.sin(Math.toRadians(shooter.field_70125_A * 2.0f - 1.0f));
                    ball = this.getBall(shooter.field_70170_p, shooter, is, x, y, z);
                    ball.field_70163_u -= (double)(shooter.field_70131_O / 2.0f);
                }
                ball.func_70107_b(posX, posY, posZ);
                shooter.field_70170_p.func_72838_d((Entity)ball);
            }
            double rPitch = Math.toRadians(shooter.field_70125_A);
            double rYaw = Math.toRadians((double)shooter.field_70759_as + (double)angle * 0.5);
            float dist = 1.4f;
            double x = -Math.sin(rYaw) * Math.cos(rPitch) * (double)dist;
            double z = Math.cos(rYaw) * Math.cos(rPitch) * (double)dist;
            double y = -Math.sin(rPitch) * (double)dist;
            PacketSpawnParticlesAround packet = new PacketSpawnParticlesAround(7, x += shooter.field_70165_t, (y += shooter.field_70163_u) + 1.0, z += shooter.field_70161_v);
            ChocolateQuest.channel.sendToAllAround((Entity)shooter, packet, 64);
        }
    }

    public EntityBaseBall getBall(World world, EntityLivingBase shooter, ItemStack is, double x, double y, double z) {
        int ammoType = ItemGun.getAmmo(is, false);
        if (ammoType == -1) {
            ammoType = 0;
        }
        float accuracy = this.getAccuracy(is) / 10.0f;
        int bulletType = 1;
        if (shooter instanceof EntityHumanBase) {
            accuracy += ((EntityHumanBase)shooter).accuracy;
            if (shooter instanceof EntityGolemMecha) {
                bulletType = 2;
            }
        }
        EntityBaseBall ball = new EntityBaseBall(shooter.field_70170_p, shooter, x, y, z, bulletType, ammoType, accuracy, 2.0f);
        ball.setDamageMultiplier(this.getPower(is));
        return ball;
    }

    @Override
    public boolean canBeUsedByEntity(Entity entity) {
        return true;
    }

    @Override
    public boolean isMeleeWeapon(EntityLivingBase shooter, ItemStack is) {
        return false;
    }

    @Override
    public boolean shouldUpdate(EntityLivingBase shooter) {
        return false;
    }

    @Override
    public int startAiming(ItemStack is, EntityLivingBase shooter, Entity target) {
        return this.cooldownBase + 15;
    }
}

