/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.items;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.client.ClientProxy;
import com.chocolate.chocolateQuest.items.ItemArmorBase;
import com.chocolate.chocolateQuest.utils.BDHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class ItemArmorTurtle
extends ItemArmorBase {
    int type;
    String name;

    public ItemArmorTurtle(int type, String name) {
        super(TURTLE, type);
        this.type = type;
        this.name = name;
        this.setEpic();
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String layer) {
        if (((ItemArmorTurtle)stack.func_77973_b()).type == 2) {
            return "chocolatequest:textures/armor/turtle_2.png";
        }
        return "chocolatequest:textures/armor/turtle_1.png";
    }

    @Override
    public void func_77624_a(ItemStack is, EntityPlayer player, List list, boolean par4) {
        int cd;
        super.func_77624_a(is, player, list, par4);
        list.add("");
        if (((ItemArmorTurtle)is.func_77973_b()).type == 1) {
            list.add(BDHelper.formatNumberToDisplay(-50, true) + "% " + StatCollector.func_74838_a((String)"weaponbonus.rear_damage.name").trim());
        }
        list.add(BDHelper.StringColor("9") + "+1" + StatCollector.func_74838_a((String)"armorbonus.regeneration.name"));
        if (is.func_77942_o() && (cd = is.field_77990_d.func_74762_e("CD")) != 0) {
            list.add(BDHelper.StringColor("4") + cd / 20 / 60 + ":" + cd / 20 % 60);
        }
    }

    @Override
    public boolean hasFullSetBonus() {
        return true;
    }

    @Override
    public String getFullSetBonus() {
        return "emergency_regeneration";
    }

    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.epic;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        if (armorSlot == 1) {
            return ClientProxy.turtleArmorModel;
        }
        if (armorSlot == 0) {
            return ClientProxy.turtleHelmetModel;
        }
        if (armorSlot == 2) {
            return ClientProxy.heavyArmorLegs;
        }
        return null;
    }

    public boolean func_82789_a(ItemStack itemToRepair, ItemStack itemMaterial) {
        return itemMaterial.func_77973_b() == ChocolateQuest.material && itemMaterial.func_77960_j() == 1 || super.func_82789_a(itemToRepair, itemMaterial);
    }

    @Override
    public void onUpdateEquiped(ItemStack itemStack, World world, EntityLivingBase entity) {
        super.onUpdateEquiped(itemStack, world, entity);
        if (entity.field_70173_aa % 800 == this.type * 200) {
            entity.func_70691_i(1.0f);
            if (world.field_72995_K) {
                entity.field_70170_p.func_72869_a("heart", entity.field_70165_t + field_77697_d.nextDouble() - 0.5, entity.field_70163_u + field_77697_d.nextDouble(), entity.field_70161_v + field_77697_d.nextDouble() - 0.5, 0.0, 1.0, 0.0);
            }
        }
        if (itemStack.field_77990_d != null) {
            if (itemStack.field_77990_d.func_74764_b("CD")) {
                this.setCooldown(itemStack, this.getCoolDown(itemStack) - 1);
            }
            if (itemStack.field_77990_d.func_74764_b("ON")) {
                if (entity.func_110143_aJ() < entity.func_110138_aP()) {
                    entity.func_70691_i(1.0f);
                    if (world.field_72995_K) {
                        entity.field_70170_p.func_72869_a("heart", entity.field_70165_t + field_77697_d.nextDouble() - 0.5, entity.field_70163_u + field_77697_d.nextDouble(), entity.field_70161_v + field_77697_d.nextDouble() - 0.5, 0.0, 1.0, 0.0);
                    }
                } else {
                    itemStack.field_77990_d.func_82580_o("ON");
                }
            }
        }
    }

    @Override
    public void onHit(LivingHurtEvent event, ItemStack is, EntityLivingBase entity) {
        super.onHit(event, is, entity);
        if (this.field_77881_a == 1) {
            if (event.source.func_76346_g() instanceof EntityLivingBase) {
                double angle;
                EntityLivingBase source = (EntityLivingBase)event.source.func_76346_g();
                for (angle = (double)(entity.field_70177_z - source.field_70177_z); angle > 360.0; angle -= 360.0) {
                }
                while (angle < 0.0) {
                    angle += 360.0;
                }
                if ((angle = Math.abs(angle - 180.0)) > 130.0) {
                    event.ammount /= 2.0f;
                }
            }
            if (this.isFullSet(entity, is)) {
                float ammount = event.ammount + 4.0f;
                if (!event.source.func_76363_c()) {
                    ammount *= 1.0f / (float)entity.func_70658_aO() * 4.0f;
                }
                if (entity.func_110143_aJ() - ammount <= 0.0f && this.getCoolDown(is) == 0) {
                    entity.func_70606_j(0.1f);
                    event.setCanceled(true);
                    this.setCooldown(is, 36000);
                    is.field_77990_d.func_74757_a("ON", true);
                }
            }
        }
    }

    public void setCooldown(ItemStack is, int cooldown) {
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        if (cooldown == 0) {
            is.field_77990_d.func_82580_o("CD");
            return;
        }
        is.field_77990_d.func_74768_a("CD", cooldown);
    }

    public int getCoolDown(ItemStack is) {
        if (is.field_77990_d == null) {
            return 0;
        }
        return is.field_77990_d.func_74762_e("CD");
    }
}

