/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity.handHelper;

import com.chocolate.chocolateQuest.API.ICooldownTracker;
import com.chocolate.chocolateQuest.API.IRangedWeapon;
import com.chocolate.chocolateQuest.API.ITwoHandedItem;
import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.entity.EntityHumanBase;
import com.chocolate.chocolateQuest.entity.handHelper.HandBigSword;
import com.chocolate.chocolateQuest.entity.handHelper.HandBow;
import com.chocolate.chocolateQuest.entity.handHelper.HandCQBlade;
import com.chocolate.chocolateQuest.entity.handHelper.HandDagger;
import com.chocolate.chocolateQuest.entity.handHelper.HandEmpty;
import com.chocolate.chocolateQuest.entity.handHelper.HandFire;
import com.chocolate.chocolateQuest.entity.handHelper.HandFireChange;
import com.chocolate.chocolateQuest.entity.handHelper.HandHealer;
import com.chocolate.chocolateQuest.entity.handHelper.HandHook;
import com.chocolate.chocolateQuest.entity.handHelper.HandLead;
import com.chocolate.chocolateQuest.entity.handHelper.HandMagicCaster;
import com.chocolate.chocolateQuest.entity.handHelper.HandPotion;
import com.chocolate.chocolateQuest.entity.handHelper.HandRanged;
import com.chocolate.chocolateQuest.entity.handHelper.HandShield;
import com.chocolate.chocolateQuest.entity.handHelper.HandSnowBall;
import com.chocolate.chocolateQuest.entity.handHelper.HandSpear;
import com.chocolate.chocolateQuest.entity.handHelper.HandSupport;
import com.chocolate.chocolateQuest.entity.handHelper.HandTNT;
import com.chocolate.chocolateQuest.items.ItemHookShoot;
import com.chocolate.chocolateQuest.items.ItemStaffHeal;
import com.chocolate.chocolateQuest.items.swords.ItemBaseBroadSword;
import com.chocolate.chocolateQuest.items.swords.ItemBaseDagger;
import com.chocolate.chocolateQuest.items.swords.ItemBaseSpear;
import com.chocolate.chocolateQuest.items.swords.ItemCQBlade;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;

public class HandHelper {
    private boolean twoHanded = false;
    ItemStack currentItem;
    EntityHumanBase owner;
    public int attackTime = 0;

    public static HandHelper getHandHelperForItem(EntityHumanBase owner, ItemStack itemStack) {
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            if (item instanceof ItemStaffHeal) {
                return new HandHealer(owner, itemStack);
            }
            if (item instanceof IRangedWeapon && item instanceof ICooldownTracker) {
                return new HandMagicCaster(owner, itemStack);
            }
            if (item instanceof IRangedWeapon) {
                return new HandRanged(owner, itemStack);
            }
            if (item == ChocolateQuest.banner) {
                return new HandSupport(owner, itemStack);
            }
            if (item == ChocolateQuest.shield) {
                return new HandShield(owner, itemStack);
            }
            if (item instanceof ItemHookShoot || item == ChocolateQuest.hookSword) {
                return new HandHook(owner, itemStack);
            }
            if (item instanceof ItemBaseDagger) {
                return new HandDagger(owner, itemStack);
            }
            if (item instanceof ItemBaseBroadSword) {
                return new HandBigSword(owner, itemStack);
            }
            if (item instanceof ItemBaseSpear) {
                return new HandSpear(owner, itemStack);
            }
            if (item instanceof ItemCQBlade) {
                return new HandCQBlade(owner, itemStack);
            }
            if (item == Items.field_151031_f) {
                return new HandBow(owner, itemStack);
            }
            if (item == Items.field_151058_ca) {
                return new HandLead(owner, itemStack);
            }
            if (item == Items.field_151126_ay) {
                return new HandSnowBall(owner, itemStack);
            }
            if (item == Items.field_151059_bz) {
                return new HandFireChange(owner, itemStack);
            }
            if (item == Items.field_151033_d) {
                return new HandFire(owner, itemStack);
            }
            if (item instanceof ItemPotion) {
                return new HandPotion(owner, itemStack);
            }
            if (item instanceof ItemBlock && Block.func_149634_a((Item)item) == Blocks.field_150335_W) {
                return new HandTNT(owner, itemStack);
            }
        } else {
            return new HandEmpty(owner, itemStack);
        }
        return new HandHelper(owner, itemStack);
    }

    public HandHelper(EntityHumanBase owner, ItemStack itemStack) {
        Item item;
        this.owner = owner;
        this.currentItem = itemStack;
        if (itemStack != null && ((item = itemStack.func_77973_b()) instanceof ITwoHandedItem || item == Items.field_151031_f)) {
            this.twoHanded = true;
        }
    }

    public void attackEntity(Entity entity) {
        if (this.attackTime <= 0) {
            this.attackTime = this.owner.getAttackSpeed();
            this.owner.swingHand(this);
            this.owner.attackEntityAsMob(entity, this.currentItem);
        }
    }

    public boolean attackWithRange(Entity target, float f) {
        return false;
    }

    public void setAiming(boolean aim) {
    }

    public boolean isAiming() {
        return false;
    }

    public void onUpdate() {
        if (this.attackTime > 0) {
            --this.attackTime;
        }
    }

    public boolean isTwoHanded() {
        return this.twoHanded;
    }

    public boolean isRanged() {
        return false;
    }

    public boolean canBlock() {
        return false;
    }

    public boolean isHealer() {
        return false;
    }

    public double getAttackRangeBonus() {
        return 0.0;
    }

    public double getMaxRangeForAttack() {
        return (double)(this.owner.field_70130_N * this.owner.field_70130_N) + this.getAttackRangeBonus();
    }

    public double getDistanceToStopAdvancing() {
        return this.getAttackRangeBonus();
    }

    public ItemStack getItem() {
        return this.currentItem;
    }
}

