/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.builder.BuilderHelper;
import com.chocolate.chocolateQuest.builder.schematic.Schematic;
import com.chocolate.chocolateQuest.entity.SchematicStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntitySchematicBuilder
extends Entity {
    int mobID;
    boolean replaceBanner;
    int buildingStep;
    Schematic cachedSchematic;
    int schematicSize;
    boolean firstTick = true;
    List<SchematicStorage> buildingPlans = new ArrayList<SchematicStorage>();

    public EntitySchematicBuilder(World world) {
        super(world);
        this.func_70105_a(0.1f, 0.1f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
    }

    protected void setSchematicSize(int size) {
        this.field_70180_af.func_75692_b(16, (Object)size);
    }

    protected int getSchematicSize() {
        return this.field_70180_af.func_75679_c(16);
    }

    protected void setSchematicStep(int size) {
        this.field_70180_af.func_75692_b(17, (Object)size);
    }

    protected int getSchematicStep() {
        return this.field_70180_af.func_75679_c(17);
    }

    public void setMobID(int idMob, boolean replaceBanners) {
        this.mobID = idMob;
        this.replaceBanner = replaceBanners;
    }

    public void addBuildingPlans(Schematic schematic, int posX, int posY, int posZ) {
        SchematicStorage storage = new SchematicStorage(posX, posY, posZ);
        storage.schematic = schematic;
        this.buildingPlans.add(storage);
        this.schematicSize += schematic.width * schematic.length * schematic.height * 2;
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            if (this.getSchematicSize() > 0) {
                BuilderHelper.builderHelper.setStructureGenerationAmmount(this.getSchematicStep() * 100 / this.getSchematicSize());
            }
        } else if (this.firstTick) {
            this.setSchematicSize(this.schematicSize);
            this.firstTick = false;
            return;
        }
        if (this.field_70170_p.func_72890_a((Entity)this, 128.0) == null) {
            return;
        }
        int speed = ChocolateQuest.config.builderSpeed;
        if (this.cachedSchematic == null) {
            this.startBuilding();
            return;
        }
        int schematicSize = this.cachedSchematic.width * this.cachedSchematic.length * this.cachedSchematic.height;
        for (int i = 0; i < speed; ++i) {
            int step;
            if ((step = this.buildingStep++) < schematicSize * 2) {
                boolean isFirsPass;
                boolean bl = isFirsPass = step < schematicSize;
                if (!isFirsPass) {
                    step -= schematicSize;
                }
                BuilderHelper.builderHelper.buildStep(this.field_70146_Z, this.field_70170_p, this.cachedSchematic, step, isFirsPass, this.mobID, true, this.replaceBanner);
                ++this.buildingStep;
                this.setSchematicStep(this.getSchematicStep() + 1);
                continue;
            }
            int entityIndex = step - schematicSize * 2;
            if (BuilderHelper.builderHelper.putEntities(this.field_70170_p, this.cachedSchematic, entityIndex, this.mobID, this.replaceBanner)) continue;
            this.nextSchematic();
            return;
        }
    }

    protected void nextSchematic() {
        this.buildingStep = 0;
        this.buildingPlans.remove(0);
        this.cachedSchematic = null;
    }

    protected void startBuilding() {
        if (this.buildingPlans.size() > 0) {
            SchematicStorage currentPlans = this.buildingPlans.get(0);
            this.cachedSchematic = currentPlans.schematic;
            this.cachedSchematic.setPosition(currentPlans.posX, currentPlans.posY, currentPlans.posZ);
        } else if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    protected void func_70037_a(NBTTagCompound tag) {
        this.buildingStep = tag.func_74762_e("step");
        this.mobID = tag.func_74762_e("mobID");
        this.replaceBanner = tag.func_74767_n("banner");
        NBTTagList list = tag.func_150295_c("plans", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound t = list.func_150305_b(i);
            SchematicStorage storage = new SchematicStorage(t.func_74762_e("x"), t.func_74762_e("y"), t.func_74762_e("z"));
            storage.schematic = new Schematic(t.func_74775_l("schematic"));
            this.buildingPlans.add(storage);
        }
    }

    protected void func_70014_b(NBTTagCompound tag) {
        tag.func_74768_a("step", this.buildingStep);
        tag.func_74768_a("mobID", this.mobID);
        tag.func_74757_a("banner", this.replaceBanner);
        NBTTagList list = new NBTTagList();
        for (SchematicStorage buildingPlan : this.buildingPlans) {
            NBTTagCompound buildingPlanTag = new NBTTagCompound();
            NBTTagCompound schematicTag = new NBTTagCompound();
            buildingPlan.schematic.saveToNBT(schematicTag);
            buildingPlanTag.func_74782_a("schematic", (NBTBase)schematicTag);
            buildingPlanTag.func_74768_a("x", buildingPlan.posX);
            buildingPlanTag.func_74768_a("y", buildingPlan.posY);
            buildingPlanTag.func_74768_a("z", buildingPlan.posZ);
            list.func_74742_a((NBTBase)buildingPlanTag);
        }
        tag.func_74782_a("plans", (NBTBase)list);
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_82150_aj() {
        return true;
    }
}

