/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.pipe;

import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.impl.WinRegistry;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.IPCClient;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.Callback;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.Packet;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.pipe.Pipe;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.pipe.PipeStatus;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;

public class WindowsPipe
extends Pipe {
    public RandomAccessFile file;

    WindowsPipe(IPCClient ipcClient, HashMap<String, Callback> callbacks, String location) {
        super(ipcClient, callbacks);
        try {
            this.file = new RandomAccessFile(location, "rw");
        }
        catch (FileNotFoundException e) {
            this.file = null;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.file.write(b);
    }

    @Override
    public Packet read() throws IOException, JsonParseException {
        while ((this.status == PipeStatus.CONNECTED || this.status == PipeStatus.CLOSING) && this.file.length() == 0L) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.status == PipeStatus.DISCONNECTED) {
            throw new IOException("Disconnected!");
        }
        if (this.status == PipeStatus.CLOSED) {
            return new Packet(Packet.OpCode.CLOSE, null, this.ipcClient.getEncoding());
        }
        Packet.OpCode op = Packet.OpCode.values()[Integer.reverseBytes(this.file.readInt())];
        int len = Integer.reverseBytes(this.file.readInt());
        byte[] d = new byte[len];
        this.file.readFully(d);
        return this.receive(op, d);
    }

    @Override
    public void close() throws IOException {
        if (this.ipcClient.isDebugMode()) {
            ModUtils.LOG.debugInfo("Closing IPC pipe...", new Object[0]);
        }
        this.status = PipeStatus.CLOSING;
        this.send(Packet.OpCode.CLOSE, new JsonObject(), null);
        this.status = PipeStatus.CLOSED;
        this.file.close();
    }

    @Override
    public void registerApp(String applicationId, String command) {
        String javaExePath;
        String javaLibraryPath = System.getProperty("java.home");
        File javaExeFile = new File(javaLibraryPath.split(";")[0] + "/bin/java.exe");
        File javawExeFile = new File(javaLibraryPath.split(";")[0] + "/bin/javaw.exe");
        String string = javaExeFile.exists() ? javaExeFile.getAbsolutePath() : (javaExePath = javawExeFile.exists() ? javawExeFile.getAbsolutePath() : null);
        if (javaExePath == null) {
            throw new RuntimeException("Unable to find java path");
        }
        String openCommand = command != null ? command : javaExePath;
        String protocolName = "discord-" + applicationId;
        String protocolDescription = "URL:Run game " + applicationId + " protocol";
        String keyName = "Software\\Classes\\" + protocolName;
        String iconKeyName = keyName + "\\DefaultIcon";
        String commandKeyName = keyName + "\\DefaultIcon";
        try {
            WinRegistry.createKey(-2147483647, keyName);
            WinRegistry.writeStringValue(-2147483647, keyName, "", protocolDescription);
            WinRegistry.writeStringValue(-2147483647, keyName, "URL Protocol", "\u0000");
            WinRegistry.createKey(-2147483647, iconKeyName);
            WinRegistry.writeStringValue(-2147483647, iconKeyName, "", javaExePath);
            WinRegistry.createKey(-2147483647, commandKeyName);
            WinRegistry.writeStringValue(-2147483647, commandKeyName, "", openCommand);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to modify Discord registry keys", ex);
        }
    }

    @Override
    public void registerSteamGame(String applicationId, String steamId) {
        try {
            String steamPath = WinRegistry.readString(-2147483647, "Software\\\\Valve\\\\Steam", "SteamExe");
            if (steamPath == null) {
                throw new RuntimeException("Steam exe path not found");
            }
            steamPath = steamPath.replaceAll("/", "\\");
            String command = "\"" + steamPath + "\" steam://rungameid/" + steamId;
            this.registerApp(applicationId, command);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to register Steam game", ex);
        }
    }
}

