/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.integrations.curse.CurseUtils;
import com.gitlab.cdagaming.craftpresence.integrations.mcupdater.MCUpdaterUtils;
import com.gitlab.cdagaming.craftpresence.integrations.multimc.MultiMCUtils;
import com.gitlab.cdagaming.craftpresence.integrations.technic.TechnicUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;

public class CommandUtils {
    public static boolean isInMainMenu = false;
    public static boolean isLoadingGame = false;

    public static void reloadData(boolean forceUpdateRPC) {
        ModUtils.TRANSLATOR.onTick();
        CraftPresence.SYSTEM.onTick();
        CraftPresence.instance.func_152344_a(() -> CraftPresence.KEYBINDINGS.onTick());
        CraftPresence.GUIS.onTick();
        if (CraftPresence.SYSTEM.HAS_LOADED && CraftPresence.SYSTEM.HAS_GAME_LOADED) {
            CraftPresence.BIOMES.onTick();
            CraftPresence.DIMENSIONS.onTick();
            CraftPresence.TILE_ENTITIES.onTick();
            CraftPresence.ENTITIES.onTick();
            CraftPresence.SERVER.onTick();
            if (forceUpdateRPC) {
                if (CraftPresence.DIMENSIONS.isInUse) {
                    CraftPresence.DIMENSIONS.updateDimensionPresence();
                }
                if (CraftPresence.GUIS.isInUse) {
                    CraftPresence.GUIS.updateGUIPresence();
                }
                if (CraftPresence.TILE_ENTITIES.isInUse) {
                    CraftPresence.TILE_ENTITIES.updateEntityPresence();
                }
                if (CraftPresence.ENTITIES.isInUse) {
                    CraftPresence.ENTITIES.updateEntityPresence();
                }
                if (CraftPresence.SERVER.isInUse) {
                    CraftPresence.SERVER.updateServerPresence();
                }
                if (CraftPresence.BIOMES.isInUse) {
                    CraftPresence.BIOMES.updateBiomePresence();
                }
            }
        }
    }

    public static void rebootRPC() {
        CraftPresence.CLIENT.shutDown();
        if (!CraftPresence.CLIENT.CLIENT_ID.equals(CraftPresence.CONFIG.clientId)) {
            DiscordAssetUtils.emptyData();
            CraftPresence.CLIENT.CLIENT_ID = CraftPresence.CONFIG.clientId;
        } else {
            DiscordAssetUtils.clearClientData();
        }
        DiscordAssetUtils.loadAssets(CraftPresence.CONFIG.clientId, true);
        CraftPresence.CLIENT.init(CraftPresence.CONFIG.resetTimeOnInit);
    }

    public static void init() {
        if (CraftPresence.CONFIG.detectCurseManifest && !CraftPresence.packFound) {
            CurseUtils.loadManifest();
        }
        if (CraftPresence.CONFIG.detectMultiMCManifest && !CraftPresence.packFound) {
            MultiMCUtils.loadInstance();
        }
        if (CraftPresence.CONFIG.detectMCUpdaterInstance && !CraftPresence.packFound) {
            MCUpdaterUtils.loadInstance();
        }
        if (CraftPresence.CONFIG.detectTechnicPack && !CraftPresence.packFound) {
            TechnicUtils.loadPack();
        }
        DiscordAssetUtils.loadAssets(CraftPresence.CONFIG.clientId, true);
        CraftPresence.KEYBINDINGS.register();
    }

    public static void setLoadingPresence() {
        ArrayList loadingArgs = Lists.newArrayList();
        if (!CraftPresence.CLIENT.generalArgs.isEmpty()) {
            loadingArgs.addAll(CraftPresence.CLIENT.generalArgs);
        }
        CraftPresence.CLIENT.clearPartyData(true, false);
        CraftPresence.CLIENT.syncArgument("&MAINMENU&", StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.loadingMessage, loadingArgs), false);
        CraftPresence.CLIENT.syncArgument("&MAINMENU&", CraftPresence.CLIENT.imageOf(CraftPresence.CONFIG.defaultIcon, "", false), true);
        isLoadingGame = true;
    }

    public static void setMainMenuPresence() {
        ArrayList mainMenuArgs = Lists.newArrayList();
        if (!CraftPresence.CLIENT.generalArgs.isEmpty()) {
            mainMenuArgs.addAll(CraftPresence.CLIENT.generalArgs);
        }
        if (isLoadingGame) {
            CraftPresence.CLIENT.initArgument("&MAINMENU&");
            isLoadingGame = false;
        }
        CraftPresence.CLIENT.syncArgument("&MAINMENU&", StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.mainMenuMessage, mainMenuArgs), false);
        CraftPresence.CLIENT.syncArgument("&MAINMENU&", CraftPresence.CLIENT.imageOf(CraftPresence.CONFIG.defaultIcon, "", false), true);
        isInMainMenu = true;
    }
}

