/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.client.gui.editors.tasks;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.network.IPacketSender;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.IFieldFilter;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.controls.PanelTextField;
import betterquesting.api2.client.gui.controls.filters.FieldFilterNumber;
import betterquesting.api2.client.gui.controls.filters.FieldFilterString;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.themes.IThemeRegistry;
import betterquesting.api2.client.gui.themes.gui_args.GArgsNBT;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetGUIs;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.QuestTranslation;
import bq_standard.tasks.TaskScoreboard;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class GuiEditTaskScoreboard
extends GuiScreenCanvas {
    private final DBEntry<IQuest> quest;
    private final TaskScoreboard task;
    private static final ResourceLocation QUEST_EDIT = new ResourceLocation("betterquesting:quest_edit");

    public GuiEditTaskScoreboard(GuiScreen parent, DBEntry<IQuest> quest, TaskScoreboard task) {
        super(parent);
        this.quest = quest;
        this.task = task;
        this.setVolatile(true);
    }

    public void initPanel() {
        super.initPanel();
        Keyboard.enableRepeatEvents((boolean)true);
        CanvasTextured cvBackground = new CanvasTextured((IGuiRect)new GuiTransform(), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel((IGuiPanel)cvBackground);
        cvBackground.addPanel((IGuiPanel)new PanelTextBox((IGuiRect)new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(16, 16, 16, -32), 0), QuestTranslation.translate((String)"bq_standard.title.edit_scoreboard", (Object[])new Object[0])).setAlignment(1).setColor(PresetColor.TEXT_HEADER.getColor()));
        cvBackground.addPanel((IGuiPanel)new PanelTextBox((IGuiRect)new GuiTransform(GuiAlign.MID_CENTER, -100, -28, 50, 12, 0), QuestTranslation.translate((String)"betterquesting.gui.name", (Object[])new Object[0])).setColor(PresetColor.TEXT_MAIN.getColor()));
        cvBackground.addPanel((IGuiPanel)new PanelTextBox((IGuiRect)new GuiTransform(GuiAlign.MID_CENTER, -100, -12, 50, 12, 0), "ID").setColor(PresetColor.TEXT_MAIN.getColor()));
        cvBackground.addPanel((IGuiPanel)new PanelTextField((IGuiRect)new GuiTransform(GuiAlign.MID_CENTER, -50, -32, 150, 16, 0), this.task.scoreDisp, (IFieldFilter)FieldFilterString.INSTANCE).setCallback(value -> {
            this.task.scoreDisp = value;
        }));
        cvBackground.addPanel((IGuiPanel)new PanelTextField((IGuiRect)new GuiTransform(GuiAlign.MID_CENTER, -50, -16, 150, 16, 0), this.task.scoreName, (IFieldFilter)FieldFilterString.INSTANCE).setCallback(value -> {
            this.task.scoreName = value;
        }));
        cvBackground.addPanel((IGuiPanel)new PanelButtonStorage<TaskScoreboard.ScoreOperation>((IGuiRect)new GuiTransform(GuiAlign.MID_CENTER, -100, 0, 50, 16, 0), -1, this.task.operation.GetText(), this.task.operation){

            public void onButtonClick() {
                TaskScoreboard.ScoreOperation[] v = TaskScoreboard.ScoreOperation.values();
                TaskScoreboard.ScoreOperation n = v[(((TaskScoreboard.ScoreOperation)((Object)this.getStoredValue())).ordinal() + 1) % v.length];
                this.setStoredValue((Object)n);
                this.setText(n.GetText());
                ((GuiEditTaskScoreboard)GuiEditTaskScoreboard.this).task.operation = n;
            }
        });
        cvBackground.addPanel((IGuiPanel)new PanelTextField((IGuiRect)new GuiTransform(GuiAlign.MID_CENTER, -50, 0, 150, 16, 0), "" + this.task.target, (IFieldFilter)FieldFilterNumber.INT).setCallback(value -> {
            this.task.target = value;
        }));
        GuiEditTaskScoreboard screenRef = this;
        cvBackground.addPanel((IGuiPanel)new PanelButton((IGuiRect)new GuiTransform(GuiAlign.MID_CENTER, -100, 16, 200, 16, 0), -1, QuestTranslation.translate((String)"betterquesting.btn.advanced", (Object[])new Object[0]), (GuiScreen)screenRef){
            final /* synthetic */ GuiScreen val$screenRef;
            {
                this.val$screenRef = guiScreen;
                super(x0, x1, x2);
            }

            public void onButtonClick() {
                GuiEditTaskScoreboard.this.field_146297_k.func_147108_a(((IThemeRegistry)QuestingAPI.getAPI((ApiKey)ApiReference.THEME_REG)).getGui(PresetGUIs.EDIT_NBT, (Object)new GArgsNBT(this.val$screenRef, (NBTBase)GuiEditTaskScoreboard.this.task.writeToNBT(new NBTTagCompound()), GuiEditTaskScoreboard.this.task::readFromNBT, null)));
            }
        });
        cvBackground.addPanel((IGuiPanel)new PanelButton((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 200, 16, 0), -1, QuestTranslation.translate((String)"gui.back", (Object[])new Object[0])){

            public void onButtonClick() {
                GuiEditTaskScoreboard.this.sendChanges();
                GuiEditTaskScoreboard.this.field_146297_k.func_147108_a(GuiEditTaskScoreboard.this.parent);
            }
        });
    }

    private void sendChanges() {
        NBTTagCompound payload = new NBTTagCompound();
        NBTTagList dataList = new NBTTagList();
        NBTTagCompound entry = new NBTTagCompound();
        entry.func_74768_a("questID", this.quest.getID());
        entry.func_74782_a("config", ((IQuest)this.quest.getValue()).writeToNBT((NBTBase)new NBTTagCompound()));
        dataList.func_74742_a((NBTBase)entry);
        payload.func_74782_a("data", (NBTBase)dataList);
        payload.func_74768_a("action", 0);
        ((IPacketSender)QuestingAPI.getAPI((ApiKey)ApiReference.PACKET_SENDER)).sendToServer(new QuestingPacket(QUEST_EDIT, payload));
    }
}

