/*
 * Decompiled with CFR 0.152.
 */
package me.otho.customItems.mod.handler;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Random;
import me.otho.customItems.configuration.jsonReaders.blocks.Cfg_blockDrop;
import me.otho.customItems.configuration.jsonReaders.common.Cfg_drop;
import me.otho.customItems.registry.BlockRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.world.BlockEvent;

public class BlockDropHandler {
    protected int getItemDropQuantity(Cfg_drop data) {
        Random rand = new Random();
        int ret = data.min;
        for (int i = data.min; i < data.max; ++i) {
            boolean willDrop;
            boolean bl = willDrop = rand.nextFloat() * 100.0f < data.chance;
            if (!willDrop) continue;
            ++ret;
        }
        return ret;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBlockDrop(BlockEvent.HarvestDropsEvent event) {
        Random random = new Random();
        Block block = event.block;
        String blockId = GameRegistry.findUniqueIdentifierFor((Block)block).toString() + ":" + event.blockMetadata;
        if (BlockRegistry.drops.containsKey(blockId)) {
            Cfg_blockDrop blockDrop = BlockRegistry.drops.get(blockId);
            if (blockDrop.overrides.booleanValue()) {
                event.drops.clear();
            }
            for (Cfg_drop drop : blockDrop.drops) {
                String[] parser = drop.id.split(":");
                String modId = parser[0];
                String name = parser[1];
                int damage = 0;
                if (parser.length > 2) {
                    damage = Integer.parseInt(parser[2]);
                }
                Item item = GameRegistry.findItem((String)modId, (String)name);
                int quantity = this.getItemDropQuantity(drop);
                event.drops.add(new ItemStack(item, quantity, damage));
            }
        }
    }
}

