/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.PlayerData;
import com.flansmod.common.teams.EntityFlag;
import com.flansmod.common.teams.EntityFlagpole;
import com.flansmod.common.teams.GameType;
import com.flansmod.common.teams.ITeamBase;
import com.flansmod.common.teams.ITeamObject;
import com.flansmod.common.teams.Team;
import com.flansmod.common.teams.TeamsManager;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;

public class GameTypeCTF
extends GameType {
    public boolean friendlyFire = false;
    public boolean autoBalance = true;
    public int time;
    public int flagReturnTime = 60;

    public GameTypeCTF() {
        super("Capture the Flag", "CTF", 2, true);
    }

    @Override
    public void roundStart() {
    }

    @Override
    public void roundEnd() {
        if (GameTypeCTF.teamsManager.currentRound.teams != null && GameTypeCTF.teamsManager.currentRound.teams[0] != null && GameTypeCTF.teamsManager.currentRound.teams[1] != null) {
            int bestScore;
            PlayerData data;
            Team teamA = GameTypeCTF.teamsManager.currentRound.teams[0];
            Team teamB = GameTypeCTF.teamsManager.currentRound.teams[1];
            teamA.sortPlayers();
            teamB.sortPlayers();
            EntityPlayerMP bestPlayerA = null;
            EntityPlayerMP bestPlayerB = null;
            if (teamA.members != null) {
                for (String name : teamA.members) {
                    ++GameTypeCTF.getPlayerInfo((EntityPlayerMP)this.getPlayer((String)name)).playedRounds;
                    GameTypeCTF.getPlayerInfo(this.getPlayer(name)).updateAVG();
                    GameTypeCTF.getPlayerInfo(this.getPlayer(name)).savePlayerStats();
                }
            }
            if (teamB.members != null) {
                for (String name : teamB.members) {
                    ++GameTypeCTF.getPlayerInfo((EntityPlayerMP)this.getPlayer((String)name)).playedRounds;
                    GameTypeCTF.getPlayerInfo(this.getPlayer(name)).updateAVG();
                    GameTypeCTF.getPlayerInfo(this.getPlayer(name)).savePlayerStats();
                }
            }
            if (teamA.members != null) {
                for (String name : teamA.members) {
                    data = GameTypeCTF.getPlayerData(this.getPlayer(name));
                    bestScore = 0;
                    if (data.score <= bestScore) continue;
                    bestPlayerA = this.getPlayer(name);
                    bestScore = data.score;
                }
            }
            if (teamB.members != null) {
                for (String name : teamB.members) {
                    data = GameTypeCTF.getPlayerData(this.getPlayer(name));
                    bestScore = 0;
                    if (data.score <= bestScore) continue;
                    bestPlayerB = this.getPlayer(name);
                    bestScore = data.score;
                }
            }
            if (bestPlayerA != null) {
                GameTypeCTF.getPlayerInfo(bestPlayerA).addExp(250.0f);
                ++GameTypeCTF.getPlayerInfo(bestPlayerA).MVPCount;
                GameTypeCTF.getPlayerInfo(bestPlayerA).savePlayerStats();
            }
            if (bestPlayerB != null) {
                GameTypeCTF.getPlayerInfo(bestPlayerB).addExp(250.0f);
                ++GameTypeCTF.getPlayerInfo(bestPlayerB).MVPCount;
                GameTypeCTF.getPlayerInfo(bestPlayerB).savePlayerStats();
            }
        }
    }

    @Override
    public void roundCleanup() {
    }

    @Override
    public void tick() {
    }

    @Override
    public void playerQuit(EntityPlayerMP player) {
    }

    @Override
    public boolean playerCanAttack(EntityPlayerMP attacker, Team attackerTeam, EntityPlayerMP victim, Team victimTeam) {
        return attackerTeam != victimTeam || this.friendlyFire;
    }

    @Override
    public boolean playerAttacked(EntityPlayerMP player, DamageSource source) {
        if (GameTypeCTF.getPlayerData(player) == null || GameTypeCTF.getPlayerData((EntityPlayerMP)player).team == null) {
            return false;
        }
        EntityPlayerMP attacker = GameTypeCTF.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (GameTypeCTF.getPlayerData(attacker) == null || GameTypeCTF.getPlayerData((EntityPlayerMP)attacker).team == null) {
                return false;
            }
            if (GameTypeCTF.getPlayerData((EntityPlayerMP)player).team == GameTypeCTF.getPlayerData((EntityPlayerMP)attacker).team) {
                return this.friendlyFire;
            }
        }
        return GameTypeCTF.getPlayerData((EntityPlayerMP)player).team != Team.spectators;
    }

    @Override
    public void playerKilled(EntityPlayerMP player, DamageSource source) {
        EntityPlayerMP attacker = GameTypeCTF.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (attacker == player) {
                --GameTypeCTF.getPlayerData((EntityPlayerMP)player).score;
            } else {
                ++GameTypeCTF.getPlayerData((EntityPlayerMP)attacker).score;
                ++GameTypeCTF.getPlayerData((EntityPlayerMP)attacker).kills;
                ++GameTypeCTF.getPlayerInfo((EntityPlayerMP)attacker).kills;
                GameTypeCTF.getPlayerInfo(attacker).addExp(GameTypeCTF.getPlayerInfo((EntityPlayerMP)player).rank * 2);
                GameTypeCTF.getPlayerInfo(attacker).updateLongestKill(attacker.func_70032_d((Entity)player));
                if (player.field_70153_n instanceof EntityFlag) {
                    GameTypeCTF.getPlayerInfo(attacker).addExp(10.0f);
                }
                GameTypeCTF.getPlayerInfo(attacker).savePlayerStats();
            }
        } else {
            --GameTypeCTF.getPlayerData((EntityPlayerMP)player).score;
        }
        ++GameTypeCTF.getPlayerData((EntityPlayerMP)player).deaths;
        ++GameTypeCTF.getPlayerInfo((EntityPlayerMP)player).deaths;
        GameTypeCTF.getPlayerInfo(player).savePlayerStats();
        if (player.field_70153_n instanceof EntityFlag) {
            Team flagTeam = teamsManager.getTeam(((EntityFlag)player.field_70153_n).getBase().getOwnerID());
            player.field_70153_n.func_70078_a(null);
            TeamsManager.messageAll("\u00a7f" + player.func_70005_c_() + " dropped the \u00a7" + flagTeam.textColour + flagTeam.name + "\u00a7f flag");
        }
    }

    @Override
    public void baseAttacked(ITeamBase base, DamageSource source) {
    }

    @Override
    public void objectAttacked(ITeamObject object, DamageSource source) {
    }

    @Override
    public void baseClickedByPlayer(ITeamBase base, EntityPlayerMP player) {
        if (base instanceof EntityFlagpole && ((EntityFlag)base.getFlag()).isHome) {
            this.objectClickedByPlayer(base.getFlag(), player);
        }
    }

    @Override
    public void objectClickedByPlayer(ITeamObject object, EntityPlayerMP player) {
        EntityFlag flag;
        if (GameTypeCTF.teamsManager.currentRound == null) {
            return;
        }
        if (object instanceof EntityFlag && (flag = (EntityFlag)object).getBase().getOwnerID() > 1) {
            Team playerTeam = GameTypeCTF.getPlayerData((EntityPlayerMP)player).team;
            PlayerData playerData = GameTypeCTF.getPlayerData(player);
            Team flagTeam = teamsManager.getTeam(flag.getBase().getOwnerID());
            if (playerTeam != null && playerTeam != Team.spectators && flag.getBase().getMap() == GameTypeCTF.teamsManager.currentRound.map) {
                if (playerTeam == flagTeam) {
                    EntityFlag otherFlag;
                    Team otherFlagTeam;
                    if (flag.field_70154_o == null && !flag.isHome) {
                        flag.reset();
                        playerData.score += 2;
                        ++GameTypeCTF.getPlayerInfo((EntityPlayerMP)player).savedFlags;
                        GameTypeCTF.getPlayerInfo(player).addExp(10.0f);
                        GameTypeCTF.getPlayerInfo(player).savePlayerStats();
                        TeamsManager.messageAll("\u00a7f" + player.func_70005_c_() + " returned the \u00a7" + flagTeam.textColour + flagTeam.name + "\u00a7f flag");
                    } else if (player.field_70153_n instanceof EntityFlag && (otherFlagTeam = teamsManager.getTeam((otherFlag = (EntityFlag)player.field_70153_n).getBase().getOwnerID())) != null && otherFlagTeam != Team.spectators && otherFlagTeam != flagTeam && flag.isHome) {
                        ++playerTeam.score;
                        playerData.score += 10;
                        ++GameTypeCTF.getPlayerInfo((EntityPlayerMP)player).capturedFlags;
                        GameTypeCTF.getPlayerInfo(player).savePlayerStats();
                        GameTypeCTF.getPlayerInfo(player).addExp(20.0f);
                        otherFlag.reset();
                        TeamsManager.messageAll("\u00a7f" + player.func_70005_c_() + " captured the \u00a7" + otherFlagTeam.textColour + otherFlagTeam.name + "\u00a7f flag");
                    }
                } else if (flag.field_70154_o == player) {
                    flag.func_70078_a(null);
                    TeamsManager.messageAll("\u00a7f" + player.func_70005_c_() + " dropped the \u00a7" + flagTeam.textColour + flagTeam.name + "\u00a7f flag");
                } else if (flag.field_70154_o == null) {
                    if (flag.isHome) {
                        playerData.score += 3;
                    }
                    flag.func_70078_a((Entity)player);
                    TeamsManager.messageAll("\u00a7f" + player.func_70005_c_() + " picked up the \u00a7" + flagTeam.textColour + flagTeam.name + "\u00a7f flag");
                    flag.isHome = false;
                }
            }
        }
    }

    @Override
    public Vec3 getSpawnPoint(EntityPlayerMP player) {
        if (GameTypeCTF.teamsManager.currentRound == null) {
            return null;
        }
        PlayerData data = GameTypeCTF.getPlayerData(player);
        ArrayList<ITeamObject> validSpawnPoints = new ArrayList<ITeamObject>();
        if (data.newTeam == null) {
            return null;
        }
        ArrayList<ITeamBase> bases = GameTypeCTF.teamsManager.currentRound.map.getBasesPerTeam(GameTypeCTF.teamsManager.currentRound.getTeamID(data.newTeam));
        for (ITeamBase base : bases) {
            if (!base.getMap().equals(GameTypeCTF.teamsManager.currentRound.map)) continue;
            for (int i = 0; i < base.getObjects().size(); ++i) {
                if (!base.getObjects().get(i).isSpawnPoint()) continue;
                validSpawnPoints.add(base.getObjects().get(i));
            }
        }
        if (validSpawnPoints.size() > 0) {
            ITeamObject spawnPoint = (ITeamObject)validSpawnPoints.get(rand.nextInt(validSpawnPoints.size()));
            return Vec3.func_72443_a((double)spawnPoint.getPosX(), (double)spawnPoint.getPosY(), (double)spawnPoint.getPosZ());
        }
        return null;
    }

    @Override
    public void playerRespawned(EntityPlayerMP player) {
    }

    @Override
    public boolean setVariable(String variable, String value) {
        if (variable.toLowerCase().equals("friendlyfire")) {
            this.friendlyFire = Boolean.parseBoolean(value);
            return true;
        }
        if (variable.toLowerCase().equals("autobalance")) {
            this.autoBalance = Boolean.parseBoolean(value);
            return true;
        }
        if (variable.toLowerCase().equals("flagtime")) {
            this.flagReturnTime = Integer.parseInt(value);
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound tags) {
        this.friendlyFire = tags.func_74767_n("CTFFriendlyFire");
        this.autoBalance = tags.func_74767_n("CTFAutoBalance");
        this.flagReturnTime = tags.func_74762_e("CTFFlagTime");
    }

    @Override
    public void saveToNBT(NBTTagCompound tags) {
        tags.func_74757_a("CTFFriendlyFire", this.friendlyFire);
        tags.func_74757_a("CTFAutoBalance", this.autoBalance);
        tags.func_74768_a("CTFFlagTime", this.flagReturnTime);
    }

    @Override
    public boolean sortScoreboardByTeam() {
        return true;
    }

    @Override
    public boolean teamHasWon(Team team) {
        return GameTypeCTF.teamsManager.currentRound != null && team.score == GameTypeCTF.teamsManager.currentRound.scoreLimit;
    }
}

