/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.client.model.ModelCustomArmour;
import com.flansmod.common.FlansMod;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.model.ModelBase;

public class ArmourType
extends InfoType {
    public static ArrayList<ArmourType> armours = new ArrayList();
    public int type;
    public double defence;
    public double bulletDefence;
    public float penetrationResistance = 0.0f;
    public String armourTextureName;
    public float moveSpeedModifier = 1.0f;
    public float knockbackModifier = 0.2f;
    public float jumpModifier = 1.0f;
    public boolean nightVision = false;
    public boolean invisible = false;
    public String overlay = null;
    public boolean smokeProtection = false;
    public boolean negateFallDamage = false;
    public boolean fireResistance = false;
    public boolean waterBreathing = false;
    public boolean onWaterWalking = false;
    public boolean hasDurability = false;
    public int durability = 0;
    public ModelCustomArmour model;

    public ArmourType(TypeFile file) {
        super(file);
        armours.add(this);
    }

    @Override
    protected void preRead(TypeFile file) {
    }

    @Override
    protected void postRead(TypeFile file) {
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        block25: {
            super.read(split, file);
            try {
                if (FMLCommonHandler.instance().getSide().isClient() && split[0].equals("Model")) {
                    this.model = FlansMod.proxy.loadModel(split[1], this.shortName, ModelCustomArmour.class);
                    this.model.type = this;
                }
                if (split[0].equals("Type")) {
                    if (split[1].equals("Hat") || split[1].equals("Helmet")) {
                        this.type = 0;
                    }
                    if (split[1].equals("Chest") || split[1].equals("Body")) {
                        this.type = 1;
                    }
                    if (split[1].equals("Legs") || split[1].equals("Pants")) {
                        this.type = 2;
                    }
                    if (split[1].equals("Shoes") || split[1].equals("Boots")) {
                        this.type = 3;
                    }
                }
                if (split[0].equals("DamageReduction") || split[0].equals("Defence")) {
                    this.bulletDefence = this.defence = Double.parseDouble(split[1]);
                }
                if (split[0].equals("BulletDefence")) {
                    this.bulletDefence = Double.parseDouble(split[1]);
                }
                if (split[0].equals("OtherDefence")) {
                    this.defence = Double.parseDouble(split[1]);
                }
                if (split[0].equals("MoveSpeedModifier") || split[0].equals("Slowness")) {
                    this.moveSpeedModifier = Float.parseFloat(split[1]);
                }
                if (split[0].equals("JumpModifier")) {
                    this.jumpModifier = Float.parseFloat(split[1]);
                }
                if (split[0].equals("KnockbackReduction") || split[0].equals("KnockbackModifier")) {
                    this.knockbackModifier = Float.parseFloat(split[1]);
                }
                if (split[0].equals("PenetrationResistance")) {
                    this.penetrationResistance = Float.parseFloat(split[1]);
                }
                if (split[0].equals("NightVision")) {
                    this.nightVision = Boolean.parseBoolean(split[1]);
                }
                if (split[0].equals("Invisible")) {
                    this.invisible = Boolean.parseBoolean(split[1]);
                }
                if (split[0].equals("NegateFallDamage")) {
                    this.negateFallDamage = Boolean.parseBoolean(split[1]);
                }
                if (split[0].equals("FireResistance")) {
                    this.fireResistance = Boolean.parseBoolean(split[1]);
                }
                if (split[0].equals("WaterBreathing")) {
                    this.waterBreathing = Boolean.parseBoolean(split[1]);
                }
                if (split[0].equals("Overlay")) {
                    this.overlay = split[1];
                }
                if (split[0].equals("SmokeProtection")) {
                    this.smokeProtection = Boolean.parseBoolean(split[1]);
                }
                if (split[0].equals("OnWaterWalking")) {
                    this.onWaterWalking = Boolean.parseBoolean(split[1]);
                }
                if (split[0].equals("Durability")) {
                    this.durability = Integer.parseInt(split[1]);
                    boolean bl = this.hasDurability = this.durability > 0;
                }
                if (split[0].equals("ArmourTexture") || split[0].equals("ArmorTexture")) {
                    this.armourTextureName = split[1];
                }
            }
            catch (Exception e) {
                FlansMod.log("Reading armour file failed.");
                if (!FlansMod.printStackTrace) break block25;
                e.printStackTrace();
            }
        }
    }

    public static ArmourType getArmourType(String string) {
        for (ArmourType armour : armours) {
            if (!armour.shortName.equals(string)) continue;
            return armour;
        }
        return null;
    }

    @Override
    public void reloadModel() {
        this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelCustomArmour.class);
        if (this.model != null) {
            this.model.type = this;
        }
    }

    @Override
    public float GetRecommendedScale() {
        return 50.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBase GetModel() {
        return this.model;
    }
}

