/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.EnumWeaponType;
import com.flansmod.common.guns.ShootableType;
import com.flansmod.common.types.TypeFile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;

public class BulletType
extends ShootableType {
    public float speedMultiplier = 1.0f;
    public int flak = 0;
    public String flakParticles = "largesmoke";
    public boolean setEntitiesOnFire = false;
    public float livingProximityTrigger = -1.0f;
    public float driveableProximityTrigger = -1.0f;
    public float damageToTriggerer = 0.0f;
    public int primeDelay = 0;
    public int explodeParticles = 0;
    public String explodeParticleType = "largesmoke";
    public EnumWeaponType weaponType = EnumWeaponType.NONE;
    public String hitSound;
    public float hitSoundRange;
    public boolean hitSoundEnable = false;
    public boolean entityHitSoundEnable = false;
    public float penetratingPower = 1.0f;
    public float knockbackModifier;
    public boolean lockOnToPlanes = false;
    public boolean lockOnToVehicles = false;
    public boolean lockOnToMechas = false;
    public boolean lockOnToPlayers = false;
    public boolean lockOnToLivings = false;
    public float maxLockOnAngle = 45.0f;
    public float lockOnForce = 1.0f;
    public int maxDegreeOfMissile = 20;
    public int tickStartHoming = 5;
    public boolean enableSACLOS = false;
    public int maxDegreeOfSACLOS = 5;
    public int maxRangeOfMissile = 150;
    public boolean manualGuidance = false;
    public int lockOnFuse = 10;
    public ArrayList<PotionEffect> hitEffects = new ArrayList();
    public int numBullets = -1;
    public float bulletSpread = -1.0f;
    public float dragInAir = 0.99f;
    public float dragInWater = 0.8f;
    public boolean canSpotEntityDriveable = false;
    public int maxRange = -1;
    public boolean shootForSettingPos = false;
    public int shootForSettingPosHeight = 100;
    public boolean isDoTopAttack = false;
    public int smokeTime = 0;
    public String smokeParticleType = "explode";
    public ArrayList<PotionEffect> smokeEffects = new ArrayList();
    public float smokeRadius = 5.0f;
    public boolean TVguide = true;
    public boolean VLS = false;
    public int VLSTime = 0;
    public boolean fixedDirection = false;
    public float turnRadius = 3.0f;
    public String boostPhaseParticle;
    public float trackPhaseSpeed = 2.0f;
    public float trackPhaseTurn = 0.2f;
    public boolean torpedo = false;
    public boolean fancyDescription = true;
    public static List<BulletType> bullets = new ArrayList<BulletType>();

    public BulletType(TypeFile file) {
        super(file);
        this.texture = "defaultBullet";
        bullets.add(this);
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        block119: {
            super.read(split, file);
            try {
                if (split[0].equals("FlakParticles")) {
                    this.flak = Integer.parseInt(split[1]);
                } else if (split[0].equals("FlakParticleType")) {
                    this.flakParticles = split[1];
                } else if (split[0].equals("SetEntitiesOnFire")) {
                    this.setEntitiesOnFire = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("HitSoundEnable")) {
                    this.hitSoundEnable = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("EntityHitSoundEnable")) {
                    this.entityHitSoundEnable = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("HitSound")) {
                    this.hitSound = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "sound", split[1]);
                } else if (split[0].equals("HitSoundRange")) {
                    this.hitSoundRange = Float.parseFloat(split[1]);
                } else if (split[0].equals("Penetrates")) {
                    this.penetratingPower = Boolean.parseBoolean(split[1].toLowerCase()) ? 1.0f : 0.7f;
                } else if (split[0].equals("Penetration") || split[0].equals("PenetratingPower")) {
                    this.penetratingPower = Float.parseFloat(split[1]);
                } else if (split[0].equals("DragInAir")) {
                    this.dragInAir = Float.parseFloat(split[1]);
                    this.dragInAir = this.dragInAir < 0.0f ? 0.0f : (this.dragInAir > 1.0f ? 1.0f : this.dragInAir);
                } else if (split[0].equals("DragInWater")) {
                    this.dragInWater = Float.parseFloat(split[1]);
                    this.dragInWater = this.dragInWater < 0.0f ? 0.0f : (this.dragInWater > 1.0f ? 1.0f : this.dragInWater);
                } else if (split[0].equals("NumBullets")) {
                    this.numBullets = Integer.parseInt(split[1]);
                } else if (split[0].equals("Accuracy") || split[0].equals("Spread")) {
                    this.bulletSpread = Float.parseFloat(split[1]);
                } else if (split[0].equals("LivingProximityTrigger")) {
                    this.livingProximityTrigger = Float.parseFloat(split[1]);
                } else if (split[0].equals("VehicleProximityTrigger")) {
                    this.driveableProximityTrigger = Float.parseFloat(split[1]);
                } else if (split[0].equals("DamageToTriggerer")) {
                    this.damageToTriggerer = Float.parseFloat(split[1]);
                } else if (split[0].equals("PrimeDelay") || split[0].equals("TriggerDelay")) {
                    this.primeDelay = Integer.parseInt(split[1]);
                } else if (split[0].equals("NumExplodeParticles")) {
                    this.explodeParticles = Integer.parseInt(split[1]);
                } else if (split[0].equals("ExplodeParticles")) {
                    this.explodeParticleType = split[1];
                } else if (split[0].equals("SmokeTime")) {
                    this.smokeTime = Integer.parseInt(split[1]);
                } else if (split[0].equals("SmokeParticles")) {
                    this.smokeParticleType = split[1];
                } else if (split[0].equals("SmokeEffect")) {
                    this.smokeEffects.add(BulletType.getPotionEffect(split));
                } else if (split[0].equals("SmokeRadius")) {
                    this.smokeRadius = Float.parseFloat(split[1]);
                } else if (split[0].equals("VLS") || split[0].equals("HasDeadZone")) {
                    this.VLS = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("VLSTime") || split[0].equals("DeadZoneTime")) {
                    this.VLSTime = Integer.parseInt(split[1]);
                } else if (split[0].equals("FixedTrackDirection")) {
                    this.fixedDirection = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("GuidedTurnRadius")) {
                    this.turnRadius = Float.parseFloat(split[1]);
                } else if (split[0].equals("GuidedPhaseSpeed")) {
                    this.trackPhaseSpeed = Float.parseFloat(split[1]);
                } else if (split[0].equals("GuidedPhaseTurnSpeed")) {
                    this.trackPhaseTurn = Float.parseFloat(split[1]);
                } else if (split[0].equals("BoostParticle")) {
                    this.boostPhaseParticle = split[1];
                } else if (split[0].equals("Torpedo")) {
                    this.torpedo = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("Bomb")) {
                    this.weaponType = EnumWeaponType.BOMB;
                } else if (split[0].equals("Shell")) {
                    this.weaponType = EnumWeaponType.SHELL;
                } else if (split[0].equals("Missile")) {
                    this.weaponType = EnumWeaponType.MISSILE;
                } else if (split[0].equals("WeaponType")) {
                    this.weaponType = EnumWeaponType.valueOf(split[1].toUpperCase());
                } else if (split[0].equals("LockOnToDriveables")) {
                    this.lockOnToVehicles = this.lockOnToMechas = Boolean.parseBoolean(split[1].toLowerCase());
                    this.lockOnToPlanes = this.lockOnToMechas;
                } else if (split[0].equals("LockOnToVehicles")) {
                    this.lockOnToVehicles = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("LockOnToPlanes")) {
                    this.lockOnToPlanes = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("LockOnToMechas")) {
                    this.lockOnToMechas = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("LockOnToPlayers")) {
                    this.lockOnToPlayers = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("LockOnToLivings")) {
                    this.lockOnToLivings = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("MaxLockOnAngle")) {
                    this.maxLockOnAngle = Float.parseFloat(split[1]);
                } else if (split[0].equals("LockOnForce") || split[0].equals("TurningForce")) {
                    this.lockOnForce = Float.parseFloat(split[1]);
                } else if (split[0].equals("MaxDegreeOfLockOnMissile")) {
                    this.maxDegreeOfMissile = Integer.parseInt(split[1]);
                } else if (split[0].equals("TickStartHoming")) {
                    this.tickStartHoming = Integer.parseInt(split[1]);
                } else if (split[0].equals("EnableSACLOS")) {
                    this.enableSACLOS = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("MaxDegreeOFSACLOS")) {
                    this.maxDegreeOfSACLOS = Integer.parseInt(split[1]);
                } else if (split[0].equals("MaxRangeOfMissile")) {
                    this.maxRangeOfMissile = Integer.parseInt(split[1]);
                } else if (split[0].equals("CanSpotEntityDriveable")) {
                    this.canSpotEntityDriveable = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("ShootForSettingPos")) {
                    this.shootForSettingPos = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("ShootForSettingPosHeight")) {
                    this.shootForSettingPosHeight = Integer.parseInt(split[1]);
                } else if (split[0].equals("IsDoTopAttack")) {
                    this.isDoTopAttack = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("KnockbackModifier")) {
                    this.knockbackModifier = Float.parseFloat(split[1]);
                } else if (split[0].equals("PotionEffect")) {
                    this.hitEffects.add(BulletType.getPotionEffect(split));
                } else if (split[0].equals("ManualGuidance")) {
                    this.manualGuidance = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("LockOnFuse")) {
                    this.lockOnFuse = Integer.parseInt(split[1]);
                } else if (split[0].equals("MaxRange")) {
                    this.maxRange = Integer.parseInt(split[1]);
                } else if (split[0].equals("FancyDescription")) {
                    this.fancyDescription = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("BulletSpeedMultiplier")) {
                    this.speedMultiplier = Float.parseFloat(split[1]);
                }
            }
            catch (Exception e) {
                FlansMod.log("Reading bullet file failed.");
                if (!FlansMod.printStackTrace) break block119;
                e.printStackTrace();
            }
        }
    }

    public static BulletType getBullet(String s) {
        for (BulletType bullet : bullets) {
            if (!bullet.shortName.equals(s)) continue;
            return bullet;
        }
        return null;
    }

    public static BulletType getBullet(Item item) {
        for (BulletType bullet : bullets) {
            if (bullet.item != item) continue;
            return bullet;
        }
        return null;
    }

    @Override
    public void reloadModel() {
        this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelBase.class);
    }
}

