/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.util.ForgeDirection;

public class RotationHelper {
    private static final ForgeDirection[] UP_DOWN_AXES = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
    private static final Map<BlockType, BiMap<Integer, ForgeDirection>> MAPPINGS = new HashMap<BlockType, BiMap<Integer, ForgeDirection>>();

    public static ForgeDirection[] getValidVanillaBlockRotations(aji block) {
        return block instanceof ajh || block instanceof amw || block instanceof ala || block instanceof aku || block instanceof aog || block instanceof ajz || block instanceof amt || block instanceof aki || block instanceof ans || block instanceof ajx || block instanceof akv || block instanceof ale || block instanceof als || block == ajn.as || block == ajn.an || block instanceof akn || block instanceof amy || block instanceof ajs || block instanceof anf || block instanceof akc || block instanceof aoe || block instanceof alo || block instanceof aoh || block instanceof anl || block instanceof ajb ? UP_DOWN_AXES : ForgeDirection.VALID_DIRECTIONS;
    }

    public static boolean rotateVanillaBlock(aji block, ahb worldObj, int x, int y2, int z2, ForgeDirection axis) {
        if (worldObj.E) {
            return false;
        }
        if (axis == ForgeDirection.UP || axis == ForgeDirection.DOWN) {
            if (block instanceof ajh || block instanceof amw || block instanceof ala || block instanceof aku || block instanceof aog || block instanceof ajz) {
                return RotationHelper.rotateBlock(worldObj, x, y2, z2, axis, 3, BlockType.BED);
            }
            if (block instanceof amy) {
                return RotationHelper.rotateBlock(worldObj, x, y2, z2, axis, 15, BlockType.RAIL);
            }
            if (block instanceof amt || block instanceof aki) {
                return RotationHelper.rotateBlock(worldObj, x, y2, z2, axis, 7, BlockType.RAIL_POWERED);
            }
            if (block instanceof ans) {
                return RotationHelper.rotateBlock(worldObj, x, y2, z2, axis, 3, BlockType.STAIR);
            }
            if (block instanceof ajx || block instanceof akv || block instanceof ale || block instanceof als || block == ajn.as) {
                return RotationHelper.rotateBlock(worldObj, x, y2, z2, axis, 7, BlockType.CHEST);
            }
            if (block == ajn.an) {
                return RotationHelper.rotateBlock(worldObj, x, y2, z2, axis, 15, BlockType.SIGNPOST);
            }
            if (block instanceof akn) {
                return RotationHelper.rotateBlock(worldObj, x, y2, z2, axis, 3, BlockType.DOOR);
            }
            if (block instanceof ajs) {
                return RotationHelper.rotateBlock(worldObj, x, y2, z2, axis, 7, BlockType.BUTTON);
            }
            if (block instanceof anf || block instanceof akc) {
                return RotationHelper.rotateBlock(worldObj, x, y2, z2, axis, 3, BlockType.REDSTONE_REPEATER);
            }
            if (block instanceof aoe) {
                return RotationHelper.rotateBlock(worldObj, x, y2, z2, axis, 3, BlockType.TRAPDOOR);
            }
            if (block instanceof alo) {
                return RotationHelper.rotateBlock(worldObj, x, y2, z2, axis, 15, BlockType.MUSHROOM_CAP);
            }
            if (block instanceof aoh) {
                return RotationHelper.rotateBlock(worldObj, x, y2, z2, axis, 15, BlockType.VINE);
            }
            if (block instanceof anl) {
                return RotationHelper.rotateBlock(worldObj, x, y2, z2, axis, 7, BlockType.SKULL);
            }
            if (block instanceof ajb) {
                return RotationHelper.rotateBlock(worldObj, x, y2, z2, axis, 1, BlockType.ANVIL);
            }
        }
        if (block instanceof alx) {
            return RotationHelper.rotateBlock(worldObj, x, y2, z2, axis, 12, BlockType.LOG);
        }
        if (block instanceof akm || block instanceof app || block instanceof apq || block instanceof aln) {
            return RotationHelper.rotateBlock(worldObj, x, y2, z2, axis, 7, BlockType.DISPENSER);
        }
        if (block instanceof aoc) {
            return RotationHelper.rotateBlock(worldObj, x, y2, z2, axis, 15, BlockType.TORCH);
        }
        if (block instanceof alv) {
            return RotationHelper.rotateBlock(worldObj, x, y2, z2, axis, 7, BlockType.LEVER);
        }
        return false;
    }

    private static boolean rotateBlock(ahb worldObj, int x, int y2, int z2, ForgeDirection axis, int mask, BlockType blockType) {
        int rotMeta = worldObj.e(x, y2, z2);
        if (blockType == BlockType.DOOR && (rotMeta & 8) == 8) {
            return false;
        }
        int masked = rotMeta & ~mask;
        int meta = RotationHelper.rotateMetadata(axis, blockType, rotMeta & mask);
        if (meta == -1) {
            return false;
        }
        worldObj.a(x, y2, z2, meta & mask | masked, 3);
        return true;
    }

    private static int rotateMetadata(ForgeDirection axis, BlockType blockType, int meta) {
        if (blockType == BlockType.RAIL || blockType == BlockType.RAIL_POWERED) {
            if (meta == 0 || meta == 1) {
                return ~meta & 1;
            }
            if (meta >= 2 && meta <= 5) {
                blockType = BlockType.RAIL_ASCENDING;
            }
            if (meta >= 6 && meta <= 9 && blockType == BlockType.RAIL) {
                blockType = BlockType.RAIL_CORNER;
            }
        }
        if (blockType == BlockType.SIGNPOST) {
            return axis == ForgeDirection.UP ? (meta + 4) % 16 : (meta + 12) % 16;
        }
        if (blockType == BlockType.LEVER && (axis == ForgeDirection.UP || axis == ForgeDirection.DOWN)) {
            switch (meta) {
                case 5: {
                    return 6;
                }
                case 6: {
                    return 5;
                }
                case 7: {
                    return 0;
                }
                case 0: {
                    return 7;
                }
            }
        }
        if (blockType == BlockType.MUSHROOM_CAP) {
            blockType = meta % 2 == 0 ? BlockType.MUSHROOM_CAP_SIDE : BlockType.MUSHROOM_CAP_CORNER;
        }
        if (blockType == BlockType.VINE) {
            return meta << 1 | (meta & 8) >> 3;
        }
        ForgeDirection orientation = RotationHelper.metadataToDirection(blockType, meta);
        ForgeDirection rotated = orientation.getRotation(axis);
        return RotationHelper.directionToMetadata(blockType, rotated);
    }

    private static ForgeDirection metadataToDirection(BlockType blockType, int meta) {
        BiMap<Integer, ForgeDirection> biMap;
        if (blockType == BlockType.LEVER) {
            if (meta == 6) {
                meta = 5;
            } else if (meta == 0) {
                meta = 7;
            }
        }
        if (MAPPINGS.containsKey((Object)blockType) && (biMap = MAPPINGS.get((Object)blockType)).containsKey((Object)meta)) {
            return (ForgeDirection)((Object)biMap.get((Object)meta));
        }
        if (blockType == BlockType.TORCH) {
            return ForgeDirection.getOrientation(6 - meta);
        }
        if (blockType == BlockType.STAIR) {
            return ForgeDirection.getOrientation(5 - meta);
        }
        if (blockType == BlockType.CHEST || blockType == BlockType.DISPENSER || blockType == BlockType.SKULL) {
            return ForgeDirection.getOrientation(meta);
        }
        if (blockType == BlockType.BUTTON) {
            return ForgeDirection.getOrientation(6 - meta);
        }
        if (blockType == BlockType.TRAPDOOR) {
            return ForgeDirection.getOrientation(meta + 2).getOpposite();
        }
        return ForgeDirection.UNKNOWN;
    }

    private static int directionToMetadata(BlockType blockType, ForgeDirection direction) {
        BiMap biMap;
        if ((blockType == BlockType.LOG || blockType == BlockType.ANVIL) && direction.offsetX + direction.offsetY + direction.offsetZ < 0) {
            direction = direction.getOpposite();
        }
        if (MAPPINGS.containsKey((Object)blockType) && (biMap = MAPPINGS.get((Object)blockType).inverse()).containsKey((Object)direction)) {
            return (Integer)biMap.get((Object)direction);
        }
        if (blockType == BlockType.TORCH && direction.ordinal() >= 1) {
            return 6 - direction.ordinal();
        }
        if (blockType == BlockType.STAIR) {
            return 5 - direction.ordinal();
        }
        if (blockType == BlockType.CHEST || blockType == BlockType.DISPENSER || blockType == BlockType.SKULL) {
            return direction.ordinal();
        }
        if (blockType == BlockType.BUTTON && direction.ordinal() >= 2) {
            return 6 - direction.ordinal();
        }
        if (blockType == BlockType.TRAPDOOR) {
            return direction.getOpposite().ordinal() - 2;
        }
        return -1;
    }

    static {
        HashBiMap biMap = HashBiMap.create((int)3);
        biMap.put((Object)0, (Object)ForgeDirection.UP);
        biMap.put((Object)4, (Object)ForgeDirection.EAST);
        biMap.put((Object)8, (Object)ForgeDirection.SOUTH);
        MAPPINGS.put(BlockType.LOG, (BiMap<Integer, ForgeDirection>)biMap);
        biMap = HashBiMap.create((int)4);
        biMap.put((Object)0, (Object)ForgeDirection.SOUTH);
        biMap.put((Object)1, (Object)ForgeDirection.WEST);
        biMap.put((Object)2, (Object)ForgeDirection.NORTH);
        biMap.put((Object)3, (Object)ForgeDirection.EAST);
        MAPPINGS.put(BlockType.BED, (BiMap<Integer, ForgeDirection>)biMap);
        biMap = HashBiMap.create((int)4);
        biMap.put((Object)2, (Object)ForgeDirection.EAST);
        biMap.put((Object)3, (Object)ForgeDirection.WEST);
        biMap.put((Object)4, (Object)ForgeDirection.NORTH);
        biMap.put((Object)5, (Object)ForgeDirection.SOUTH);
        MAPPINGS.put(BlockType.RAIL_ASCENDING, (BiMap<Integer, ForgeDirection>)biMap);
        biMap = HashBiMap.create((int)4);
        biMap.put((Object)6, (Object)ForgeDirection.WEST);
        biMap.put((Object)7, (Object)ForgeDirection.NORTH);
        biMap.put((Object)8, (Object)ForgeDirection.EAST);
        biMap.put((Object)9, (Object)ForgeDirection.SOUTH);
        MAPPINGS.put(BlockType.RAIL_CORNER, (BiMap<Integer, ForgeDirection>)biMap);
        biMap = HashBiMap.create((int)6);
        biMap.put((Object)1, (Object)ForgeDirection.EAST);
        biMap.put((Object)2, (Object)ForgeDirection.WEST);
        biMap.put((Object)3, (Object)ForgeDirection.SOUTH);
        biMap.put((Object)4, (Object)ForgeDirection.NORTH);
        biMap.put((Object)5, (Object)ForgeDirection.UP);
        biMap.put((Object)7, (Object)ForgeDirection.DOWN);
        MAPPINGS.put(BlockType.LEVER, (BiMap<Integer, ForgeDirection>)biMap);
        biMap = HashBiMap.create((int)4);
        biMap.put((Object)0, (Object)ForgeDirection.WEST);
        biMap.put((Object)1, (Object)ForgeDirection.NORTH);
        biMap.put((Object)2, (Object)ForgeDirection.EAST);
        biMap.put((Object)3, (Object)ForgeDirection.SOUTH);
        MAPPINGS.put(BlockType.DOOR, (BiMap<Integer, ForgeDirection>)biMap);
        biMap = HashBiMap.create((int)4);
        biMap.put((Object)0, (Object)ForgeDirection.NORTH);
        biMap.put((Object)1, (Object)ForgeDirection.EAST);
        biMap.put((Object)2, (Object)ForgeDirection.SOUTH);
        biMap.put((Object)3, (Object)ForgeDirection.WEST);
        MAPPINGS.put(BlockType.REDSTONE_REPEATER, (BiMap<Integer, ForgeDirection>)biMap);
        biMap = HashBiMap.create((int)4);
        biMap.put((Object)1, (Object)ForgeDirection.EAST);
        biMap.put((Object)3, (Object)ForgeDirection.SOUTH);
        biMap.put((Object)7, (Object)ForgeDirection.NORTH);
        biMap.put((Object)9, (Object)ForgeDirection.WEST);
        MAPPINGS.put(BlockType.MUSHROOM_CAP_CORNER, (BiMap<Integer, ForgeDirection>)biMap);
        biMap = HashBiMap.create((int)4);
        biMap.put((Object)2, (Object)ForgeDirection.NORTH);
        biMap.put((Object)4, (Object)ForgeDirection.WEST);
        biMap.put((Object)6, (Object)ForgeDirection.EAST);
        biMap.put((Object)8, (Object)ForgeDirection.SOUTH);
        MAPPINGS.put(BlockType.MUSHROOM_CAP_SIDE, (BiMap<Integer, ForgeDirection>)biMap);
        biMap = HashBiMap.create((int)2);
        biMap.put((Object)0, (Object)ForgeDirection.SOUTH);
        biMap.put((Object)1, (Object)ForgeDirection.EAST);
        MAPPINGS.put(BlockType.ANVIL, (BiMap<Integer, ForgeDirection>)biMap);
    }

    private static enum BlockType {
        LOG,
        DISPENSER,
        BED,
        RAIL,
        RAIL_POWERED,
        RAIL_ASCENDING,
        RAIL_CORNER,
        TORCH,
        STAIR,
        CHEST,
        SIGNPOST,
        DOOR,
        LEVER,
        BUTTON,
        REDSTONE_REPEATER,
        TRAPDOOR,
        MUSHROOM_CAP,
        MUSHROOM_CAP_CORNER,
        MUSHROOM_CAP_SIDE,
        VINE,
        SKULL,
        ANVIL;

    }
}

