/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.worldGen.villages;

import cpw.mods.fml.common.registry.VillagerRegistry;
import gollorum.signpost.management.ClientConfigStorage;
import gollorum.signpost.worldGen.villages.signpost.SignpostVillageCreationHandler;
import gollorum.signpost.worldGen.villages.signpost.VillageComponentSignpost;
import gollorum.signpost.worldGen.villages.waystone.VillageComponentWaystone;
import gollorum.signpost.worldGen.villages.waystone.WaystoneVillageCreationHandler;
import net.minecraft.world.gen.structure.MapGenStructureIO;

public class VillageHandler {
    private static final VillageHandler INSTANCE = new VillageHandler();

    public static VillageHandler getInstance() {
        return INSTANCE;
    }

    private VillageHandler() {
    }

    public void register() {
        if (ClientConfigStorage.INSTANCE.isDisableVillageGeneration()) {
            return;
        }
        this.registerVillagePieces();
        this.registerHandlers();
    }

    private void registerVillagePieces() {
        this.registerVillagePiece("villageComponentSignpost", VillageComponentSignpost.class);
        this.registerVillagePiece("villageComponentWaystone", VillageComponentWaystone.class);
    }

    private void registerVillagePiece(String name, Class componentClass) {
        MapGenStructureIO.func_143031_a((Class)componentClass, (String)name);
    }

    private void registerHandlers() {
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new SignpostVillageCreationHandler());
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new WaystoneVillageCreationHandler());
    }
}

