/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.worldGen.villages;

import gollorum.signpost.blocks.SuperPostPost;
import gollorum.signpost.management.ClientConfigStorage;
import gollorum.signpost.management.PostHandler;
import gollorum.signpost.util.BiomeContainer;
import gollorum.signpost.util.MyBlockPos;
import gollorum.signpost.util.MyBlockPosSet;
import gollorum.signpost.util.Paintable;
import gollorum.signpost.util.Sign;
import gollorum.signpost.util.code.MinecraftIndependent;
import gollorum.signpost.util.collections.Lurchpaerchensauna;
import gollorum.signpost.worldGen.villages.LibraryHelper;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@MinecraftIndependent
class LibrarySignpostHelper
extends LibraryHelper {
    private static final Map<MyBlockPos, MyBlockPosSet> takenWaystones = new Lurchpaerchensauna<MyBlockPos, MyBlockPosSet>();
    private MyBlockPos signpostLocation;
    private Map<MyBlockPos, MyBlockPos> villageWaystones;

    LibrarySignpostHelper(MyBlockPos villageLocation, MyBlockPos signpostLocation, Map<MyBlockPos, MyBlockPos> villageWaystones) {
        super(villageLocation);
        this.signpostLocation = signpostLocation;
        this.villageWaystones = villageWaystones;
        if (!takenWaystones.containsKey(villageLocation)) {
            takenWaystones.put(villageLocation, new MyBlockPosSet());
        }
    }

    void enscribeNewSign(double optimalRot) {
        List<Sign> signs = PostHandler.getSigns(this.signpostLocation);
        Paintable post = PostHandler.getPost(this.signpostLocation);
        final BiomeContainer biome = this.signpostLocation.getBiome();
        if (post != null && biome != null) {
            post.setTextureToBiomeDefault(biome);
        }
        if ((post = PostHandler.getPost(this.signpostLocation.getBelow())) != null && biome != null) {
            post.setTextureToBiomeDefault(biome);
        }
        if (biome != null) {
            signs.forEach(new Consumer<Sign>(){

                @Override
                public void accept(Sign sign) {
                    sign.setTextureToBiomeDefault(biome);
                }
            });
        }
        List<MyBlockPos> closestWaystones = this.getClosestWaystones(signs.size());
        for (int i = 0; i < signs.size() && i < closestWaystones.size(); ++i) {
            if (signs.get((int)i).base != null) continue;
            signs.get((int)i).base = this.getBaseInfo(closestWaystones.get(i));
            takenWaystones.get(this.villageLocation).add(closestWaystones.get(i));
            signs.get((int)i).point = true;
            if (!this.angleTooLarge(this.calcRot(this.signpostLocation, closestWaystones.get(i)), optimalRot)) continue;
            signs.get((int)i).flip = true;
        }
        SuperPostPost.updateServer(this.signpostLocation);
    }

    private List<MyBlockPos> getClosestWaystones(int size) {
        List<MyBlockPos> waystones = this.getAllowedWaystones();
        waystones.sort(new Comparator<MyBlockPos>(){

            @Override
            public int compare(MyBlockPos pos1, MyBlockPos pos2) {
                return LibrarySignpostHelper.this.compareClosest(pos1, pos2, LibrarySignpostHelper.this.signpostLocation);
            }
        });
        MyBlockPos myPos = this.villageWaystones.get(this.villageLocation);
        for (MyBlockPos now : waystones) {
            if (!now.equals(myPos)) continue;
            myPos = now;
            break;
        }
        waystones.remove(myPos);
        return waystones;
    }

    private List<MyBlockPos> getAllowedWaystones() {
        LinkedList<MyBlockPos> ret = new LinkedList<MyBlockPos>();
        if (ClientConfigStorage.INSTANCE.isOnlyVillageTargets()) {
            ret.addAll(this.villageWaystones.values());
        } else {
            ret.addAll(PostHandler.getNativeWaystones().positions());
        }
        ret.removeAll(takenWaystones.get(this.villageLocation));
        return ret;
    }
}

