/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.network.messages;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import gollorum.signpost.management.ConfigHandler;
import gollorum.signpost.management.PostHandler;
import gollorum.signpost.util.BaseInfo;
import gollorum.signpost.util.StonedHashSet;
import io.netty.buffer.ByteBuf;

public class InitPlayerResponseMessage
implements IMessage {
    public StonedHashSet allWaystones = new StonedHashSet();
    public boolean deactivateTeleportation;
    public boolean interdimensional;
    public int maxDist;
    public String paymentItem;
    public int costMult;
    public int costBase;
    public ConfigHandler.RecipeCost signRec;
    public ConfigHandler.RecipeCost waysRec;
    public ConfigHandler.SecurityLevel securityLevelWaystone;
    public ConfigHandler.SecurityLevel securityLevelSignpost;
    public boolean disableVillageGeneration;
    public int villageWaystonesWeight;
    public int villageMaxSignposts;
    public int villageSignpostsWeight;
    public boolean onlyVillageTargets;
    public String[] allowedCraftingModels;
    public String[] allowedVillageModels;

    public InitPlayerResponseMessage() {
        if (!ConfigHandler.isDeactivateTeleportation()) {
            this.allWaystones = PostHandler.getNativeWaystones();
        }
        this.deactivateTeleportation = ConfigHandler.isDeactivateTeleportation();
        this.interdimensional = ConfigHandler.isInterdimensional();
        this.maxDist = ConfigHandler.getMaxDist();
        this.paymentItem = ConfigHandler.getPaymentItem();
        this.costMult = ConfigHandler.getCostMult();
        this.costBase = ConfigHandler.getCostBase();
        this.signRec = ConfigHandler.getSignRec();
        this.waysRec = ConfigHandler.getWaysRec();
        this.securityLevelWaystone = ConfigHandler.getSecurityLevelWaystone();
        this.securityLevelSignpost = ConfigHandler.getSecurityLevelSignpost();
        this.disableVillageGeneration = ConfigHandler.isDisableVillageGeneration();
        this.villageMaxSignposts = ConfigHandler.getVillageMaxSignposts();
        this.villageSignpostsWeight = ConfigHandler.getVillageSignpostsWeight();
        this.villageWaystonesWeight = ConfigHandler.getVillageWaystonesWeight();
        this.onlyVillageTargets = ConfigHandler.isOnlyVillageTargets();
        this.allowedCraftingModels = ConfigHandler.getAllowedCraftingModels();
        this.allowedVillageModels = ConfigHandler.getAllowedVillageModels();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.deactivateTeleportation);
        if (!ConfigHandler.isDeactivateTeleportation()) {
            buf.writeInt(this.allWaystones.size());
            for (BaseInfo now : this.allWaystones) {
                now.toBytes(buf);
            }
        }
        buf.writeBoolean(this.interdimensional);
        buf.writeInt(this.maxDist);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.paymentItem);
        buf.writeInt(this.costMult);
        buf.writeInt(this.costBase);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.securityLevelWaystone.name());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.securityLevelSignpost.name());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.signRec.name());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.waysRec.name());
        buf.writeBoolean(this.disableVillageGeneration);
        buf.writeInt(this.villageMaxSignposts);
        buf.writeInt(this.villageSignpostsWeight);
        buf.writeInt(this.villageWaystonesWeight);
        buf.writeBoolean(this.onlyVillageTargets);
        buf.writeInt(this.allowedCraftingModels.length);
        for (String ws : this.allowedCraftingModels) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)ws);
        }
        buf.writeInt(this.allowedVillageModels.length);
        for (String ws : this.allowedVillageModels) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)ws);
        }
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        this.deactivateTeleportation = buf.readBoolean();
        if (!this.deactivateTeleportation) {
            this.allWaystones = new StonedHashSet();
            int c = buf.readInt();
            for (int i2 = 0; i2 < c; ++i2) {
                this.allWaystones.add(BaseInfo.fromBytes(buf));
            }
        }
        this.interdimensional = buf.readBoolean();
        this.maxDist = buf.readInt();
        this.paymentItem = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.costMult = buf.readInt();
        this.costBase = buf.readInt();
        this.securityLevelWaystone = ConfigHandler.SecurityLevel.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.securityLevelSignpost = ConfigHandler.SecurityLevel.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.signRec = ConfigHandler.RecipeCost.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.waysRec = ConfigHandler.RecipeCost.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.disableVillageGeneration = buf.readBoolean();
        this.villageMaxSignposts = buf.readInt();
        this.villageSignpostsWeight = buf.readInt();
        this.villageWaystonesWeight = buf.readInt();
        this.onlyVillageTargets = buf.readBoolean();
        this.allowedCraftingModels = new String[buf.readInt()];
        for (i = 0; i < this.allowedCraftingModels.length; ++i) {
            this.allowedCraftingModels[i] = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
        this.allowedVillageModels = new String[buf.readInt()];
        for (i = 0; i < this.allowedVillageModels.length; ++i) {
            this.allowedVillageModels[i] = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
    }
}

