/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blocks;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import gollorum.signpost.BlockHandler;
import gollorum.signpost.SPEventHandler;
import gollorum.signpost.blocks.BasePost;
import gollorum.signpost.blocks.tiles.SuperPostPostTile;
import gollorum.signpost.event.UpdateWaystoneEvent;
import gollorum.signpost.event.UseSignpostEvent;
import gollorum.signpost.items.CalibratedPostWrench;
import gollorum.signpost.items.PostBrush;
import gollorum.signpost.items.PostWrench;
import gollorum.signpost.management.ClientConfigStorage;
import gollorum.signpost.management.PostHandler;
import gollorum.signpost.network.NetworkHandler;
import gollorum.signpost.network.messages.BaseUpdateClientMessage;
import gollorum.signpost.network.messages.ChatMessage;
import gollorum.signpost.network.messages.OpenGuiMessage;
import gollorum.signpost.network.messages.RequestTextureMessage;
import gollorum.signpost.util.BaseInfo;
import gollorum.signpost.util.MyBlockPos;
import gollorum.signpost.util.Paintable;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public abstract class SuperPostPost
extends BlockContainer {
    protected SuperPostPost(Material p_i45386_1_) {
        super(p_i45386_1_);
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        SuperPostPostTile superTile = SuperPostPost.getSuperTile(world, x, y, z);
        if (world.field_72995_K || !this.canUse((EntityPlayerMP)player, superTile)) {
            return;
        }
        Object hit = this.getHitTarget(world, x, y, z, player);
        if (this.isHitWaystone(hit) && player.func_70093_af()) {
            superTile.destroyWaystone();
        } else if (player.func_70694_bm() != null) {
            Item item = player.func_70694_bm().func_77973_b();
            if (item instanceof PostWrench) {
                if (player.func_70093_af()) {
                    if (this.preShiftClick(hit, superTile, player, x, y, z)) {
                        this.shiftClickWrench(hit, superTile, player, x, y, z);
                    }
                } else {
                    this.clickWrench(hit, superTile, player, x, y, z);
                }
            } else if (item instanceof CalibratedPostWrench) {
                if (player.func_70093_af()) {
                    if (this.preShiftClick(hit, superTile, player, x, y, z)) {
                        this.shiftClickCalibratedWrench(hit, superTile, player, x, y, z);
                    }
                } else {
                    this.clickCalibratedWrench(hit, superTile, player, x, y, z);
                }
            } else if (item instanceof PostBrush) {
                this.clickBrush(hit, superTile, player, x, y, z);
            } else if (player.func_70093_af()) {
                if (this.preShiftClick(hit, superTile, player, x, y, z)) {
                    this.shiftClick(hit, superTile, player, x, y, z);
                }
            } else {
                this.click(hit, superTile, player, x, y, z);
            }
        } else if (player.func_70093_af()) {
            if (this.preShiftClick(hit, superTile, player, x, y, z)) {
                this.shiftClickBare(hit, superTile, player, x, y, z);
            }
        } else {
            this.clickBare(hit, superTile, player, x, y, z);
        }
        this.sendPostBasesToAll(superTile);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer playerIn, int facing, float hitX, float hitY, float hitZ) {
        if (MinecraftForge.EVENT_BUS.post((Event)new UseSignpostEvent(playerIn, world, x, y, z)) || world.field_72995_K) {
            return true;
        }
        Object hit = this.getHitTarget(world, x, y, z, playerIn);
        SuperPostPostTile superTile = SuperPostPost.getSuperTile(world, x, y, z);
        EntityPlayerMP player = (EntityPlayerMP)playerIn;
        if (this.isHitWaystone(hit)) {
            this.rightClickWaystone(superTile, (EntityPlayer)player, x, y, z);
        } else if (player.func_70694_bm() != null) {
            if (player.func_70694_bm().func_77973_b() instanceof PostWrench) {
                if (!this.canUse(player, superTile)) {
                    return true;
                }
                this.rightClickWrench(hit, superTile, (EntityPlayer)player, x, y, z);
                this.sendPostBasesToAll(superTile);
            } else if (player.func_70694_bm().func_77973_b() instanceof CalibratedPostWrench) {
                if (!this.canUse(player, superTile)) {
                    return true;
                }
                this.rightClickCalibratedWrench(hit, superTile, (EntityPlayer)player, x, y, z);
            } else if (player.func_70694_bm().func_77973_b() instanceof PostBrush) {
                if (!this.canUse(player, superTile)) {
                    return true;
                }
                this.rightClickBrush(hit, superTile, (EntityPlayer)player, x, y, z);
                this.sendPostBasesToAll(superTile);
            } else if (superTile.isAwaitingPaint()) {
                if (!this.canUse(player, superTile)) {
                    return true;
                }
                if (superTile.getPaintObject() == null) {
                    superTile.setAwaitingPaint(false);
                } else {
                    NetworkHandler.netWrap.sendTo((IMessage)new RequestTextureMessage(x, y, z), player);
                }
            } else if (Block.func_149634_a((Item)player.func_70694_bm().func_77973_b()) instanceof BasePost) {
                if (this.rightClickBase(superTile, player, x, y, z)) {
                    this.preRightClick(hit, superTile, (EntityPlayer)player, x, y, z);
                }
            } else {
                this.preRightClick(hit, superTile, (EntityPlayer)player, x, y, z);
            }
        } else {
            this.preRightClick(hit, superTile, (EntityPlayer)player, x, y, z);
        }
        return true;
    }

    protected boolean canUse(EntityPlayerMP player, SuperPostPostTile tile) {
        return ClientConfigStorage.INSTANCE.getSecurityLevelSignpost().canUse(player, "" + tile.owner);
    }

    private void rightClickWaystone(SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        BaseInfo ws = superTile.getBaseInfo();
        if (!player.func_70093_af()) {
            if (!PostHandler.doesPlayerKnowNativeWaystone((EntityPlayerMP)player, ws)) {
                if (!ClientConfigStorage.INSTANCE.deactivateTeleportation()) {
                    NetworkHandler.netWrap.sendTo((IMessage)new ChatMessage("signpost.discovered", "<Waystone>", ws.getName()), (EntityPlayerMP)player);
                }
                PostHandler.addDiscovered(player.func_110124_au(), ws);
            }
        } else if (!ClientConfigStorage.INSTANCE.deactivateTeleportation() && ClientConfigStorage.INSTANCE.getSecurityLevelWaystone().canUse((EntityPlayerMP)player, "" + ws.owner)) {
            NetworkHandler.netWrap.sendTo((IMessage)new OpenGuiMessage(0, x, y, z), (EntityPlayerMP)player);
        }
    }

    private boolean rightClickBase(SuperPostPostTile superTile, EntityPlayerMP player, int x, int y, int z) {
        if (superTile.isWaystone()) {
            return true;
        }
        if (!ClientConfigStorage.INSTANCE.getSecurityLevelSignpost().canUse(player, "" + superTile.owner) || !SPEventHandler.INSTANCE.checkWaystoneCount(player)) {
            return true;
        }
        MyBlockPos blockPos = superTile.toPos();
        MyBlockPos telePos = new MyBlockPos((Entity)player);
        String name = BasePost.generateName();
        UUID owner = player.func_110124_au();
        BaseInfo ws = new BaseInfo(name, blockPos, telePos, owner);
        PostHandler.addWaystone(ws);
        PostHandler.addDiscovered(owner, ws);
        NetworkHandler.netWrap.sendToAll((IMessage)new BaseUpdateClientMessage());
        MinecraftForge.EVENT_BUS.post((Event)new UpdateWaystoneEvent(UpdateWaystoneEvent.WaystoneEventType.PLACED, superTile.func_145831_w(), telePos.x, telePos.y, telePos.z, name));
        NetworkHandler.netWrap.sendTo((IMessage)new OpenGuiMessage(0, x, y, z), player);
        superTile.isWaystone = true;
        player.field_71071_by.func_146026_a(Item.func_150898_a((Block)BlockHandler.base));
        return false;
    }

    private void preRightClick(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        if (this.isHitWaystone(hitObj)) {
            BaseInfo ws = superTile.getBaseInfo();
            if (!PostHandler.doesPlayerKnowNativeWaystone((EntityPlayerMP)player, ws)) {
                if (!ClientConfigStorage.INSTANCE.deactivateTeleportation()) {
                    NetworkHandler.netWrap.sendTo((IMessage)new ChatMessage("signpost.discovered", "<Waystone>", ws.getName()), (EntityPlayerMP)player);
                }
                PostHandler.addDiscovered(player.func_110124_au(), ws);
            }
        } else {
            this.rightClick(hitObj, superTile, player, x, y, z);
        }
    }

    private boolean preShiftClick(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        if (this.isHitWaystone(hitObj)) {
            superTile.destroyWaystone();
            return false;
        }
        return true;
    }

    protected abstract boolean isHitWaystone(Object var1);

    public abstract void clickWrench(Object var1, SuperPostPostTile var2, EntityPlayer var3, int var4, int var5, int var6);

    public abstract void rightClickWrench(Object var1, SuperPostPostTile var2, EntityPlayer var3, int var4, int var5, int var6);

    public abstract void shiftClickWrench(Object var1, SuperPostPostTile var2, EntityPlayer var3, int var4, int var5, int var6);

    public abstract void clickCalibratedWrench(Object var1, SuperPostPostTile var2, EntityPlayer var3, int var4, int var5, int var6);

    public abstract void rightClickCalibratedWrench(Object var1, SuperPostPostTile var2, EntityPlayer var3, int var4, int var5, int var6);

    public abstract void shiftClickCalibratedWrench(Object var1, SuperPostPostTile var2, EntityPlayer var3, int var4, int var5, int var6);

    public abstract void clickBrush(Object var1, SuperPostPostTile var2, EntityPlayer var3, int var4, int var5, int var6);

    public abstract void rightClickBrush(Object var1, SuperPostPostTile var2, EntityPlayer var3, int var4, int var5, int var6);

    public abstract void click(Object var1, SuperPostPostTile var2, EntityPlayer var3, int var4, int var5, int var6);

    public abstract void rightClick(Object var1, SuperPostPostTile var2, EntityPlayer var3, int var4, int var5, int var6);

    public abstract void shiftClick(Object var1, SuperPostPostTile var2, EntityPlayer var3, int var4, int var5, int var6);

    public abstract void clickBare(Object var1, SuperPostPostTile var2, EntityPlayer var3, int var4, int var5, int var6);

    public abstract void shiftClickBare(Object var1, SuperPostPostTile var2, EntityPlayer var3, int var4, int var5, int var6);

    public abstract void sendPostBasesToAll(SuperPostPostTile var1);

    public abstract void sendPostBasesToServer(SuperPostPostTile var1);

    public static SuperPostPostTile getSuperTile(World world, int x, int y, int z) {
        return (SuperPostPostTile)world.func_147438_o(x, y, z);
    }

    public static SuperPostPostTile getSuperTile(MyBlockPos pos) {
        TileEntity tile = pos.getTile();
        if (tile == null) {
            pos.getWorld().func_147439_a(pos.x, pos.y, pos.z);
            tile = pos.getTile();
        }
        if (tile instanceof SuperPostPostTile) {
            return (SuperPostPostTile)tile;
        }
        return null;
    }

    public static void updateServer(MyBlockPos pos) {
        SuperPostPostTile tile = SuperPostPost.getSuperTile(pos);
        if (tile == null) {
            return;
        }
        tile.getSuperBlock().sendPostBasesToAll(tile);
    }

    public static void updateClient(MyBlockPos pos) {
        SuperPostPostTile tile = SuperPostPost.getSuperTile(pos);
        if (tile == null) {
            return;
        }
        tile.getSuperBlock().sendPostBasesToServer(tile);
    }

    public abstract Object getHitTarget(World var1, int var2, int var3, int var4, EntityPlayer var5);

    public abstract Paintable getPaintableByHit(SuperPostPostTile var1, Object var2);

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public static void placeClient(World world, MyBlockPos blockPos, EntityPlayer player) {
        SuperPostPost.getSuperTile((World)world, (int)blockPos.x, (int)blockPos.y, (int)blockPos.z).owner = player.func_110124_au();
    }

    public static void placeServer(World world, MyBlockPos blockPos, EntityPlayerMP player) {
        SuperPostPost.getSuperTile((World)world, (int)blockPos.x, (int)blockPos.y, (int)blockPos.z).owner = player.func_110124_au();
    }
}

