/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.common.registry.GameRegistry;
import gollorum.signpost.BlockHandler;
import gollorum.signpost.ItemHandler;
import gollorum.signpost.SPEventHandler;
import gollorum.signpost.blocks.tiles.BaseModelPostTile;
import gollorum.signpost.blocks.tiles.BasePostTile;
import gollorum.signpost.blocks.tiles.BigPostPostTile;
import gollorum.signpost.blocks.tiles.PostPostTile;
import gollorum.signpost.network.NetworkHandler;
import gollorum.signpost.worldGen.villages.VillageHandler;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class CommonProxy {
    public BlockHandler blockHandler;
    ItemHandler itemHandler = new ItemHandler();

    public CommonProxy() {
        this.blockHandler = new BlockHandler();
    }

    void preInit() {
    }

    public void init() {
        this.registerBlocksAndItems();
        this.registerHandlers();
        this.registerVillageCreation();
    }

    private void registerVillageCreation() {
        VillageHandler.getInstance().register();
    }

    private void registerHandlers() {
        NetworkHandler.register();
        SPEventHandler handler = SPEventHandler.INSTANCE;
        MinecraftForge.EVENT_BUS.register((Object)handler);
        FMLCommonHandler.instance().bus().register((Object)handler);
    }

    private void registerBlocksAndItems() {
        this.blockHandler.registerBlocks();
        this.registerTiles();
        CommonProxy commonProxy = this;
        commonProxy.itemHandler.registerItems();
        this.registerRecipes();
    }

    protected void registerTiles() {
        GameRegistry.registerTileEntity(BasePostTile.class, (String)"SignpostBaseTile");
        GameRegistry.registerTileEntity(PostPostTile.class, (String)"SignpostPostTile");
        GameRegistry.registerTileEntity(BigPostPostTile.class, (String)"SignpostBigPostTile");
        GameRegistry.registerTileEntity(BaseModelPostTile.class, (String)"SignpostBaseModelPostTile");
    }

    protected void registerRecipes() {
        this.blockHandler.registerRecipes();
        CommonProxy commonProxy = this;
        commonProxy.itemHandler.registerRecipes();
    }

    public World getWorld(MessageContext ctx) {
        return ctx.getServerHandler().field_147369_b.field_70170_p;
    }

    public World getWorld(String worldName, int dim) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dim);
    }

    public World[] getWorlds() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c;
    }

    public Collection<EntityPlayer> getAllPlayers() {
        LinkedList<EntityPlayer> ret = new LinkedList<EntityPlayer>();
        for (Object now : FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().field_72404_b) {
            if (!(now instanceof EntityPlayer)) continue;
            ret.add((EntityPlayer)now);
        }
        return ret;
    }

    public InputStream getResourceInputStream(String location) {
        return this.getClass().getResourceAsStream(location);
    }
}

