/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.waypoint;

import com.thevoxelbox.voxelmap.VoxelMap;
import com.thevoxelbox.voxelmap.util.Waypoint;
import cpw.mods.fml.client.FMLClientHandler;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.WorldData;
import net.techbrew.journeymap.log.ChatLog;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.Waypoint;

public class VoxelReader {
    public static final String VOXEL_JAR_NAME = "voxelmap-1.7.2-1.0 (June 9, 2014)";
    public static final String VOXEL_JAR_URL = "http://www.mediafire.com/view/8tjjxvghv3jpv18/voxelmap-1.7.2-1.0";
    public static final String[] classNames = new String[]{"com.thevoxelbox.voxelmap.VoxelMap", "com.thevoxelbox.voxelmap.util.Waypoint"};
    public static Boolean modLoaded;
    int pointErrors = 0;
    int fileErrors = 0;

    public static List<net.techbrew.journeymap.model.Waypoint> loadWaypoints() {
        ArrayList voxelWaypoints = new ArrayList(0);
        try {
            voxelWaypoints.addAll(VoxelMap.getInstance().getWaypointManager().getWaypoints());
            modLoaded = true;
        }
        catch (Throwable e) {
            JourneyMap.getLogger().warn("Incompatible version of VoxelMap. Tried com.thevoxelbox.voxelmap.VoxelMap.instance.waypointManager.wayPts: " + e);
            if (!(e instanceof ClassNotFoundException)) {
                ChatLog.announceI18N("jm.waypoint.import_vox_version", new Object[0]);
                ChatLog.announceURL(VOXEL_JAR_NAME, VOXEL_JAR_URL);
            }
            modLoaded = false;
        }
        if (voxelWaypoints.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        try {
            ArrayList<net.techbrew.journeymap.model.Waypoint> converted = new ArrayList<net.techbrew.journeymap.model.Waypoint>(voxelWaypoints.size());
            for (Object wpObj : voxelWaypoints) {
                Waypoint voxWp = (Waypoint)wpObj;
                String name = voxWp.name.replaceAll("~comma~", ",");
                int x = voxWp.x;
                int y = voxWp.y;
                int z = voxWp.z;
                boolean enabled = voxWp.enabled;
                int r = (int)(voxWp.red * 255.0f) & 0xFF;
                int g = (int)(voxWp.green * 255.0f) & 0xFF;
                int b = (int)(voxWp.blue * 255.0f) & 0xFF;
                Waypoint.Type type = "skull".equals(voxWp.imageSuffix) ? Waypoint.Type.Death : Waypoint.Type.Normal;
                net.techbrew.journeymap.model.Waypoint jmWp = new net.techbrew.journeymap.model.Waypoint(name, x, y, z, enabled, r, g, b, type, Waypoint.Origin.VoxelMap, 0, voxWp.dimensions);
                jmWp.setReadOnly(true);
                converted.add(jmWp);
            }
            return converted;
        }
        catch (Throwable e) {
            JourneyMap.getLogger().error("Exception getting VoxelMap waypoints: " + LogFormatter.toString(e));
            modLoaded = false;
            return Collections.EMPTY_LIST;
        }
    }

    public static String getPointsFilename() {
        String worldName = WorldData.getWorldName(FMLClientHandler.instance().getClient(), true);
        return String.format("mods\\VoxelMods\\voxelMap\\%s.points", worldName);
    }

    public Collection<net.techbrew.journeymap.model.Waypoint> loadWaypoints(File waypointDir, boolean deleteOnSuccess) {
        ArrayList<net.techbrew.journeymap.model.Waypoint> waypoints = new ArrayList<net.techbrew.journeymap.model.Waypoint>();
        File[] files = waypointDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.contains(".DIM") && name.endsWith(".points");
            }
        });
        if (files == null || files.length == 0) {
            return waypoints;
        }
        for (File pointsFile : files) {
            try {
                int pointErrorCount = this.pointErrors;
                this.loadWaypoints(pointsFile, waypoints);
                if (!deleteOnSuccess || pointErrorCount != this.pointErrors) continue;
                pointsFile.deleteOnExit();
                pointsFile.delete();
            }
            catch (Exception e) {
                ChatLog.announceError(Constants.getString("jm.waypoint.import_vox_file_error", pointsFile.getName()));
                JourneyMap.getLogger().error(LogFormatter.toString(e));
                ++this.fileErrors;
            }
        }
        if (waypoints.isEmpty()) {
            ChatLog.announceI18N("jm.waypoint.import_vox_failure", new Object[0]);
        } else if (this.fileErrors == 0 && this.pointErrors == 0) {
            ChatLog.announceI18N("jm.waypoint.import_vox_success", waypoints.size());
        } else {
            ChatLog.announceI18N("jm.waypoint.import_vox_errors", waypoints.size(), this.pointErrors);
        }
        return waypoints;
    }

    private void loadWaypoints(File pointsFile, ArrayList<net.techbrew.journeymap.model.Waypoint> waypoints) throws Exception {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(pointsFile));
        while ((line = br.readLine()) != null) {
            net.techbrew.journeymap.model.Waypoint waypoint = this.loadWaypoint(line);
            if (waypoint == null) continue;
            waypoints.add(waypoint);
        }
        br.close();
    }

    private net.techbrew.journeymap.model.Waypoint loadWaypoint(String line) {
        if (!line.startsWith("name")) {
            return null;
        }
        try {
            String[] pairs;
            HashMap<String, String> map = new HashMap<String, String>(16);
            for (String pair : pairs = line.split("\\,")) {
                String[] kv = pair.split("\\:");
                if (kv.length != 2) continue;
                map.put(kv[0], kv[1]);
            }
            String name = ((String)map.get("name")).replaceAll("~comma~", ",");
            int x = Integer.parseInt((String)map.get("x"));
            int y = Integer.parseInt((String)map.get("y"));
            int z = Integer.parseInt((String)map.get("z"));
            boolean enable = Boolean.parseBoolean((String)map.get("enabled"));
            Color color = new Color(Float.parseFloat((String)map.get("red")), Float.parseFloat((String)map.get("green")), Float.parseFloat((String)map.get("blue")));
            Waypoint.Type type = "skull".equals(map.get("suffix")) ? Waypoint.Type.Death : Waypoint.Type.Normal;
            String[] dimStrings = ((String)map.get("dimensions")).split("\\#");
            ArrayList<Integer> dims = new ArrayList<Integer>(dimStrings.length);
            for (int i = 0; i < dimStrings.length; ++i) {
                dims.add(Integer.parseInt(dimStrings[0]));
            }
            net.techbrew.journeymap.model.Waypoint waypoint = new net.techbrew.journeymap.model.Waypoint(name, x, y, z, enable, color.getRed(), color.getGreen(), color.getBlue(), type, Waypoint.Origin.VoxelMap, 0, dims);
            waypoint.setDirty(true);
            return waypoint;
        }
        catch (Exception e) {
            JourneyMap.getLogger().warn("Couldn't parse \"" + line + "\" because: " + e.getMessage());
            ++this.pointErrors;
            return null;
        }
    }
}

