/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.fullscreen.layer;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.chunk.Chunk;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.model.BlockCoordIntPair;
import net.techbrew.journeymap.properties.FullMapProperties;
import net.techbrew.journeymap.render.draw.DrawStep;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.map.GridRenderer;
import net.techbrew.journeymap.ui.fullscreen.layer.LayerDelegate;
import net.techbrew.journeymap.ui.option.LocationFormat;

public class BlockInfoLayer
implements LayerDelegate.Layer {
    private final List<DrawStep> drawStepList = new ArrayList<DrawStep>(1);
    LocationFormat locationFormat = new LocationFormat();
    LocationFormat.LocationFormatKeys locationFormatKeys;
    BlockCoordIntPair lastCoord = null;
    long lastClicked = 0L;
    int lastMouseX;
    int lastMouseY;
    BlockInfoStep blockInfoStep = new BlockInfoStep();

    public BlockInfoLayer() {
        this.drawStepList.add(this.blockInfoStep);
    }

    @Override
    public List<DrawStep> onMouseMove(Minecraft mc, double mouseX, double mouseY, int gridWidth, int gridHeight, BlockCoordIntPair blockCoord) {
        if (!blockCoord.equals(this.lastCoord)) {
            String info;
            FullMapProperties fullMapProperties = JourneyMap.getFullMapProperties();
            this.locationFormatKeys = this.locationFormat.getFormatKeys((String)fullMapProperties.locationFormat.get());
            this.lastCoord = blockCoord;
            Chunk chunk = mc.field_71441_e.func_72964_e(blockCoord.x >> 4, blockCoord.z >> 4);
            Integer blockY = null;
            if (!chunk.func_76621_g()) {
                blockY = Math.max(chunk.func_76611_b(blockCoord.x & 0xF, blockCoord.z & 0xF), chunk.func_76626_d(blockCoord.x & 0xF, blockCoord.z & 0xF));
                String biome = mc.field_71441_e.func_72807_a((int)blockCoord.x, (int)blockCoord.z).field_76791_y;
                info = this.locationFormatKeys.format(fullMapProperties.locationFormatVerbose.get(), blockCoord.x, blockCoord.z, blockY, blockY >> 4) + " " + biome;
            } else {
                info = Constants.getString("jm.common.location_xz_verbose", blockCoord.x, blockCoord.z);
            }
            double infoHeight = (double)DrawUtil.getLabelHeight(mc.field_71466_p, true) * this.getMapFontScale();
            this.blockInfoStep.update(info, gridWidth / 2, (double)gridHeight - infoHeight);
        } else {
            this.blockInfoStep.update(this.blockInfoStep.text, gridWidth / 2, this.blockInfoStep.y);
        }
        return this.drawStepList;
    }

    private double getMapFontScale() {
        return JourneyMap.getFullMapProperties().fontScale.get();
    }

    @Override
    public List<DrawStep> onMouseClick(Minecraft mc, double mouseX, double mouseY, int gridWidth, int gridHeight, BlockCoordIntPair blockCoord) {
        return Collections.EMPTY_LIST;
    }

    class BlockInfoStep
    implements DrawStep {
        Color bgColor = Color.darkGray;
        Color fgColor = Color.white;
        double fontScale = 1.0;
        boolean fontShadow = false;
        int alpha = 255;
        int ticks = 100;
        private double x;
        private double y;
        private String text;

        BlockInfoStep() {
        }

        void update(String text, double x, double y) {
            this.text = text;
            this.x = x;
            this.y = y;
            this.alpha = 255;
            this.ticks = 100;
        }

        @Override
        public void draw(double xOffset, double yOffset, GridRenderer gridRenderer, float drawScale, double fontScale, double rotation) {
            if (this.ticks-- < 0 && this.alpha > 0) {
                --this.alpha;
            }
            if (this.alpha > 10 && this.text != null) {
                DrawUtil.drawLabel(this.text, this.x, this.y, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, this.bgColor, Math.max(0, this.alpha), this.fgColor, Math.max(0, this.alpha), BlockInfoLayer.this.getMapFontScale(), this.fontShadow);
            }
        }
    }
}

