/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.dialog;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.forge.event.KeyEventHandler;
import net.techbrew.journeymap.io.ThemeFileHandler;
import net.techbrew.journeymap.log.JMLogger;
import net.techbrew.journeymap.properties.CoreProperties;
import net.techbrew.journeymap.properties.config.Config;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.map.TileDrawStepCache;
import net.techbrew.journeymap.server.JMServer;
import net.techbrew.journeymap.task.main.SoftResetTask;
import net.techbrew.journeymap.task.multi.MapPlayerTask;
import net.techbrew.journeymap.task.multi.RenderSpec;
import net.techbrew.journeymap.ui.UIManager;
import net.techbrew.journeymap.ui.component.Button;
import net.techbrew.journeymap.ui.component.ButtonList;
import net.techbrew.journeymap.ui.component.CheckBox;
import net.techbrew.journeymap.ui.component.IPropertyHolder;
import net.techbrew.journeymap.ui.component.IntSliderButton;
import net.techbrew.journeymap.ui.component.JmUI;
import net.techbrew.journeymap.ui.component.ScrollListPane;
import net.techbrew.journeymap.ui.fullscreen.Fullscreen;
import net.techbrew.journeymap.ui.minimap.MiniMap;
import net.techbrew.journeymap.ui.option.CategorySlot;
import net.techbrew.journeymap.ui.option.OptionSlotFactory;
import net.techbrew.journeymap.ui.option.SlotMetadata;
import net.techbrew.journeymap.waypoint.WaypointStore;
import org.lwjgl.input.Mouse;

public class OptionsManager
extends JmUI {
    protected static EnumSet<Config.Category> openCategories = EnumSet.noneOf(Config.Category.class);
    protected final int inGameMinimapId;
    protected Config.Category[] initialCategories;
    protected CheckBox minimap1PreviewButton;
    protected CheckBox minimap2PreviewButton;
    protected Button minimap1KeysButton;
    protected Button minimap2KeysButton;
    protected Button fullscreenKeysButton;
    protected Button buttonClose;
    protected Button buttonAbout;
    protected Button renderStatsButton;
    protected Button editGridMinimap1Button;
    protected Button editGridMinimap2Button;
    protected Button editGridFullscreenButton;
    protected SlotMetadata renderStatsSlotMetadata;
    protected CategorySlot cartographyCategorySlot;
    protected ScrollListPane<CategorySlot> optionsListPane;
    protected Map<Config.Category, List<SlotMetadata>> toolbars;
    protected EnumSet<Config.Category> changedCategories = EnumSet.noneOf(Config.Category.class);
    protected boolean forceMinimapUpdate;
    protected ButtonList editGridButtons = new ButtonList();

    public OptionsManager() {
        this((JmUI)null);
    }

    public OptionsManager(JmUI returnDisplay) {
        this(returnDisplay, openCategories.toArray(new Config.Category[0]));
    }

    public OptionsManager(JmUI returnDisplay, Config.Category ... initialCategories) {
        super(String.format("JourneyMap %s %s", JourneyMap.JM_VERSION, Constants.getString("jm.common.options")), returnDisplay);
        this.initialCategories = initialCategories;
        this.inGameMinimapId = JourneyMap.getActiveMinimapId();
    }

    @Override
    public void func_73866_w_() {
        try {
            String tooltip;
            String name;
            this.field_146292_n.clear();
            if (this.editGridMinimap1Button == null) {
                name = Constants.getString("jm.common.grid_edit");
                tooltip = Constants.getString("jm.common.grid_edit.tooltip");
                this.editGridMinimap1Button = new Button(name);
                this.editGridMinimap1Button.setTooltip(tooltip);
                this.editGridMinimap1Button.setDrawBackground(false);
                this.editGridMinimap2Button = new Button(name);
                this.editGridMinimap2Button.setTooltip(tooltip);
                this.editGridMinimap2Button.setDrawBackground(false);
                this.editGridFullscreenButton = new Button(name);
                this.editGridFullscreenButton.setTooltip(tooltip);
                this.editGridFullscreenButton.setDrawBackground(false);
                this.editGridButtons = new ButtonList(this.editGridMinimap1Button, this.editGridMinimap2Button, this.editGridFullscreenButton);
            }
            if (this.minimap1PreviewButton == null) {
                name = String.format("%s %s", Constants.getString("jm.minimap.preview"), "1");
                tooltip = Constants.getString("jm.minimap.preview.tooltip");
                this.minimap1PreviewButton = new CheckBox(name, false);
                this.minimap1PreviewButton.setTooltip(tooltip);
            }
            if (this.minimap2PreviewButton == null) {
                name = String.format("%s %s", Constants.getString("jm.minimap.preview"), "2");
                tooltip = Constants.getString("jm.minimap.preview.tooltip");
                this.minimap2PreviewButton = new CheckBox(name, false);
                this.minimap2PreviewButton.setTooltip(tooltip);
            }
            if (this.minimap1KeysButton == null) {
                name = Constants.getString("jm.common.hotkeys");
                tooltip = Constants.getString("jm.common.hotkeys.tooltip");
                this.minimap1KeysButton = new Button(name);
                this.minimap1KeysButton.setTooltip(tooltip);
                this.minimap1KeysButton.setDrawBackground(false);
            }
            if (this.minimap2KeysButton == null) {
                name = Constants.getString("jm.common.hotkeys");
                tooltip = Constants.getString("jm.common.hotkeys.tooltip");
                this.minimap2KeysButton = new Button(name);
                this.minimap2KeysButton.setTooltip(tooltip);
                this.minimap2KeysButton.setDrawBackground(false);
            }
            if (this.fullscreenKeysButton == null) {
                name = Constants.getString("jm.common.hotkeys");
                tooltip = Constants.getString("jm.common.hotkeys.tooltip");
                this.fullscreenKeysButton = new Button(name);
                this.fullscreenKeysButton.setTooltip(tooltip);
                this.fullscreenKeysButton.setDrawBackground(false);
            }
            if (this.renderStatsButton == null) {
                this.renderStatsButton = new LabelButton(150, "jm.common.renderstats", 0, 0, 0);
                this.renderStatsButton.setEnabled(false);
            }
            if (this.optionsListPane == null) {
                ArrayList<CategorySlot> categorySlots = new ArrayList<CategorySlot>();
                ((Object)((Object)this)).getClass();
                this.optionsListPane = new ScrollListPane(this, this.field_146297_k, this.field_146294_l, this.field_146295_m, 35, this.field_146295_m - 30, 20);
                this.optionsListPane.setAlignTop(true);
                this.optionsListPane.setSlots(OptionSlotFactory.getSlots(this.getToolbars()));
                if (this.initialCategories != null) {
                    for (Config.Category initialCategory : this.initialCategories) {
                        for (CategorySlot categorySlot : this.optionsListPane.getRootSlots()) {
                            if (categorySlot.getCategory() != initialCategory) continue;
                            categorySlot.setSelected(true);
                            categorySlots.add(categorySlot);
                        }
                    }
                }
                block10: for (ScrollListPane.ISlot iSlot : this.optionsListPane.getRootSlots()) {
                    if (!(iSlot instanceof CategorySlot)) continue;
                    CategorySlot categorySlot = (CategorySlot)iSlot;
                    Config.Category category = categorySlot.getCategory();
                    ResetButton resetButton = new ResetButton(category);
                    SlotMetadata resetSlotMetadata = new SlotMetadata((Button)resetButton, 1);
                    switch (category) {
                        case MiniMap1: {
                            categorySlot.getAllChildMetadata().add(new SlotMetadata((Button)this.minimap1PreviewButton, 4));
                            categorySlot.getAllChildMetadata().add(new SlotMetadata(this.editGridMinimap1Button, 3));
                            categorySlot.getAllChildMetadata().add(new SlotMetadata(this.minimap1KeysButton, 2));
                            categorySlot.getAllChildMetadata().add(resetSlotMetadata);
                            continue block10;
                        }
                        case MiniMap2: {
                            categorySlot.getAllChildMetadata().add(new SlotMetadata((Button)this.minimap2PreviewButton, 4));
                            categorySlot.getAllChildMetadata().add(new SlotMetadata(this.editGridMinimap2Button, 3));
                            categorySlot.getAllChildMetadata().add(new SlotMetadata(this.minimap2KeysButton, 2));
                            categorySlot.getAllChildMetadata().add(resetSlotMetadata);
                            continue block10;
                        }
                        case FullMap: {
                            categorySlot.getAllChildMetadata().add(new SlotMetadata(this.editGridMinimap2Button, 3));
                            categorySlot.getAllChildMetadata().add(new SlotMetadata(this.fullscreenKeysButton, 2));
                            categorySlot.getAllChildMetadata().add(resetSlotMetadata);
                            continue block10;
                        }
                        case Cartography: {
                            this.cartographyCategorySlot = categorySlot;
                            this.renderStatsSlotMetadata = new SlotMetadata(this.renderStatsButton, Constants.getString("jm.common.renderstats.title"), Constants.getString("jm.common.renderstats.tooltip"), 2);
                            categorySlot.getAllChildMetadata().add(this.renderStatsSlotMetadata);
                            categorySlot.getAllChildMetadata().add(resetSlotMetadata);
                            continue block10;
                        }
                    }
                    categorySlot.getAllChildMetadata().add(resetSlotMetadata);
                }
                this.optionsListPane.updateSlots();
                if (!categorySlots.isEmpty()) {
                    this.optionsListPane.scrollTo((ScrollListPane.ISlot)categorySlots.get(0));
                }
            } else {
                this.optionsListPane.func_148122_a(this.field_146294_l, this.field_146295_m, 35, this.field_146295_m - 30);
                this.optionsListPane.updateSlots();
            }
            this.buttonClose = new Button(Constants.getString("jm.common.close"));
            this.buttonAbout = new Button(Constants.getString("jm.common.splash_about"));
            ButtonList bottomRow = new ButtonList(this.buttonAbout, this.buttonClose);
            bottomRow.equalizeWidths(this.getFontRenderer());
            bottomRow.setWidths(Math.max(150, this.buttonAbout.getWidth()));
            bottomRow.layoutCenteredHorizontal(this.field_146294_l / 2, this.field_146295_m - 25, true, 4);
            this.field_146292_n.addAll(bottomRow);
        }
        catch (Throwable t) {
            JMLogger.logOnce("Error in OptionsManager.initGui(): " + t, t);
        }
    }

    @Override
    protected void layoutButtons() {
        if (this.field_146292_n.isEmpty()) {
            this.func_73866_w_();
        }
    }

    @Override
    public void func_73863_a(int x, int y, float par3) {
        try {
            if (this.forceMinimapUpdate) {
                if (this.minimap1PreviewButton.isActive()) {
                    UIManager.getInstance().switchMiniMapPreset(1);
                } else if (this.minimap2PreviewButton.isActive()) {
                    UIManager.getInstance().switchMiniMapPreset(2);
                }
            }
            this.updateRenderStats();
            Object[] lastTooltip = this.optionsListPane.lastTooltip;
            long lastTooltipTime = this.optionsListPane.lastTooltipTime;
            this.optionsListPane.lastTooltip = null;
            if (!Mouse.isButtonDown((int)0) || !this.optionsListPane.func_148125_i()) {
                while (!this.field_146297_k.field_71474_y.field_85185_A && Mouse.next()) {
                    int j1 = Mouse.getEventDWheel();
                    if (j1 != 0) {
                        j1 = j1 > 0 ? -2 : 2;
                        this.optionsListPane.func_148145_f(j1 * this.optionsListPane.field_148149_f);
                    }
                    this.field_146297_k.field_71462_r.func_146274_d();
                }
            }
            this.optionsListPane.func_148128_a(x, y, par3);
            super.func_73863_a(x, y, par3);
            if (this.previewMiniMap()) {
                UIManager.getInstance().getMiniMap().drawMap(true);
                RenderHelper.func_74518_a();
            }
            if (this.optionsListPane.lastTooltip != null && Arrays.equals(this.optionsListPane.lastTooltip, lastTooltip)) {
                this.optionsListPane.lastTooltipTime = lastTooltipTime;
                if (System.currentTimeMillis() - this.optionsListPane.lastTooltipTime > this.optionsListPane.hoverDelay) {
                    Button button = this.optionsListPane.lastTooltipMetadata.getButton();
                    this.drawHoveringText(this.optionsListPane.lastTooltip, x, button.getBottomY() + 15);
                }
            }
        }
        catch (Throwable t) {
            JMLogger.logOnce("Error in OptionsManager.drawScreen(): " + t, t);
        }
    }

    private void updateRenderStats() {
        RenderSpec.getSurfaceSpec();
        RenderSpec.getUndergroundSpec();
        for (ScrollListPane.ISlot iSlot : this.optionsListPane.getRootSlots()) {
            CategorySlot categorySlot;
            if (!(iSlot instanceof CategorySlot) || (categorySlot = (CategorySlot)iSlot).getCategory() != Config.Category.Cartography) continue;
            CoreProperties coreProperties = JourneyMap.getCoreProperties();
            for (SlotMetadata slotMetadata : categorySlot.getAllChildMetadata()) {
                if (!(slotMetadata.getButton() instanceof IPropertyHolder)) continue;
                Object property = ((IPropertyHolder)((Object)slotMetadata.getButton())).getProperty();
                boolean limitButtonRange = false;
                if (property == coreProperties.renderDistanceCaveMax) {
                    boolean valid = JourneyMap.getCoreProperties().hasValidCaveRenderDistances();
                    limitButtonRange = true;
                    if (valid) {
                        slotMetadata.getButton().resetLabelColors();
                    } else {
                        slotMetadata.getButton().setLabelColors(Color.red, Color.red, null);
                    }
                } else if (property == coreProperties.renderDistanceSurfaceMax) {
                    boolean valid = JourneyMap.getCoreProperties().hasValidSurfaceRenderDistances();
                    limitButtonRange = true;
                    if (valid) {
                        slotMetadata.getButton().resetLabelColors();
                    } else {
                        slotMetadata.getButton().setLabelColors(Color.red, Color.red, null);
                    }
                } else if (property == coreProperties.renderDistanceCaveMin) {
                    limitButtonRange = true;
                } else if (property == coreProperties.renderDistanceSurfaceMin) {
                    limitButtonRange = true;
                }
                if (!limitButtonRange) continue;
                IntSliderButton button = (IntSliderButton)slotMetadata.getButton();
                button.maxValue = this.field_146297_k.field_71474_y.field_151451_c;
                if (button.getValue() <= this.field_146297_k.field_71474_y.field_151451_c) continue;
                button.setValue(this.field_146297_k.field_71474_y.field_151451_c);
            }
        }
        this.renderStatsButton.field_146126_j = JourneyMap.getCoreProperties().mappingEnabled.get() ? MapPlayerTask.getSimpleStats() : Constants.getString("jm.common.enable_mapping_false_text");
        this.renderStatsButton.setWidth(this.cartographyCategorySlot.getCurrentColumnWidth());
    }

    @Override
    public void func_146278_c(int layer) {
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseEvent) {
        super.func_73864_a(mouseX, mouseY, mouseEvent);
        boolean pressed = this.optionsListPane.mousePressed(mouseX, mouseY, mouseEvent);
        if (pressed) {
            this.checkPressedButton();
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int mouseEvent) {
        super.func_146286_b(mouseX, mouseY, mouseEvent);
        this.optionsListPane.mouseReleased(mouseX, mouseY, mouseEvent);
    }

    protected void func_146273_a(int mouseX, int mouseY, int lastButtonClicked, long timeSinceMouseClick) {
        super.func_146273_a(mouseX, mouseY, lastButtonClicked, timeSinceMouseClick);
        this.checkPressedButton();
    }

    protected void checkPressedButton() {
        CategorySlot categorySlot;
        SlotMetadata slotMetadata = this.optionsListPane.getLastPressed();
        if (slotMetadata != null) {
            if (slotMetadata.getButton() instanceof ResetButton) {
                this.resetOptions(((ResetButton)slotMetadata.getButton()).category);
            }
            if (slotMetadata.getName().equals(Constants.getString("jm.common.ui_theme"))) {
                ThemeFileHandler.getCurrentTheme(true);
                if (this.previewMiniMap()) {
                    UIManager.getInstance().getMiniMap().updateDisplayVars(true);
                }
            }
            if (this.editGridButtons.contains(slotMetadata.getButton())) {
                UIManager.getInstance().openGridEditor(this);
                return;
            }
            if (slotMetadata.getButton() == this.minimap1PreviewButton) {
                this.minimap2PreviewButton.setToggled(false);
                UIManager.getInstance().switchMiniMapPreset(1);
                UIManager.getInstance().getMiniMap().resetInitTime();
            }
            if (slotMetadata.getButton() == this.minimap2PreviewButton) {
                this.minimap1PreviewButton.setToggled(false);
                UIManager.getInstance().switchMiniMapPreset(2);
                UIManager.getInstance().getMiniMap().resetInitTime();
            }
            if (slotMetadata.getButton() == this.minimap1KeysButton || slotMetadata.getButton() == this.minimap2KeysButton) {
                this.optionsListPane.resetLastPressed();
                UIManager.getInstance().openMiniMapHotkeyHelp(this);
                return;
            }
            if (slotMetadata.getButton() == this.fullscreenKeysButton) {
                this.optionsListPane.resetLastPressed();
                UIManager.getInstance().openMapHotkeyHelp(this);
                return;
            }
        }
        if ((categorySlot = (CategorySlot)this.optionsListPane.getLastPressedParentSlot()) != null) {
            Config.Category category = categorySlot.getCategory();
            this.changedCategories.add(category);
            if (category == Config.Category.MiniMap1 || category == Config.Category.MiniMap2) {
                this.refreshMinimapOptions();
                DataCache.instance().resetRadarCaches();
                UIManager.getInstance().getMiniMap().updateDisplayVars(true);
            }
            if (category == Config.Category.Cartography) {
                JourneyMap.getCoreProperties().save();
                RenderSpec.resetRenderSpecs();
            }
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button == this.buttonClose) {
            this.closeAndReturn();
            return;
        }
        if (button == this.buttonAbout) {
            UIManager.getInstance().openSplash(this);
            return;
        }
        if (button == this.minimap1PreviewButton) {
            this.minimap2PreviewButton.setToggled(false);
            UIManager.getInstance().switchMiniMapPreset(1);
        }
        if (button == this.minimap2PreviewButton) {
            this.minimap1PreviewButton.setToggled(false);
            UIManager.getInstance().switchMiniMapPreset(2);
        }
    }

    @Override
    protected void func_73869_a(char c, int i) {
        boolean pressed;
        switch (i) {
            case 1: {
                if (this.previewMiniMap()) {
                    this.minimap1PreviewButton.setToggled(false);
                    this.minimap2PreviewButton.setToggled(false);
                    break;
                }
                this.closeAndReturn();
            }
        }
        boolean optionUpdated = this.optionsListPane.keyTyped(c, i);
        if (optionUpdated && this.previewMiniMap()) {
            UIManager.getInstance().getMiniMap().updateDisplayVars(true);
        }
        if (this.previewMiniMap() && (pressed = KeyEventHandler.onKeypress(true))) {
            this.refreshMinimapOptions();
        }
    }

    protected void resetOptions(Config.Category category) {
        for (CategorySlot categorySlot : this.optionsListPane.getRootSlots()) {
            if (!category.equals((Object)categorySlot.getCategory())) continue;
            for (SlotMetadata slotMetadata : categorySlot.getAllChildMetadata()) {
                slotMetadata.resetToDefaultValue();
                slotMetadata.getButton().refresh();
            }
        }
        RenderSpec.resetRenderSpecs();
    }

    protected boolean previewMiniMap() {
        return this.minimap1PreviewButton.getToggled() != false || this.minimap2PreviewButton.getToggled() != false;
    }

    protected void refreshMinimapOptions() {
        EnumSet<Config.Category> cats = EnumSet.of(Config.Category.MiniMap1, Config.Category.MiniMap2);
        for (CategorySlot categorySlot : this.optionsListPane.getRootSlots()) {
            if (!cats.contains((Object)categorySlot.getCategory())) continue;
            for (SlotMetadata slotMetadata : categorySlot.getAllChildMetadata()) {
                slotMetadata.getButton().refresh();
            }
        }
    }

    @Override
    protected void closeAndReturn() {
        JourneyMap.getCoreProperties().optionsManagerViewed.set(JourneyMap.JM_VERSION.toString());
        JourneyMap.getCoreProperties().ensureValid();
        JourneyMap.getWebMapProperties().ensureValid();
        JourneyMap.getFullMapProperties().ensureValid();
        JourneyMap.getMiniMapProperties1().ensureValid();
        JourneyMap.getMiniMapProperties2().ensureValid();
        JourneyMap.getWaypointProperties().ensureValid();
        UIManager.getInstance().getMiniMap().setMiniMapProperties(JourneyMap.getMiniMapProperties(this.inGameMinimapId));
        for (Config.Category category : this.changedCategories) {
            switch (category) {
                case MiniMap1: {
                    DataCache.instance().resetRadarCaches();
                    UIManager.getInstance().getMiniMap().reset();
                    break;
                }
                case MiniMap2: {
                    DataCache.instance().resetRadarCaches();
                    break;
                }
                case FullMap: {
                    DataCache.instance().resetRadarCaches();
                    ThemeFileHandler.getCurrentTheme(true);
                    break;
                }
                case WebMap: {
                    DataCache.instance().resetRadarCaches();
                    JMServer.setEnabled(JourneyMap.getWebMapProperties().enabled.get(), true);
                    break;
                }
                case Waypoint: {
                    WaypointStore.instance().reset();
                }
                case WaypointBeacon: {
                    break;
                }
                case Cartography: {
                    RenderSpec.resetRenderSpecs();
                    TileDrawStepCache.instance().invalidateAll();
                    MiniMap.state().requireRefresh();
                    Fullscreen.state().requireRefresh();
                    MapPlayerTask.forceNearbyRemap();
                    break;
                }
                case Advanced: {
                    SoftResetTask.queue();
                    JMServer.setEnabled(JourneyMap.getWebMapProperties().enabled.get(), false);
                }
            }
        }
        UIManager.getInstance().getMiniMap().reset();
        if (this.returnDisplay instanceof Fullscreen) {
            ((Fullscreen)this.returnDisplay).reset();
        }
        openCategories.clear();
        for (CategorySlot categorySlot : this.optionsListPane.getRootSlots()) {
            if (!categorySlot.isSelected()) continue;
            openCategories.add(categorySlot.getCategory());
        }
        UIManager.getInstance().getMiniMap().updateDisplayVars(true);
        if (this.returnDisplay == null) {
            UIManager.getInstance().openFullscreenMap();
        } else {
            UIManager.getInstance().open(this.returnDisplay);
        }
    }

    Map<Config.Category, List<SlotMetadata>> getToolbars() {
        if (this.toolbars == null) {
            this.toolbars = new HashMap<Config.Category, List<SlotMetadata>>();
            for (Config.Category category : Config.Category.values()) {
            }
        }
        return this.toolbars;
    }

    public static class LabelButton
    extends Button {
        DrawUtil.HAlign hAlign = DrawUtil.HAlign.Left;

        public LabelButton(int width, String key, Object ... labelArgs) {
            super(Constants.getString(key, labelArgs));
            this.setTooltip(Constants.getString(key + ".tooltip"));
            this.setDrawBackground(false);
            this.setDrawFrame(false);
            this.setEnabled(false);
            this.setLabelColors(Color.lightGray, Color.lightGray, Color.lightGray);
            this.field_146120_f = width;
        }

        @Override
        public int getFitWidth(FontRenderer fr) {
            return this.field_146120_f;
        }

        @Override
        public void fitWidth(FontRenderer fr) {
        }

        public void setHAlign(DrawUtil.HAlign hAlign) {
            this.hAlign = hAlign;
        }

        @Override
        public void func_146112_a(Minecraft minecraft, int mouseX, int mouseY) {
            int labelX;
            switch (this.hAlign) {
                case Left: {
                    labelX = this.getRightX();
                    break;
                }
                case Right: {
                    labelX = this.getX();
                    break;
                }
                default: {
                    labelX = this.getCenterX();
                }
            }
            DrawUtil.drawLabel(this.field_146126_j, labelX, this.getMiddleY(), this.hAlign, DrawUtil.VAlign.Middle, null, 0, this.labelColor, 255, 1.0, this.drawLabelShadow);
        }
    }

    public static class ResetButton
    extends Button {
        public final Config.Category category;

        public ResetButton(Config.Category category) {
            super(Constants.getString("jm.config.reset"));
            this.category = category;
            this.setTooltip(Constants.getString("jm.config.reset.tooltip"));
            this.setDrawBackground(false);
            this.setLabelColors(Color.red, Color.red, null);
        }
    }
}

