/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.renderer.Tessellator;
import net.techbrew.journeymap.ui.component.JmUI;
import net.techbrew.journeymap.ui.option.SlotMetadata;

public class ScrollListPane<T extends ISlot>
extends GuiSlot {
    final JmUI parent;
    public SlotMetadata lastTooltipMetadata;
    public String[] lastTooltip;
    public long lastTooltipTime;
    public long hoverDelay = 800L;
    int hpad = 12;
    List<T> rootSlots;
    List<ISlot> currentSlots = new ArrayList<ISlot>(0);
    SlotMetadata lastPressed;
    int lastClickedIndex;
    int scrollbarX;
    int listWidth;
    boolean alignTop;

    public ScrollListPane(JmUI parent, Minecraft mc, int width, int height, int top, int bottom, int slotHeight) {
        super(mc, width, height, top, bottom, slotHeight);
        this.parent = parent;
        this.func_148122_a(width, height, top, bottom);
    }

    public void func_148122_a(int width, int height, int top, int bottom) {
        super.func_148122_a(width, height, top, bottom);
        this.scrollbarX = this.field_148155_a - this.hpad;
        this.listWidth = this.field_148155_a - this.hpad * 4;
    }

    protected int func_148127_b() {
        return this.currentSlots == null ? 0 : this.currentSlots.size();
    }

    public void setSlots(List<T> slots) {
        this.rootSlots = slots;
        this.updateSlots();
    }

    public List<T> getRootSlots() {
        return this.rootSlots;
    }

    public void updateSlots() {
        int sizeBefore = this.currentSlots.size();
        this.currentSlots.clear();
        int columnWidth = 0;
        for (ISlot slot : this.rootSlots) {
            columnWidth = Math.max(columnWidth, slot.getColumnWidth());
        }
        for (ISlot slot : this.rootSlots) {
            this.currentSlots.add(slot);
            List<? extends ISlot> children = slot.getChildSlots(this.listWidth, columnWidth);
            if (children == null || children.isEmpty()) continue;
            this.currentSlots.addAll(children);
        }
        int sizeAfter = this.currentSlots.size();
        if (sizeBefore < sizeAfter) {
            this.func_148145_f(-(sizeAfter * this.field_148149_f));
            this.func_148145_f(this.lastClickedIndex * this.field_148149_f);
        }
    }

    public void scrollTo(ISlot slot) {
        this.func_148145_f(-(this.currentSlots.size() * this.field_148149_f));
        this.func_148145_f(this.currentSlots.indexOf(slot) * this.field_148149_f);
    }

    protected void func_148144_a(int index, boolean doubleClick, int mouseX, int mouseY) {
    }

    public boolean func_148131_a(int p_148131_1_) {
        return false;
    }

    protected void func_148123_a() {
    }

    protected void func_148126_a(int slotIndex, int x, int y, int slotHeight, Tessellator tessellator, int mouseX, int mouseY) {
        SlotMetadata tooltipMetadata = this.getSlot(slotIndex).drawSlot(slotIndex, x, y, this.func_148139_c(), slotHeight, tessellator, mouseX, mouseY, this.func_148124_c(mouseX, mouseY) == slotIndex);
        if (tooltipMetadata != null && !Arrays.equals(tooltipMetadata.getTooltip(), this.lastTooltip)) {
            this.lastTooltipMetadata = tooltipMetadata;
            this.lastTooltip = tooltipMetadata.getTooltip();
            this.lastTooltipTime = System.currentTimeMillis();
        }
    }

    public int func_148139_c() {
        return this.listWidth;
    }

    public boolean mousePressed(int mouseX, int mouseY, int mouseEvent) {
        int slotIndex;
        if (this.func_148141_e(mouseY) && (slotIndex = this.func_148124_c(mouseX, mouseY)) >= 0) {
            int i1 = this.field_148152_e + this.hpad + this.field_148155_a / 2 - this.func_148139_c() / 2 + 2;
            int j1 = this.field_148153_b + 4 - this.func_148148_g() + slotIndex * this.field_148149_f + this.field_148160_j;
            int relativeX = mouseX - i1;
            int relativeY = mouseY - j1;
            this.lastClickedIndex = -1;
            if (this.getSlot(slotIndex).mousePressed(slotIndex, mouseX, mouseY, mouseEvent, relativeX, relativeY)) {
                this.func_148143_b(false);
                this.lastClickedIndex = slotIndex;
                this.lastPressed = this.getSlot(slotIndex).getLastPressed();
                this.updateSlots();
                return true;
            }
        }
        return false;
    }

    public boolean mouseReleased(int x, int y, int mouseEvent) {
        for (int slotIndex = 0; slotIndex < this.func_148127_b(); ++slotIndex) {
            int i1 = this.field_148152_e + this.hpad + this.field_148155_a / 2 - this.func_148139_c() / 2 + 2;
            int j1 = this.field_148153_b + 4 - this.func_148148_g() + slotIndex * this.field_148149_f + this.field_148160_j;
            int relativeX = x - i1;
            int relativeY = y - j1;
            this.getSlot(slotIndex).mouseReleased(slotIndex, x, y, mouseEvent, relativeX, relativeY);
        }
        this.func_148143_b(true);
        this.lastPressed = null;
        return false;
    }

    public ISlot getSlot(int index) {
        return this.currentSlots.get(index);
    }

    public SlotMetadata getLastPressed() {
        return this.lastPressed;
    }

    public void resetLastPressed() {
        this.lastPressed = null;
    }

    public ISlot getLastPressedParentSlot() {
        if (this.lastPressed != null) {
            for (ISlot slot : this.rootSlots) {
                if (!slot.contains(this.lastPressed)) continue;
                return slot;
            }
        }
        return null;
    }

    public boolean keyTyped(char c, int i) {
        for (int slotIndex = 0; slotIndex < this.func_148127_b(); ++slotIndex) {
            if (!this.getSlot(slotIndex).keyTyped(c, i)) continue;
            this.lastClickedIndex = slotIndex;
            this.lastPressed = this.getSlot(slotIndex).getLastPressed();
            this.updateSlots();
            return true;
        }
        return false;
    }

    protected int func_148137_d() {
        return this.scrollbarX;
    }

    protected void drawContainerBackground(Tessellator tessellator) {
        this.parent.func_73733_a(0, this.field_148153_b, this.field_148155_a, this.field_148153_b + this.field_148158_l, -1072689136, -804253680);
    }

    protected int func_148138_e() {
        int contentHeight = super.func_148138_e();
        if (this.alignTop) {
            contentHeight = Math.max(this.field_148154_c - this.field_148153_b - 4, contentHeight);
        }
        return contentHeight;
    }

    public void setAlignTop(boolean alignTop) {
        this.alignTop = alignTop;
    }

    public static interface ISlot {
        public Collection<SlotMetadata> getMetadata();

        public SlotMetadata drawSlot(int var1, int var2, int var3, int var4, int var5, Tessellator var6, int var7, int var8, boolean var9);

        public boolean mousePressed(int var1, int var2, int var3, int var4, int var5, int var6);

        public String[] mouseHover(int var1, int var2, int var3, int var4, int var5, int var6);

        public void mouseReleased(int var1, int var2, int var3, int var4, int var5, int var6);

        public boolean keyTyped(char var1, int var2);

        public List<? extends ISlot> getChildSlots(int var1, int var2);

        public SlotMetadata getLastPressed();

        public void setEnabled(boolean var1);

        public int getColumnWidth();

        public boolean contains(SlotMetadata var1);
    }
}

