/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui;

import cpw.mods.fml.client.FMLClientHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.WaypointsData;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.Waypoint;
import net.techbrew.journeymap.properties.config.Config;
import net.techbrew.journeymap.ui.component.JmUI;
import net.techbrew.journeymap.ui.dialog.FullscreenActions;
import net.techbrew.journeymap.ui.dialog.FullscreenHotkeysHelp;
import net.techbrew.journeymap.ui.dialog.GridEditor;
import net.techbrew.journeymap.ui.dialog.OptionsManager;
import net.techbrew.journeymap.ui.dialog.Splash;
import net.techbrew.journeymap.ui.fullscreen.Fullscreen;
import net.techbrew.journeymap.ui.minimap.MiniMap;
import net.techbrew.journeymap.ui.minimap.MiniMapHotkeysHelp;
import net.techbrew.journeymap.ui.waypoint.WaypointEditor;
import net.techbrew.journeymap.ui.waypoint.WaypointHelp;
import net.techbrew.journeymap.ui.waypoint.WaypointManager;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class UIManager {
    private final Logger logger = JourneyMap.getLogger();
    private final MiniMap miniMap;
    Minecraft minecraft = FMLClientHandler.instance().getClient();

    private UIManager() {
        int preset = JourneyMap.getMiniMapProperties1().isActive() ? 1 : 2;
        this.miniMap = new MiniMap(JourneyMap.getMiniMapProperties(preset));
    }

    public static UIManager getInstance() {
        return Holder.INSTANCE;
    }

    public void closeAll() {
        this.closeCurrent();
        this.minecraft.func_147108_a(null);
        this.minecraft.func_71381_h();
    }

    public void closeCurrent() {
        if (this.minecraft.field_71462_r != null && this.minecraft.field_71462_r instanceof JmUI) {
            this.logger.debug("Closing " + this.minecraft.field_71462_r.getClass());
            ((JmUI)this.minecraft.field_71462_r).close();
        }
        KeyBinding.func_74506_a();
    }

    public void openInventory() {
        this.logger.debug("Opening inventory");
        this.closeAll();
        this.minecraft.func_147108_a((GuiScreen)new GuiInventory((EntityPlayer)this.minecraft.field_71439_g));
    }

    public <T extends JmUI> T open(Class<T> uiClass, JmUI returnDisplay) {
        try {
            JmUI ui = (JmUI)((Object)uiClass.getConstructor(JmUI.class).newInstance(new Object[]{returnDisplay}));
            return (T)((Object)this.open(ui));
        }
        catch (Throwable e) {
            this.logger.log(Level.ERROR, "Unexpected exception creating UI with return class: " + LogFormatter.toString(e));
            this.closeCurrent();
            return null;
        }
    }

    public <T extends JmUI> T open(Class<T> uiClass) {
        try {
            JmUI ui = (JmUI)((Object)uiClass.newInstance());
            return (T)((Object)this.open(ui));
        }
        catch (Throwable e) {
            this.logger.log(Level.ERROR, "Unexpected exception creating UI: " + LogFormatter.toString(e));
            this.closeCurrent();
            return null;
        }
    }

    public <T extends JmUI> T open(T ui) {
        this.closeCurrent();
        this.logger.debug("Opening UI " + ((Object)ui).getClass().getSimpleName());
        try {
            this.minecraft.func_147108_a(ui);
        }
        catch (Throwable t) {
            this.logger.error(String.format("Unexpected exception opening UI %s: %s", ((Object)ui).getClass(), LogFormatter.toString(t)));
        }
        return ui;
    }

    public void toggleMinimap() {
        this.setMiniMapEnabled(!this.isMiniMapEnabled());
    }

    public boolean isMiniMapEnabled() {
        return this.miniMap.getCurrentMinimapProperties().enabled.get();
    }

    public void setMiniMapEnabled(boolean enable) {
        this.miniMap.getCurrentMinimapProperties().enabled.set(enable);
        this.miniMap.getCurrentMinimapProperties().save();
    }

    public void drawMiniMap() {
        try {
            if (this.miniMap.getCurrentMinimapProperties().enabled.get()) {
                boolean doDraw;
                GuiScreen currentScreen = this.minecraft.field_71462_r;
                boolean bl = doDraw = currentScreen == null || currentScreen instanceof GuiChat;
                if (doDraw) {
                    this.miniMap.drawMap();
                }
            }
        }
        catch (Throwable e) {
            JourneyMap.getLogger().error("Error drawing minimap: " + LogFormatter.toString(e));
        }
    }

    public MiniMap getMiniMap() {
        return this.miniMap;
    }

    public void openFullscreenMap() {
        KeyBinding.func_74506_a();
        this.open((JmUI)((Object)Fullscreen.class));
    }

    public void openFullscreenMap(Waypoint waypoint) {
        try {
            if (waypoint.isInPlayerDimension()) {
                KeyBinding.func_74506_a();
                Fullscreen map = (Fullscreen)((Object)this.open((JmUI)((Object)Fullscreen.class)));
                map.centerOn(waypoint);
            }
        }
        catch (Throwable e) {
            JourneyMap.getLogger().error("Error opening map on waypoint: " + LogFormatter.toString(e));
        }
    }

    public void openMapHotkeyHelp(JmUI returnDisplay) {
        this.open(FullscreenHotkeysHelp.class, returnDisplay);
    }

    public void openMiniMapHotkeyHelp(JmUI returnDisplay) {
        this.open(MiniMapHotkeysHelp.class, returnDisplay);
    }

    public void openOptionsManager() {
        this.open((JmUI)((Object)OptionsManager.class));
    }

    public void openOptionsManager(JmUI returnDisplay, Config.Category ... initialCategories) {
        try {
            this.open(new OptionsManager(returnDisplay, initialCategories));
        }
        catch (Throwable e) {
            this.logger.log(Level.ERROR, "Unexpected exception creating MasterOptions with return class: " + LogFormatter.toString(e));
        }
    }

    public void openMapActions() {
        this.open((JmUI)((Object)FullscreenActions.class));
    }

    public void openSplash(JmUI returnDisplay) {
        this.open(Splash.class, returnDisplay);
    }

    public void openWaypointHelp(JmUI returnDisplay) {
        this.open(WaypointHelp.class, returnDisplay);
    }

    public void openWaypointManager(Waypoint waypoint, JmUI returnDisplay) {
        if (WaypointsData.isManagerEnabled()) {
            try {
                WaypointManager manager = new WaypointManager(waypoint, returnDisplay);
                this.open(manager);
            }
            catch (Throwable e) {
                JourneyMap.getLogger().error("Error opening waypoint manager: " + LogFormatter.toString(e));
            }
        }
    }

    public void openWaypointEditor(Waypoint waypoint, boolean isNew, JmUI returnDisplay) {
        if (WaypointsData.isManagerEnabled()) {
            try {
                WaypointEditor editor = new WaypointEditor(waypoint, isNew, returnDisplay);
                this.open(editor);
            }
            catch (Throwable e) {
                JourneyMap.getLogger().error("Error opening waypoint editor: " + LogFormatter.toString(e));
            }
        }
    }

    public void openGridEditor(JmUI returnDisplay) {
        try {
            GridEditor editor = new GridEditor(returnDisplay);
            this.open(editor);
        }
        catch (Throwable e) {
            JourneyMap.getLogger().error("Error opening grid editor: " + LogFormatter.toString(e));
        }
    }

    public void reset() {
        Fullscreen.state().requireRefresh();
        this.miniMap.reset();
    }

    public void switchMiniMapPreset() {
        int currentPreset = this.miniMap.getCurrentMinimapProperties().getId();
        this.switchMiniMapPreset(currentPreset == 1 ? 2 : 1);
    }

    public void switchMiniMapPreset(int which) {
        this.miniMap.setMiniMapProperties(JourneyMap.getMiniMapProperties(which));
    }

    private static class Holder {
        private static final UIManager INSTANCE = new UIManager();

        private Holder() {
        }
    }
}

