/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.render.draw;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.EntityDTO;
import net.techbrew.journeymap.properties.InGameMapProperties;
import net.techbrew.journeymap.render.draw.DrawEntityStep;
import net.techbrew.journeymap.render.draw.DrawStep;
import net.techbrew.journeymap.render.map.GridRenderer;
import net.techbrew.journeymap.render.texture.TextureCache;
import net.techbrew.journeymap.render.texture.TextureImpl;

public class RadarDrawStepFactory {
    public List<DrawStep> prepareSteps(List<EntityDTO> entityDTOs, GridRenderer grid, float drawScale, InGameMapProperties mapProperties) {
        boolean showAnimals = mapProperties.showAnimals.get();
        boolean showPets = mapProperties.showPets.get();
        boolean showMobHeading = mapProperties.showMobHeading.get();
        boolean showPlayerHeading = mapProperties.showPlayerHeading.get();
        ArrayList<DrawStep> drawStepList = new ArrayList<DrawStep>();
        try {
            String playername = Minecraft.func_71410_x().field_71439_g.getDisplayName();
            TextureCache tc = TextureCache.instance();
            String iconSetName = mapProperties.getEntityIconSetName().get();
            for (EntityDTO dto : entityDTOs) {
                try {
                    DrawEntityStep drawStep;
                    TextureImpl entityIcon;
                    boolean isPet;
                    boolean bl = isPet = !Strings.isNullOrEmpty((String)dto.owner);
                    if (!showPets && isPet || !showAnimals && dto.passiveAnimal && (!isPet || !showPets) || grid.getPixel(dto.posX, dto.posZ) == null) continue;
                    boolean isPlayer = dto.entityLiving instanceof EntityPlayer;
                    TextureImpl locatorImg = dto.hostile != false ? tc.getHostileLocator() : (!Strings.isNullOrEmpty((String)dto.owner) && playername.equals(dto.owner) ? tc.getPetLocator() : (isPlayer ? tc.getOtherLocator() : tc.getNeutralLocator()));
                    if (isPlayer) {
                        entityIcon = tc.getPlayerSkin(dto.entityLiving.func_70005_c_());
                        drawStep = DataCache.instance().getDrawEntityStep(dto);
                        drawStep.update(false, locatorImg, entityIcon, showPlayerHeading);
                        drawStepList.add(drawStep);
                        continue;
                    }
                    entityIcon = tc.getEntityIconTexture(iconSetName, dto.filename);
                    if (entityIcon == null) continue;
                    drawStep = DataCache.instance().getDrawEntityStep(dto);
                    drawStep.update(false, locatorImg, entityIcon, showMobHeading);
                    drawStepList.add(drawStep);
                }
                catch (Exception e) {
                    JourneyMap.getLogger().error("Exception during prepareSteps: " + LogFormatter.toString(e));
                }
            }
        }
        catch (Throwable t) {
            JourneyMap.getLogger().error("Throwable during prepareSteps: " + LogFormatter.toString(t));
        }
        return drawStepList;
    }
}

