/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model.mod;

import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.model.BlockMD;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.model.mod.ModBlockDelegate;

public class CarpentersBlocks {

    public static class CommonHandler
    implements ModBlockDelegate.IModBlockHandler {
        private static final String MODPREFIX = "CarpentersBlocks:";
        private static final List<String> BLOCKNAMES = Arrays.asList("blockCarpentersBlock", "blockCarpentersBarrier", "blockCarpentersBed", "blockCarpentersCollapsibleBlock", "blockCarpentersDaylightSensor", "blockCarpentersDoor", "blockCarpentersFlowerPot", "blockCarpentersGarageDoor", "blockCarpentersGate", "blockCarpentersHatch", "blockCarpentersPressurePlate", "blockCarpentersSafe", "blockCarpentersSlope", "blockCarpentersStairs");
        private static final Collection<GameRegistry.UniqueIdentifier> UIDS = CommonHandler.initUIDs();
        private static final String TAG_ATTR_LIST = "cbAttrList";
        private static final String TAG_ID = "id";
        private static final String TAG_DAMAGE = "Damage";

        private static Collection<GameRegistry.UniqueIdentifier> initUIDs() {
            ArrayList<GameRegistry.UniqueIdentifier> list = new ArrayList<GameRegistry.UniqueIdentifier>(BLOCKNAMES.size());
            for (String name : BLOCKNAMES) {
                list.add(new GameRegistry.UniqueIdentifier(MODPREFIX + name));
            }
            return list;
        }

        @Override
        public Collection<GameRegistry.UniqueIdentifier> getBlockUids() {
            return UIDS;
        }

        @Override
        public BlockMD handleBlock(ChunkMD chunkMD, BlockMD blockMD, int localX, int y, int localZ) {
            int blockX = chunkMD.toBlockX(localX);
            int blockZ = chunkMD.toBlockZ(localZ);
            TileEntity tileEntity = chunkMD.getWorldObj().func_147438_o(blockX, y, blockZ);
            if (tileEntity != null) {
                NBTTagCompound tag = new NBTTagCompound();
                tileEntity.func_145841_b(tag);
                if (!tag.func_82582_d()) {
                    int meta = 0;
                    NBTTagList attrs = tag.func_150295_c(TAG_ATTR_LIST, 10);
                    String idString = attrs.func_150305_b(0).func_74779_i(TAG_ID);
                    if (idString.length() > 0) {
                        int id = Integer.parseInt(idString.substring(0, idString.length() - 1));
                        String idMeta = attrs.func_150305_b(0).func_74779_i(TAG_DAMAGE);
                        if (idMeta.length() > 0) {
                            meta = Integer.parseInt(idMeta.substring(0, idMeta.length() - 1));
                        }
                        Block block = (Block)GameData.getBlockRegistry().func_148754_a(id);
                        blockMD = DataCache.instance().getBlockMD(block, meta);
                    }
                }
            }
            return blockMD;
        }

        @Override
        public IIcon getIcon(BlockMD blockMD) {
            return blockMD.getBlock().func_149691_a(1, 16);
        }
    }
}

