/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import cpw.mods.fml.client.FMLClientHandler;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.io.FileHandler;
import net.techbrew.journeymap.io.RegionImageHandler;
import net.techbrew.journeymap.model.ImageHolder;
import net.techbrew.journeymap.model.MapState;
import net.techbrew.journeymap.model.MapType;
import net.techbrew.journeymap.model.RegionCoord;
import net.techbrew.journeymap.model.RegionImageSet;
import net.techbrew.journeymap.thread.JMThreadFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class RegionImageCache {
    public static final long flushInterval = TimeUnit.SECONDS.toMillis(30L);
    public static final long regionCacheAge = flushInterval / 2L;
    static final Logger logger = JourneyMap.getLogger();
    final LoadingCache<RegionImageSet.Key, RegionImageSet> regionImageSetsCache;
    private volatile long lastFlush;
    private Minecraft minecraft = FMLClientHandler.instance().getClient();

    private RegionImageCache() {
        this.regionImageSetsCache = DataCache.instance().getRegionImageSets();
        this.lastFlush = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(5L);
        Runtime.getRuntime().addShutdownHook(new JMThreadFactory("rcache").newThread(new Runnable(){

            @Override
            public void run() {
                RegionImageCache.this.flushToDisk();
                if (logger.isEnabled(Level.DEBUG)) {
                    logger.debug("RegionImageCache flushing to disk on shutdown");
                }
            }
        }));
    }

    public static RegionImageCache instance() {
        return Holder.INSTANCE;
    }

    public static LoadingCache<RegionImageSet.Key, RegionImageSet> initRegionImageSetsCache(CacheBuilder<Object, Object> builder) {
        return builder.expireAfterAccess(regionCacheAge, TimeUnit.SECONDS).removalListener((RemovalListener)new RemovalListener<RegionImageSet.Key, RegionImageSet>(){

            @ParametersAreNonnullByDefault
            public void onRemoval(RemovalNotification<RegionImageSet.Key, RegionImageSet> notification) {
                RegionImageSet regionImageSet = (RegionImageSet)notification.getValue();
                if (regionImageSet != null) {
                    regionImageSet.writeToDisk(false);
                    regionImageSet.clear();
                }
            }
        }).build((CacheLoader)new CacheLoader<RegionImageSet.Key, RegionImageSet>(){

            @ParametersAreNonnullByDefault
            public RegionImageSet load(RegionImageSet.Key key) throws Exception {
                return new RegionImageSet(key);
            }
        });
    }

    public RegionImageSet getRegionImageSet(RegionCoord rCoord) {
        return (RegionImageSet)this.regionImageSetsCache.getUnchecked((Object)RegionImageSet.Key.from(rCoord));
    }

    private Collection<RegionImageSet> getRegionImageSets() {
        return this.regionImageSetsCache.asMap().values();
    }

    public void updateTextures(boolean forceFlush) {
        for (RegionImageSet regionImageSet : this.getRegionImageSets()) {
            if (!regionImageSet.hasChunkUpdates()) continue;
            regionImageSet.finishChunkUpdates();
        }
        if (forceFlush) {
            this.flushToDisk();
        } else {
            this.autoFlush();
        }
    }

    private void autoFlush() {
        if (this.lastFlush + flushInterval < System.currentTimeMillis()) {
            if (logger.isEnabled(Level.DEBUG)) {
                logger.debug("RegionImageCache auto-flushing");
            }
            this.flushToDisk();
        }
    }

    public void flushToDisk() {
        for (RegionImageSet regionImageSet : this.getRegionImageSets()) {
            regionImageSet.writeToDisk(false);
        }
        this.lastFlush = System.currentTimeMillis();
    }

    public List<RegionCoord> getDirtySince(MapType mapType, long time) {
        if (time <= this.lastFlush) {
            if (logger.isEnabled(Level.DEBUG)) {
                logger.debug("Nothing dirty, last flush was " + (time - this.lastFlush) + "ms before " + time);
            }
            return Collections.EMPTY_LIST;
        }
        ArrayList<RegionCoord> list = new ArrayList<RegionCoord>();
        for (RegionImageSet regionImageSet : this.getRegionImageSets()) {
            ImageHolder imageHolder = (ImageHolder)regionImageSet.imageHolders.get(mapType);
            if (imageHolder == null || imageHolder.getImageTimestamp() <= time) continue;
            list.add(regionImageSet.getRegionCoord());
        }
        if (logger.isEnabled(Level.DEBUG)) {
            logger.debug("Dirty regions: " + list.size() + " of " + this.regionImageSetsCache.size());
        }
        return list;
    }

    public boolean isDirtySince(RegionCoord rc, MapType mapType, long time) {
        RegionImageSet ris = this.getRegionImageSet(rc);
        if (ris == null) {
            return false;
        }
        return ris.updatedSince(mapType, time);
    }

    public void clear() {
        this.regionImageSetsCache.invalidateAll();
        this.regionImageSetsCache.cleanUp();
    }

    public boolean deleteMap(MapState state, boolean allDims) {
        RegionCoord fakeRc = new RegionCoord(state.getWorldDir(), 0, 0, state.getDimension());
        File imageDir = RegionImageHandler.getImageDir(fakeRc, MapType.day(state.getDimension())).getParentFile();
        if (!imageDir.getName().startsWith("DIM")) {
            logger.error("Expected DIM directory, got " + imageDir);
            return false;
        }
        File[] dirs = allDims ? imageDir.getParentFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return dir.isDirectory() && name.startsWith("DIM");
            }
        }) : new File[]{imageDir};
        if (dirs != null && dirs.length > 0) {
            for (RegionImageSet regionImageSet : this.getRegionImageSets()) {
                regionImageSet.clear();
            }
            this.clear();
            boolean result = true;
            for (File dir : dirs) {
                if (!dir.exists()) continue;
                FileHandler.delete(dir);
                logger.info(String.format("Deleted image directory %s: %s", dir, !dir.exists()));
                if (!dir.exists()) continue;
                result = false;
            }
            logger.info("Done deleting directories");
            return result;
        }
        logger.info("Found no DIM directories in " + imageDir);
        return true;
    }

    private static class Holder {
        private static final RegionImageCache INSTANCE = new RegionImageCache();

        private Holder() {
        }
    }
}

