/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.io.migrate;

import java.io.File;
import java.io.FileFilter;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.Version;
import net.techbrew.journeymap.io.FileHandler;
import net.techbrew.journeymap.io.migrate.Migration;
import net.techbrew.journeymap.log.LogFormatter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Migrate5_0_0
implements Migration.Task {
    Logger logger = LogManager.getLogger((String)"journeymap");

    protected Migrate5_0_0() {
    }

    @Override
    public Version getRequiredVersion() {
        return new Version(5, 0, 0);
    }

    @Override
    public Boolean call() throws Exception {
        boolean jmDirSuccess = this.migrateJourneyMapDir();
        boolean configDirSuccess = this.migrateConfigDir();
        return jmDirSuccess && configDirSuccess;
    }

    private boolean migrateJourneyMapDir() {
        try {
            File[] files = FileHandler.MinecraftDirectory.listFiles();
            if (files != null) {
                for (File legacyDir : files) {
                    if (!legacyDir.isDirectory() || !legacyDir.getName().equals(Constants.JOURNEYMAP_DIR_LEGACY)) continue;
                    try {
                        this.logger.info(String.format("Renaming \"%s\" to \"%s\".", legacyDir, FileHandler.JourneyMapDirectory));
                        File backupDir = new File(FileHandler.MinecraftDirectory, Constants.JOURNEYMAP_DIR_BACKUP);
                        legacyDir.renameTo(backupDir);
                        backupDir.renameTo(FileHandler.JourneyMapDirectory);
                        return true;
                    }
                    catch (Throwable t) {
                        this.logger.error(String.format("Could not rename \"%s\" to \"%s\" ! Please shut down and rename it manually.", legacyDir, FileHandler.JourneyMapDirectory), t);
                        return false;
                    }
                }
            }
            return true;
        }
        catch (Throwable t) {
            this.logger.error(String.format("Could not rename old directory to \"%s\" ! Please shut down and rename it manually.", FileHandler.JourneyMapDirectory), t);
            return false;
        }
    }

    private boolean migrateConfigDir() {
        try {
            File legacyConfigDir = new File(FileHandler.MinecraftDirectory, Constants.CONFIG_DIR_LEGACY);
            if (!legacyConfigDir.exists()) {
                return true;
            }
            if (legacyConfigDir.isFile()) {
                this.logger.warn("Found file instead of directory.  Attempting to rename it to " + legacyConfigDir.getName() + "_bak");
                return legacyConfigDir.renameTo(new File(FileHandler.MinecraftDirectory, Constants.CONFIG_DIR_LEGACY + "_bak"));
            }
            File[] configFiles = legacyConfigDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.getName().endsWith(".config");
                }
            });
            boolean success = true;
            if (configFiles != null && configFiles.length > 0) {
                File backupDir = new File(legacyConfigDir, "backup_" + System.currentTimeMillis());
                backupDir.mkdirs();
                for (File old : configFiles) {
                    try {
                        boolean moved = old.renameTo(new File(backupDir, old.getName()));
                        if (moved) {
                            this.logger.info(String.format("Moved obsolete \"%s\" to \"%s\".", old, backupDir));
                            continue;
                        }
                        this.logger.warn(String.format("Failed to move obsolete \"%s\" to \"%s\".", old, backupDir));
                        success = false;
                    }
                    catch (Throwable t) {
                        this.logger.error(String.format("Failed to move obsolete \"%s\" to \"%s\": %s", old, backupDir, LogFormatter.toString(t)));
                        success = false;
                    }
                }
            }
            return success;
        }
        catch (Throwable t) {
            this.logger.error(String.format("Unexpected error in migrateConfigDir(): %s", LogFormatter.toString(t)));
            return false;
        }
    }
}

