/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.io;

import cpw.mods.fml.client.FMLClientHandler;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.log.StatTimer;
import net.techbrew.journeymap.model.BlockMD;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public class IconLoader {
    final BufferedImage blocksTexture;
    Logger logger = JourneyMap.getLogger();
    DataCache dataCache = DataCache.instance();
    HashSet<BlockMD> failed = new HashSet();

    public IconLoader() {
        this.blocksTexture = this.initBlocksTexture();
    }

    public boolean failedFor(BlockMD blockMD) {
        return this.failed.contains(blockMD);
    }

    public Color loadBlockColor(BlockMD blockMD) {
        Color color = null;
        if (this.blocksTexture == null) {
            this.logger.warn("BlocksTexture not yet loaded");
            return null;
        }
        try {
            IIcon blockIcon = this.getDirectIcon(blockMD);
            if (blockIcon == null && blockMD.getBlock() instanceof ITileEntityProvider) {
                this.logger.debug("Ignoring TitleEntity without standard block texture: " + blockMD);
                blockMD.addFlags(BlockMD.Flag.TileEntity, BlockMD.Flag.HasAir);
                return null;
            }
            if (blockIcon == null) {
                blockMD.addFlags(BlockMD.Flag.Error);
                this.failed.add(blockMD);
                return null;
            }
            color = this.getColorForIcon(blockMD, blockIcon);
            if (color == null) {
                this.failed.add(blockMD);
                return null;
            }
            return color;
        }
        catch (Throwable t) {
            this.failed.add(blockMD);
            this.logger.error("Error getting color: " + LogFormatter.toString(t));
            return null;
        }
    }

    private IIcon getDirectIcon(BlockMD blockMD) {
        IIcon blockIcon = null;
        if (blockMD.getBlock() instanceof BlockDoublePlant) {
            BlockDoublePlant blockDoublePlant = (BlockDoublePlant)blockMD.getBlock();
            try {
                blockIcon = blockDoublePlant.func_149888_a(true, blockMD.meta & BlockDoublePlant.field_149892_a.length);
            }
            catch (Throwable t) {
                this.logger.warn(blockMD + " trying BlockDoublePlant.func_149888_a(true, " + (blockMD.meta & BlockDoublePlant.field_149892_a.length) + " throws exception: " + t);
                int side = blockMD.hasFlag(BlockMD.Flag.Side2Texture) ? 2 : 1;
                blockIcon = blockDoublePlant.func_149691_a(side, blockMD.meta);
            }
            if (blockIcon.func_94215_i().contains("sunflower")) {
                blockIcon = blockDoublePlant.field_149891_b[0];
            }
        } else {
            if (blockMD.hasFlag(BlockMD.Flag.SpecialHandling)) {
                blockIcon = DataCache.instance().getModBlockDelegate().getIcon(blockMD);
            }
            if (blockIcon == null) {
                int side;
                int n = side = blockMD.hasFlag(BlockMD.Flag.Side2Texture) ? 2 : 1;
                while (blockIcon == null && side >= 0) {
                    blockIcon = blockMD.getBlock().func_149691_a(side, blockMD.meta);
                    --side;
                }
            }
        }
        return blockIcon;
    }

    Color getColorForIcon(BlockMD blockMD, IIcon icon) {
        Color color = null;
        try {
            int yStop;
            int xStop;
            int yStart;
            int xStart;
            BufferedImage textureImg;
            int count = 0;
            int a = 0;
            int r = 0;
            int g = 0;
            int b = 0;
            int x = 0;
            int y = 0;
            if (icon instanceof TextureAtlasSprite) {
                TextureAtlasSprite tas = (TextureAtlasSprite)icon;
                textureImg = this.blocksTexture;
                xStart = tas.func_130010_a();
                yStart = tas.func_110967_i();
                xStop = xStart + icon.func_94211_a();
                yStop = yStart + icon.func_94216_b();
            } else {
                textureImg = this.blocksTexture;
                xStart = Math.round((float)textureImg.getWidth() * Math.min(icon.func_94209_e(), icon.func_94212_f()));
                yStart = Math.round((float)textureImg.getHeight() * Math.min(icon.func_94206_g(), icon.func_94210_h()));
                int iconWidth = Math.round((float)textureImg.getWidth() * Math.abs(icon.func_94212_f() - icon.func_94209_e()));
                int iconHeight = Math.round((float)textureImg.getHeight() * Math.abs(icon.func_94210_h() - icon.func_94206_g()));
                xStop = xStart + iconWidth;
                yStop = yStart + iconHeight;
            }
            boolean unusable = true;
            if (textureImg != null && textureImg.getWidth() > 0) {
                block5: for (x = xStart; x < xStop; ++x) {
                    for (y = yStart; y < yStop; ++y) {
                        int argb;
                        try {
                            argb = textureImg.getRGB(x, y);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            this.logger.warn("Bad index at " + x + "," + y + " for " + blockMD + ": " + e.getMessage());
                            continue;
                        }
                        catch (Throwable e) {
                            this.logger.warn("Couldn't get RGB from BlocksTexture at " + x + "," + y + " for " + blockMD + ": " + e.getMessage());
                            break block5;
                        }
                        int alpha = argb >> 24 & 0xFF;
                        if (alpha <= 0) continue;
                        ++count;
                        a += alpha;
                        r += argb >> 16 & 0xFF;
                        g += argb >> 8 & 0xFF;
                        b += argb & 0xFF;
                    }
                }
                if (count > 0) {
                    unusable = false;
                    if (a > 0) {
                        a /= count;
                    }
                    if (r > 0) {
                        r /= count;
                    }
                    if (g > 0) {
                        g /= count;
                    }
                    if (b > 0) {
                        b /= count;
                    }
                }
            } else {
                this.logger.warn("Couldn't get texture for " + icon.func_94215_i() + " using blockid ");
            }
            if (unusable) {
                blockMD.addFlags(BlockMD.Flag.Error);
                this.dataCache.getBlockMetadata().setFlags(blockMD.getBlock(), BlockMD.Flag.Error);
                String pattern = "Unusable texture for %s, icon=%s,texture coords %s,%s - %s,%s";
                this.logger.debug(String.format(pattern, blockMD, icon.func_94215_i(), xStart, yStart, xStop, yStop));
                b = 0;
                g = 0;
                r = 0;
            }
            color = new Color(r, g, b);
            Block block = blockMD.getBlock();
            float blockAlpha = 1.0f;
            if (unusable) {
                blockAlpha = 0.0f;
            } else if (this.dataCache.getBlockMetadata().hasAlpha(block)) {
                blockAlpha = this.dataCache.getBlockMetadata().getAlpha(block);
            } else if (block.func_149701_w() > 0 && (blockAlpha = (float)a * 1.0f / 255.0f) == 1.0f) {
                blockAlpha = (float)block.getLightOpacity((IBlockAccess)FMLClientHandler.instance().getClient().field_71441_e, 0, 65, 0) / 255.0f;
            }
            this.dataCache.getBlockMetadata().setAlpha(block, Float.valueOf(blockAlpha));
            blockMD.setAlpha(blockAlpha);
            blockMD.setIconName(icon.func_94215_i());
        }
        catch (Throwable e1) {
            this.logger.warn("Error deriving color for " + blockMD + ": " + LogFormatter.toString(e1));
        }
        if (color != null && this.logger.isTraceEnabled()) {
            this.logger.debug("Derived color for " + blockMD + ": " + Integer.toHexString(color.getRGB()));
        }
        return color;
    }

    private BufferedImage initBlocksTexture() {
        StatTimer timer = StatTimer.get("IconLoader.initBlocksTexture", 0);
        timer.start();
        BufferedImage image = null;
        try {
            int glid = FMLClientHandler.instance().getClient().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_110552_b();
            GL11.glBindTexture((int)3553, (int)glid);
            int width = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
            int height = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(width * height * 4).order(ByteOrder.nativeOrder());
            GL11.glGetTexImage((int)3553, (int)0, (int)6408, (int)5121, (ByteBuffer)byteBuffer);
            image = new BufferedImage(width, height, 6);
            byteBuffer.position(0);
            byte[] var4 = new byte[byteBuffer.remaining()];
            byteBuffer.get(var4);
            for (int var5 = 0; var5 < width; ++var5) {
                for (int var6 = 0; var6 < height; ++var6) {
                    int var7 = var6 * width * 4 + var5 * 4;
                    int var8 = 0;
                    int var10 = var8 | var4[var7 + 2] & 0xFF;
                    var10 |= (var4[var7 + 1] & 0xFF) << 8;
                    var10 |= (var4[var7 + 0] & 0xFF) << 16;
                    image.setRGB(var5, var6, var10 |= (var4[var7 + 3] & 0xFF) << 24);
                }
            }
            timer.stop();
        }
        catch (Throwable t) {
            this.logger.error("Could not load blocksTexture :" + t);
            timer.cancel();
        }
        return image;
    }
}

