/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.data;

import com.google.common.cache.CacheLoader;
import cpw.mods.fml.client.FMLClientHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.biome.WorldChunkManager;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.model.EntityDTO;

public class PlayerData
extends CacheLoader<Class, EntityDTO> {
    public static boolean playerIsUnderground(Minecraft mc, EntityPlayer player) {
        if (player.field_70170_p.field_73011_w.field_76576_e) {
            return true;
        }
        int posX = MathHelper.func_76128_c((double)player.field_70165_t);
        int posY = MathHelper.func_76128_c((double)player.field_70121_D.field_72338_b);
        int posZ = MathHelper.func_76128_c((double)player.field_70161_v);
        boolean offset = true;
        boolean isUnderground = true;
        if (posY < 0) {
            return true;
        }
        int y = posY;
        block0: for (int x = posX - 1; x <= posX + 1; ++x) {
            for (int z = posZ - 1; z <= posZ + 1; ++z) {
                y = posY + 1;
                ChunkMD chunkMD = DataCache.instance().getChunkMD(new ChunkCoordIntPair(x >> 4, z >> 4));
                if (chunkMD == null || chunkMD.ceiling(x & 0xF, z & 0xF) > y) continue;
                isUnderground = false;
                break block0;
            }
        }
        return isUnderground;
    }

    public EntityDTO load(Class aClass) throws Exception {
        Minecraft mc = FMLClientHandler.instance().getClient();
        EntityClientPlayerMP player = mc.field_71439_g;
        EntityDTO dto = DataCache.instance().getEntityDTO((EntityLivingBase)player);
        dto.update((EntityLivingBase)player, false);
        dto.biome = this.getPlayerBiome(mc, player);
        dto.underground = PlayerData.playerIsUnderground(mc, (EntityPlayer)player);
        return dto;
    }

    private String getPlayerBiome(Minecraft mc, EntityClientPlayerMP player) {
        int x = MathHelper.func_76128_c((double)player.field_70165_t) >> 4 & 0xF;
        int z = MathHelper.func_76128_c((double)player.field_70161_v) >> 4 & 0xF;
        ChunkMD playerChunk = DataCache.instance().getChunkMD(new ChunkCoordIntPair(player.field_70176_ah, player.field_70164_aj));
        if (playerChunk != null) {
            return playerChunk.getChunk().func_76591_a((int)x, (int)z, (WorldChunkManager)mc.field_71441_e.func_72959_q()).field_76791_y;
        }
        return "?";
    }

    public long getTTL() {
        return JourneyMap.getCoreProperties().cachePlayerData.get();
    }
}

