/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.data;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import cpw.mods.fml.common.registry.GameData;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.ChunkCoordIntPair;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.AllData;
import net.techbrew.journeymap.data.AnimalsData;
import net.techbrew.journeymap.data.MessagesData;
import net.techbrew.journeymap.data.MobsData;
import net.techbrew.journeymap.data.PlayerData;
import net.techbrew.journeymap.data.PlayersData;
import net.techbrew.journeymap.data.VillagersData;
import net.techbrew.journeymap.data.WaypointsData;
import net.techbrew.journeymap.data.WorldData;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.BlockMD;
import net.techbrew.journeymap.model.BlockMDCache;
import net.techbrew.journeymap.model.ChunkCoord;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.model.EntityDTO;
import net.techbrew.journeymap.model.MapType;
import net.techbrew.journeymap.model.RegionCoord;
import net.techbrew.journeymap.model.RegionImageCache;
import net.techbrew.journeymap.model.RegionImageSet;
import net.techbrew.journeymap.model.Waypoint;
import net.techbrew.journeymap.model.mod.ModBlockDelegate;
import net.techbrew.journeymap.render.draw.DrawEntityStep;
import net.techbrew.journeymap.render.draw.DrawWayPointStep;
import net.techbrew.journeymap.waypoint.WaypointStore;

public class DataCache {
    final LoadingCache<Long, Map> all;
    final LoadingCache<Class, Map<String, EntityDTO>> animals;
    final LoadingCache<Class, Map<String, EntityDTO>> mobs;
    final LoadingCache<Class, Map<String, EntityDTO>> players;
    final LoadingCache<Class, Map<String, EntityDTO>> villagers;
    final LoadingCache<Class, Collection<Waypoint>> waypoints;
    final LoadingCache<Class, EntityDTO> player;
    final LoadingCache<Class, WorldData> world;
    final LoadingCache<RegionImageSet.Key, RegionImageSet> regionImageSets;
    final LoadingCache<Class, Map<String, Object>> messages;
    final LoadingCache<EntityDTO, DrawEntityStep> entityDrawSteps;
    final LoadingCache<Waypoint, DrawWayPointStep> waypointDrawSteps;
    final LoadingCache<EntityLivingBase, EntityDTO> entityDTOs;
    final Cache<Integer, ChunkCoord> chunkCoords;
    final Cache<Integer, RegionCoord> regionCoords;
    final Cache<Integer, MapType> mapTypes;
    final LoadingCache<Block, HashMap<Integer, BlockMD>> blockMetadata;
    final BlockMDCache blockMetadataLoader;
    final ProxyRemovalListener<ChunkCoordIntPair, Optional<ChunkMD>> chunkMetadataRemovalListener;
    final HashMap<Cache, String> managedCaches = new HashMap();
    final WeakHashMap<Cache, String> privateCaches = new WeakHashMap();
    private final int chunkCacheExpireSeconds = 30;
    private final int defaultConcurrencyLevel = 1;
    LoadingCache<ChunkCoordIntPair, Optional<ChunkMD>> chunkMetadata;

    private DataCache() {
        AllData allData = new AllData();
        this.all = this.getCacheBuilder().maximumSize(1L).expireAfterWrite(allData.getTTL(), TimeUnit.MILLISECONDS).build((CacheLoader)allData);
        this.managedCaches.put((Cache)this.all, "AllData (web)");
        AnimalsData animalsData = new AnimalsData();
        this.animals = this.getCacheBuilder().expireAfterWrite(animalsData.getTTL(), TimeUnit.MILLISECONDS).build((CacheLoader)animalsData);
        this.managedCaches.put((Cache)this.animals, "Animals");
        MobsData mobsData = new MobsData();
        this.mobs = this.getCacheBuilder().expireAfterWrite(mobsData.getTTL(), TimeUnit.MILLISECONDS).build((CacheLoader)mobsData);
        this.managedCaches.put((Cache)this.mobs, "Mobs");
        PlayerData playerData = new PlayerData();
        this.player = this.getCacheBuilder().expireAfterWrite(playerData.getTTL(), TimeUnit.MILLISECONDS).build((CacheLoader)playerData);
        this.managedCaches.put((Cache)this.player, "Player");
        PlayersData playersData = new PlayersData();
        this.players = this.getCacheBuilder().expireAfterWrite(playersData.getTTL(), TimeUnit.MILLISECONDS).build((CacheLoader)playersData);
        this.managedCaches.put((Cache)this.players, "Players");
        VillagersData villagersData = new VillagersData();
        this.villagers = this.getCacheBuilder().expireAfterWrite(villagersData.getTTL(), TimeUnit.MILLISECONDS).build((CacheLoader)villagersData);
        this.managedCaches.put((Cache)this.villagers, "Villagers");
        WaypointsData waypointsData = new WaypointsData();
        this.waypoints = this.getCacheBuilder().expireAfterWrite(waypointsData.getTTL(), TimeUnit.MILLISECONDS).build((CacheLoader)waypointsData);
        this.managedCaches.put((Cache)this.waypoints, "Waypoints");
        WorldData worldData = new WorldData();
        this.world = this.getCacheBuilder().expireAfterWrite(worldData.getTTL(), TimeUnit.MILLISECONDS).build((CacheLoader)worldData);
        this.managedCaches.put((Cache)this.world, "World");
        MessagesData messagesData = new MessagesData();
        this.messages = this.getCacheBuilder().expireAfterWrite(messagesData.getTTL(), TimeUnit.MILLISECONDS).build((CacheLoader)messagesData);
        this.managedCaches.put((Cache)this.messages, "Messages (web)");
        this.entityDrawSteps = this.getCacheBuilder().weakKeys().build((CacheLoader)new DrawEntityStep.SimpleCacheLoader());
        this.managedCaches.put((Cache)this.entityDrawSteps, "DrawEntityStep");
        this.waypointDrawSteps = this.getCacheBuilder().weakKeys().build((CacheLoader)new DrawWayPointStep.SimpleCacheLoader());
        this.managedCaches.put((Cache)this.waypointDrawSteps, "DrawWaypointStep");
        this.entityDTOs = this.getCacheBuilder().weakKeys().build((CacheLoader)new EntityDTO.SimpleCacheLoader());
        this.managedCaches.put((Cache)this.entityDTOs, "EntityDTO");
        this.regionImageSets = RegionImageCache.initRegionImageSetsCache(this.getCacheBuilder());
        this.managedCaches.put((Cache)this.regionImageSets, "RegionImageSet");
        this.chunkMetadataRemovalListener = new ProxyRemovalListener();
        this.chunkMetadata = this.getCacheBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).removalListener(this.chunkMetadataRemovalListener).build((CacheLoader)new ChunkMD.SimpleCacheLoader());
        this.managedCaches.put((Cache)this.chunkMetadata, "ChunkMD");
        this.blockMetadataLoader = new BlockMDCache();
        this.blockMetadata = this.getCacheBuilder().initialCapacity(GameData.getBlockRegistry().func_148742_b().size()).build((CacheLoader)this.blockMetadataLoader);
        this.managedCaches.put((Cache)this.blockMetadata, "BlockMD");
        this.chunkCoords = this.getCacheBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).build();
        this.managedCaches.put(this.chunkCoords, "ChunkCoord");
        this.regionCoords = this.getCacheBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).build();
        this.managedCaches.put(this.regionCoords, "RegionCoord");
        this.mapTypes = this.getCacheBuilder().build();
        this.managedCaches.put(this.mapTypes, "MapType");
    }

    public static DataCache instance() {
        return Holder.INSTANCE;
    }

    public static EntityDTO getPlayer() {
        return DataCache.instance().getPlayer(false);
    }

    private CacheBuilder<Object, Object> getCacheBuilder() {
        CacheBuilder builder = CacheBuilder.newBuilder();
        builder.concurrencyLevel(1);
        if (JourneyMap.getCoreProperties().recordCacheStats.get()) {
            builder.recordStats();
        }
        return builder;
    }

    public void addPrivateCache(String name, Cache cache) {
        if (this.privateCaches.containsValue(name)) {
            JourneyMap.getLogger().warn("Overriding private cache: " + name);
        }
        this.privateCaches.put(cache, name);
    }

    public Cache getPrivateCache(String name) {
        for (Map.Entry<Cache, String> entry : this.privateCaches.entrySet()) {
            if (!entry.getValue().equals(name)) continue;
            return entry.getKey();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getAll(long since) {
        LoadingCache<Long, Map> loadingCache = this.all;
        synchronized (loadingCache) {
            try {
                return (Map)this.all.get((Object)since);
            }
            catch (ExecutionException e) {
                JourneyMap.getLogger().error("ExecutionException in getAll: " + LogFormatter.toString(e));
                return Collections.EMPTY_MAP;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, EntityDTO> getAnimals(boolean forceRefresh) {
        LoadingCache<Class, Map<String, EntityDTO>> loadingCache = this.animals;
        synchronized (loadingCache) {
            try {
                if (forceRefresh) {
                    this.animals.invalidateAll();
                }
                return (Map)this.animals.get(AnimalsData.class);
            }
            catch (ExecutionException e) {
                JourneyMap.getLogger().error("ExecutionException in getAnimals: " + LogFormatter.toString(e));
                return Collections.EMPTY_MAP;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, EntityDTO> getMobs(boolean forceRefresh) {
        LoadingCache<Class, Map<String, EntityDTO>> loadingCache = this.mobs;
        synchronized (loadingCache) {
            try {
                if (forceRefresh) {
                    this.mobs.invalidateAll();
                }
                return (Map)this.mobs.get(MobsData.class);
            }
            catch (ExecutionException e) {
                JourneyMap.getLogger().error("ExecutionException in getMobs: " + LogFormatter.toString(e));
                return Collections.EMPTY_MAP;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, EntityDTO> getPlayers(boolean forceRefresh) {
        LoadingCache<Class, Map<String, EntityDTO>> loadingCache = this.players;
        synchronized (loadingCache) {
            try {
                if (forceRefresh) {
                    this.players.invalidateAll();
                }
                return (Map)this.players.get(PlayersData.class);
            }
            catch (ExecutionException e) {
                JourneyMap.getLogger().error("ExecutionException in getPlayers: " + LogFormatter.toString(e));
                return Collections.EMPTY_MAP;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityDTO getPlayer(boolean forceRefresh) {
        LoadingCache<Class, EntityDTO> loadingCache = this.player;
        synchronized (loadingCache) {
            try {
                if (forceRefresh) {
                    this.player.invalidateAll();
                }
                return (EntityDTO)this.player.get(PlayersData.class);
            }
            catch (ExecutionException e) {
                JourneyMap.getLogger().error("ExecutionException in getPlayer: " + LogFormatter.toString(e));
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, EntityDTO> getVillagers(boolean forceRefresh) {
        LoadingCache<Class, Map<String, EntityDTO>> loadingCache = this.villagers;
        synchronized (loadingCache) {
            try {
                if (forceRefresh) {
                    this.villagers.invalidateAll();
                }
                return (Map)this.villagers.get(VillagersData.class);
            }
            catch (ExecutionException e) {
                JourneyMap.getLogger().error("ExecutionException in getVillagers: " + LogFormatter.toString(e));
                return Collections.EMPTY_MAP;
            }
        }
    }

    public MapType getMapType(MapType.Name name, Integer vSlice, int dimension) {
        vSlice = name != MapType.Name.underground ? null : vSlice;
        MapType mapType = (MapType)this.mapTypes.getIfPresent((Object)MapType.toHash(name, vSlice, dimension));
        if (mapType == null) {
            mapType = new MapType(name, vSlice, dimension);
            this.mapTypes.put((Object)mapType.hashCode(), (Object)mapType);
        }
        return mapType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Waypoint> getWaypoints(boolean forceRefresh) {
        LoadingCache<Class, Collection<Waypoint>> loadingCache = this.waypoints;
        synchronized (loadingCache) {
            if (WaypointsData.isReiMinimapEnabled() || WaypointsData.isVoxelMapEnabled()) {
                try {
                    if (forceRefresh) {
                        this.waypoints.invalidateAll();
                    }
                    return (Collection)this.waypoints.get(WaypointsData.class);
                }
                catch (ExecutionException e) {
                    JourneyMap.getLogger().error("ExecutionException in getVillagers: " + LogFormatter.toString(e));
                    return Collections.EMPTY_LIST;
                }
            }
            if (WaypointsData.isManagerEnabled()) {
                return WaypointStore.instance().getAll();
            }
            return Collections.EMPTY_LIST;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getMessages(boolean forceRefresh) {
        LoadingCache<Class, Map<String, Object>> loadingCache = this.messages;
        synchronized (loadingCache) {
            try {
                if (forceRefresh) {
                    this.messages.invalidateAll();
                }
                return (Map)this.messages.get(MessagesData.class);
            }
            catch (ExecutionException e) {
                JourneyMap.getLogger().error("ExecutionException in getMessages: " + LogFormatter.toString(e));
                return Collections.EMPTY_MAP;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorldData getWorld(boolean forceRefresh) {
        LoadingCache<Class, WorldData> loadingCache = this.world;
        synchronized (loadingCache) {
            try {
                if (forceRefresh) {
                    this.world.invalidateAll();
                }
                return (WorldData)((Object)this.world.get(WorldData.class));
            }
            catch (ExecutionException e) {
                JourneyMap.getLogger().error("ExecutionException in getWorld: " + LogFormatter.toString(e));
                return new WorldData();
            }
        }
    }

    public void resetRadarCaches() {
        this.animals.invalidateAll();
        this.mobs.invalidateAll();
        this.players.invalidateAll();
        this.villagers.invalidateAll();
        this.entityDrawSteps.invalidateAll();
        this.entityDTOs.invalidateAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DrawEntityStep getDrawEntityStep(EntityDTO entityDTO) {
        LoadingCache<EntityDTO, DrawEntityStep> loadingCache = this.entityDrawSteps;
        synchronized (loadingCache) {
            return (DrawEntityStep)this.entityDrawSteps.getUnchecked((Object)entityDTO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityDTO getEntityDTO(EntityLivingBase entity) {
        LoadingCache<EntityLivingBase, EntityDTO> loadingCache = this.entityDTOs;
        synchronized (loadingCache) {
            return (EntityDTO)this.entityDTOs.getUnchecked((Object)entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DrawWayPointStep getDrawWayPointStep(Waypoint waypoint) {
        LoadingCache<Waypoint, DrawWayPointStep> loadingCache = this.waypointDrawSteps;
        synchronized (loadingCache) {
            return (DrawWayPointStep)this.waypointDrawSteps.getUnchecked((Object)waypoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChunkMD getChunkMD(ChunkCoordIntPair coord) {
        LoadingCache<ChunkCoordIntPair, Optional<ChunkMD>> loadingCache = this.chunkMetadata;
        synchronized (loadingCache) {
            ChunkMD chunkMD = null;
            try {
                Optional optional = (Optional)this.chunkMetadata.get((Object)coord);
                if (optional.isPresent()) {
                    chunkMD = (ChunkMD)optional.get();
                } else {
                    this.chunkMetadata.invalidate((Object)coord);
                }
            }
            catch (Throwable e) {
                JourneyMap.getLogger().warn("Unexpected error getting ChunkMD from cache: " + e);
            }
            return chunkMD;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChunkMD(ChunkMD chunkMD) {
        LoadingCache<ChunkCoordIntPair, Optional<ChunkMD>> loadingCache = this.chunkMetadata;
        synchronized (loadingCache) {
            this.chunkMetadata.put((Object)chunkMD.getCoord(), (Object)Optional.of((Object)chunkMD));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ChunkCoordIntPair> getCachedChunkCoordinates() {
        LoadingCache<ChunkCoordIntPair, Optional<ChunkMD>> loadingCache = this.chunkMetadata;
        synchronized (loadingCache) {
            return this.chunkMetadata.asMap().keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateChunkMD(ChunkCoordIntPair coord) {
        LoadingCache<ChunkCoordIntPair, Optional<ChunkMD>> loadingCache = this.chunkMetadata;
        synchronized (loadingCache) {
            this.chunkMetadata.invalidate((Object)coord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateChunkMDCache() {
        LoadingCache<ChunkCoordIntPair, Optional<ChunkMD>> loadingCache = this.chunkMetadata;
        synchronized (loadingCache) {
            this.chunkMetadata.invalidateAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChunkMDListener(RemovalListener<ChunkCoordIntPair, Optional<ChunkMD>> listener) {
        ProxyRemovalListener<ChunkCoordIntPair, Optional<ChunkMD>> proxyRemovalListener = this.chunkMetadataRemovalListener;
        synchronized (proxyRemovalListener) {
            this.chunkMetadataRemovalListener.addDelegateListener(listener);
        }
    }

    public void resetBlockMetadata() {
        this.blockMetadata.invalidateAll();
        this.blockMetadataLoader.initialize();
    }

    public BlockMDCache getBlockMetadata() {
        return this.blockMetadataLoader;
    }

    public BlockMD getBlockMD(ChunkMD chunkMd, int x, int y, int z) {
        return this.blockMetadataLoader.getBlockMD(this.blockMetadata, chunkMd, x, y, z);
    }

    public BlockMD getBlockMD(Block block, int meta) {
        return this.blockMetadataLoader.getBlockMD(this.blockMetadata, block, meta);
    }

    public ModBlockDelegate getModBlockDelegate() {
        return this.blockMetadataLoader.getModBlockDelegate();
    }

    public LoadingCache<RegionImageSet.Key, RegionImageSet> getRegionImageSets() {
        return this.regionImageSets;
    }

    public Cache<Integer, ChunkCoord> getChunkCoords() {
        return this.chunkCoords;
    }

    public Cache<Integer, RegionCoord> getRegionCoords() {
        return this.regionCoords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        RegionImageCache.instance().flushToDisk();
        AbstractMap abstractMap = this.managedCaches;
        synchronized (abstractMap) {
            for (Cache cache : this.managedCaches.keySet()) {
                try {
                    cache.invalidateAll();
                }
                catch (Exception e) {
                    JourneyMap.getLogger().warn("Couldn't purge managed cache: " + cache);
                }
            }
        }
        abstractMap = this.privateCaches;
        synchronized (abstractMap) {
            for (Cache cache : this.privateCaches.keySet()) {
                try {
                    cache.invalidateAll();
                }
                catch (Exception e) {
                    JourneyMap.getLogger().warn("Couldn't purge private cache: " + cache);
                }
            }
            this.privateCaches.clear();
        }
    }

    public String getDebugHtml() {
        StringBuffer sb = new StringBuffer();
        if (JourneyMap.getCoreProperties().recordCacheStats.get()) {
            this.appendDebugHtml(sb, "Managed Caches", this.managedCaches);
            this.appendDebugHtml(sb, "Private Caches", this.privateCaches);
        } else {
            sb.append("<b>Cache stat recording disabled.  Set config/journeymap.core.config 'recordCacheStats' to 1.</b>");
        }
        return sb.toString();
    }

    private void appendDebugHtml(StringBuffer sb, String name, Map<Cache, String> cacheMap) {
        ArrayList<Map.Entry<Cache, String>> list = new ArrayList<Map.Entry<Cache, String>>(cacheMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Cache, String>>(){

            @Override
            public int compare(Map.Entry<Cache, String> o1, Map.Entry<Cache, String> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        sb.append("<b>").append(name).append(":</b>");
        sb.append("<pre>");
        for (Map.Entry<Cache, String> entry : list) {
            sb.append(this.toString(entry.getValue(), entry.getKey()));
        }
        sb.append("</pre>");
    }

    private String toString(String label, Cache cache) {
        double avgLoadMillis = 0.0;
        CacheStats cacheStats = cache.stats();
        if (cacheStats.totalLoadTime() > 0L && cacheStats.loadSuccessCount() > 0L) {
            avgLoadMillis = (double)TimeUnit.NANOSECONDS.toMillis(cacheStats.totalLoadTime()) * 1.0 / (double)cacheStats.loadSuccessCount();
        }
        return String.format("%s<b>%20s:</b> Size: %9s, Hits: %9s, Misses: %9s, Loads: %9s, Errors: %9s, Avg Load Time: %1.2fms", LogFormatter.LINEBREAK, label, cache.size(), cacheStats.hitCount(), cacheStats.missCount(), cacheStats.loadCount(), cacheStats.loadExceptionCount(), avgLoadMillis);
    }

    class ProxyRemovalListener<K, V>
    implements RemovalListener<K, V> {
        final Map<RemovalListener<K, V>, Void> delegates = Collections.synchronizedMap(new WeakHashMap());

        ProxyRemovalListener() {
        }

        void addDelegateListener(RemovalListener<K, V> delegate) {
            if (this.delegates.containsKey(delegate)) {
                JourneyMap.getLogger().warn("RemovalListener already added: " + delegate.getClass());
            } else {
                this.delegates.put(delegate, null);
            }
        }

        void removeDelegateListener(RemovalListener<K, V> delegate) {
            this.delegates.remove(delegate);
        }

        public void onRemoval(RemovalNotification<K, V> notification) {
            for (RemovalListener<K, V> delegate : this.delegates.keySet()) {
                delegate.onRemoval(notification);
            }
        }
    }

    private static class Holder {
        private static final DataCache INSTANCE = new DataCache();

        private Holder() {
        }
    }
}

