/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.cartography.render;

import net.minecraft.world.EnumSkyBlock;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.cartography.IChunkRenderer;
import net.techbrew.journeymap.cartography.RGB;
import net.techbrew.journeymap.cartography.Strata;
import net.techbrew.journeymap.cartography.render.BaseRenderer;
import net.techbrew.journeymap.cartography.render.CaveRenderer;
import net.techbrew.journeymap.model.BlockMD;
import net.techbrew.journeymap.model.ChunkMD;

public class NetherRenderer
extends CaveRenderer
implements IChunkRenderer {
    public NetherRenderer() {
        super(null);
        this.cachePrefix = "Nether";
    }

    @Override
    protected void updateOptions() {
        super.updateOptions();
        this.ambientColor = RGB.floats(this.tweakNetherAmbientColor);
        this.mapSurfaceAboveCaves = false;
    }

    @Override
    protected Integer getSliceBlockHeight(ChunkMD chunkMd, int x, Integer vSlice, int z, int sliceMinY, int sliceMaxY, BaseRenderer.HeightsCache chunkHeights) {
        Integer[][] blockSliceHeights = (Integer[][])chunkHeights.getUnchecked(chunkMd.getCoord());
        if (blockSliceHeights == null) {
            return null;
        }
        Integer y = blockSliceHeights[x][z];
        if (y != null) {
            return y;
        }
        try {
            y = sliceMaxY;
            BlockMD blockMD = this.dataCache.getBlockMD(chunkMd, x, y, z);
            BlockMD blockMDAbove = this.dataCache.getBlockMD(chunkMd, x, Math.min(y + 1, sliceMaxY), z);
            while (y > 0 && !blockMD.isLava()) {
                if (blockMDAbove.isAir() || blockMDAbove.hasTranparency() || blockMDAbove.hasFlag(BlockMD.Flag.OpenToSky)) {
                    if (!(blockMD.isAir() || blockMD.hasTranparency() || blockMD.hasFlag(BlockMD.Flag.OpenToSky))) {
                        break;
                    }
                } else if (y == sliceMinY) {
                    y = sliceMaxY;
                    break;
                }
                Integer n = y;
                Integer n2 = y = Integer.valueOf(y - 1);
                blockMD = this.dataCache.getBlockMD(chunkMd, x, y, z);
                blockMDAbove = this.dataCache.getBlockMD(chunkMd, x, y + 1, z);
            }
        }
        catch (Exception e) {
            JourneyMap.getLogger().warn("Couldn't get safe slice block height at " + x + "," + z + ": " + e);
            y = sliceMaxY;
        }
        blockSliceHeights[x][z] = y = Integer.valueOf(Math.max(0, y));
        return y;
    }

    @Override
    protected void buildStrata(Strata strata, int minY, ChunkMD chunkMd, int x, int topY, int z, BaseRenderer.HeightsCache chunkHeights, BaseRenderer.SlopesCache chunkSlopes) {
        super.buildStrata(strata, minY, chunkMd, x, topY, z, chunkHeights, chunkSlopes);
    }

    @Override
    protected int getSliceLightLevel(ChunkMD chunkMd, int x, int y, int z, boolean adjusted) {
        if (y + 1 >= chunkMd.getWorldActualHeight()) {
            return 0;
        }
        int actualLight = chunkMd.getSavedLightValue(EnumSkyBlock.Block, x, y + 1, z);
        if (actualLight > 0) {
            return actualLight;
        }
        return Math.max(adjusted ? 2 : 0, actualLight);
    }

    @Override
    public float[] getAmbientColor() {
        return this.ambientColor;
    }
}

