/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.cartography;

import java.util.Stack;
import net.minecraft.world.ChunkCoordIntPair;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.cartography.IChunkRenderer;
import net.techbrew.journeymap.cartography.RGB;
import net.techbrew.journeymap.cartography.Stratum;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.model.BlockMD;
import net.techbrew.journeymap.model.ChunkMD;

public class Strata {
    final DataCache dataCache = DataCache.instance();
    private boolean mapCaveLighting;
    private boolean mapBathymetry;
    final String name;
    final int initialPoolSize;
    final int poolGrowthIncrement;
    private final boolean underground;
    private Integer topY;
    private Integer bottomY;
    private Integer topWaterY;
    private Integer bottomWaterY;
    private Integer maxLightLevel;
    private Integer waterColor;
    private Integer renderDayColor;
    private Integer renderNightColor;
    private Integer renderCaveColor;
    private int lightAttenuation;
    private boolean blocksFound;
    private Stack<Stratum> unusedStack;
    private Stack<Stratum> stack;

    public Strata(String name, int initialPoolSize, int poolGrowthIncrement, boolean underground) {
        this.mapCaveLighting = JourneyMap.getCoreProperties().mapCaveLighting.get();
        this.mapBathymetry = JourneyMap.getCoreProperties().mapBathymetry.get();
        this.topY = null;
        this.bottomY = null;
        this.topWaterY = null;
        this.bottomWaterY = null;
        this.maxLightLevel = null;
        this.waterColor = null;
        this.renderDayColor = null;
        this.renderNightColor = null;
        this.renderCaveColor = null;
        this.lightAttenuation = 0;
        this.blocksFound = false;
        this.unusedStack = new Stack();
        this.stack = new Stack();
        this.name = name;
        this.underground = underground;
        this.initialPoolSize = initialPoolSize;
        this.poolGrowthIncrement = poolGrowthIncrement;
        this.growFreePool(initialPoolSize);
    }

    private Stratum allocate() {
        if (this.unusedStack.isEmpty()) {
            int amount = this.stack.isEmpty() ? this.initialPoolSize : this.poolGrowthIncrement;
            this.growFreePool(amount);
            JourneyMap.getLogger().debug(String.format("Grew Strata pool for '%s' by '%s'. Free: %s, Used: %s", this.name, amount, this.unusedStack.size(), this.stack.size()));
        }
        this.stack.push(this.unusedStack.pop());
        return this.stack.peek();
    }

    private void growFreePool(int amount) {
        for (int i = 0; i < amount; ++i) {
            this.unusedStack.push(new Stratum());
        }
    }

    public void reset() {
        this.setTopY(null);
        this.setBottomY(null);
        this.setTopWaterY(null);
        this.setBottomWaterY(null);
        this.setMaxLightLevel(null);
        this.setWaterColor(null);
        this.setRenderDayColor(null);
        this.setRenderNightColor(null);
        this.setRenderCaveColor(null);
        this.setLightAttenuation(0);
        this.setBlocksFound(false);
        this.mapCaveLighting = JourneyMap.getCoreProperties().mapCaveLighting.get();
        this.mapBathymetry = JourneyMap.getCoreProperties().mapBathymetry.get();
        while (!this.stack.isEmpty()) {
            this.release(this.stack.peek());
        }
    }

    public void release(Stratum stratum) {
        if (stratum == null) {
            JourneyMap.getLogger().warn("Null stratum in pool.");
            return;
        }
        stratum.clear();
        this.unusedStack.add(0, this.stack.pop());
    }

    public Stratum push(ChunkMD chunkMd, BlockMD blockMD, int x, int y, int z) {
        return this.push(chunkMd, blockMD, x, y, z, null);
    }

    public Stratum push(ChunkMD chunkMd, BlockMD blockMD, int x, int y, int z, Integer lightLevel) {
        try {
            Stratum stratum = this.allocate();
            stratum.set(chunkMd, blockMD, x, y, z, lightLevel);
            this.setTopY(this.getTopY() == null ? y : Math.max(this.getTopY(), y));
            this.setBottomY(this.getBottomY() == null ? y : Math.min(this.getBottomY(), y));
            this.setMaxLightLevel(this.getMaxLightLevel() == null ? stratum.getLightLevel() : Math.max(this.getMaxLightLevel(), stratum.getLightLevel()));
            this.setLightAttenuation(this.getLightAttenuation() + stratum.getLightOpacity());
            this.setBlocksFound(true);
            if (blockMD.isWater()) {
                this.setTopWaterY(this.getTopWaterY() == null ? y : Math.max(this.getTopWaterY(), y));
                this.setBottomWaterY(this.getBottomWaterY() == null ? y : Math.min(this.getBottomWaterY(), y));
                if (this.getWaterColor() == null) {
                    this.determineWaterColor(chunkMd, x, y, z);
                }
            }
            return stratum;
        }
        catch (ChunkMD.ChunkMissingException e) {
            throw e;
        }
        catch (Throwable t) {
            JourneyMap.getLogger().error("Couldn't push Stratum into stack: " + t);
            return null;
        }
    }

    public Stratum nextUp(IChunkRenderer renderer, boolean ignoreMiddleWater) {
        Stratum stratum = null;
        stratum = this.stack.peek();
        if (stratum.isUninitialized()) {
            throw new IllegalStateException("Stratum wasn't initialized for Strata.nextUp()");
        }
        this.setLightAttenuation(Math.max(0, this.getLightAttenuation() - stratum.getLightOpacity()));
        if (ignoreMiddleWater && stratum.isWater() && this.isWaterAbove(stratum) && !this.stack.isEmpty()) {
            this.release(stratum);
            return this.nextUp(renderer, true);
        }
        renderer.setStratumColors(stratum, this.getLightAttenuation(), this.getWaterColor(), this.isWaterAbove(stratum), this.isUnderground(), this.isMapCaveLighting());
        return stratum;
    }

    int depth() {
        return this.stack.isEmpty() ? 0 : this.getTopY() - this.getBottomY() + 1;
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    boolean hasWater() {
        return this.getTopWaterY() != null;
    }

    boolean isWaterAbove(Stratum stratum) {
        return this.getTopWaterY() != null && this.getTopWaterY() > stratum.getY();
    }

    Integer getAverageWaterColor(int blockX, int blockY, int blockZ) {
        return RGB.average(this.getWaterColor(blockX, blockY, blockZ), this.getWaterColor(blockX - 1, blockY, blockZ), this.getWaterColor(blockX + 1, blockY, blockZ), this.getWaterColor(blockX, blockY - 1, blockZ), this.getWaterColor(blockX, blockY + 1, blockZ));
    }

    Integer getWaterColor(int blockX, int blockY, int blockZ) {
        BlockMD block;
        ChunkMD chunk = this.dataCache.getChunkMD(new ChunkCoordIntPair(blockX >> 4, blockZ >> 4));
        if (chunk != null && (block = this.dataCache.getBlockMD(chunk, blockX & 0xF, blockY, blockZ & 0xF)) != null && block.isWater()) {
            return block.getColor(chunk, blockX & 0xF, blockY, blockZ & 0xF);
        }
        return null;
    }

    public String toString() {
        return "Strata{name='" + this.name + '\'' + ", initialPoolSize=" + this.initialPoolSize + ", poolGrowthIncrement=" + this.poolGrowthIncrement + ", stack=" + this.stack.size() + ", unusedStack=" + this.unusedStack.size() + ", stack=" + this.stack.size() + ", topY=" + this.getTopY() + ", bottomY=" + this.getBottomY() + ", topWaterY=" + this.getTopWaterY() + ", bottomWaterY=" + this.getBottomWaterY() + ", maxLightLevel=" + this.getMaxLightLevel() + ", waterColor=" + RGB.toString(this.getWaterColor()) + ", renderDayColor=" + RGB.toString(this.getRenderDayColor()) + ", renderNightColor=" + RGB.toString(this.getRenderNightColor()) + ", lightAttenuation=" + this.getLightAttenuation() + '}';
    }

    public boolean isMapCaveLighting() {
        return this.mapCaveLighting;
    }

    public boolean isUnderground() {
        return this.underground;
    }

    public Integer getTopY() {
        return this.topY;
    }

    public void setTopY(Integer topY) {
        this.topY = topY;
    }

    public Integer getBottomY() {
        return this.bottomY;
    }

    public void setBottomY(Integer bottomY) {
        this.bottomY = bottomY;
    }

    public Integer getTopWaterY() {
        return this.topWaterY;
    }

    public void setTopWaterY(Integer topWaterY) {
        this.topWaterY = topWaterY;
    }

    public Integer getBottomWaterY() {
        return this.bottomWaterY;
    }

    public void setBottomWaterY(Integer bottomWaterY) {
        this.bottomWaterY = bottomWaterY;
    }

    public Integer getMaxLightLevel() {
        return this.maxLightLevel;
    }

    public void setMaxLightLevel(Integer maxLightLevel) {
        this.maxLightLevel = maxLightLevel;
    }

    public Integer getWaterColor() {
        return this.waterColor;
    }

    public void determineWaterColor(ChunkMD chunkMD, int x, int y, int z) {
        this.setWaterColor(this.getAverageWaterColor((chunkMD.getCoord().field_77276_a << 4) + x, y, (chunkMD.getCoord().field_77275_b << 4) + z));
        if (this.waterColor == null) {
            this.setWaterColor(2434509);
        }
        this.setWaterColor(RGB.darken(this.getWaterColor(), 0.85f));
    }

    public void setWaterColor(Integer waterColor) {
        this.waterColor = waterColor;
    }

    public Integer getRenderDayColor() {
        return this.renderDayColor;
    }

    public void setRenderDayColor(Integer renderDayColor) {
        this.renderDayColor = renderDayColor;
    }

    public Integer getRenderNightColor() {
        return this.renderNightColor;
    }

    public void setRenderNightColor(Integer renderNightColor) {
        this.renderNightColor = renderNightColor;
    }

    public Integer getRenderCaveColor() {
        return this.renderCaveColor;
    }

    public void setRenderCaveColor(Integer renderCaveColor) {
        this.renderCaveColor = renderCaveColor;
    }

    public int getLightAttenuation() {
        return this.lightAttenuation;
    }

    public void setLightAttenuation(int lightAttenuation) {
        this.lightAttenuation = lightAttenuation;
    }

    public boolean isBlocksFound() {
        return this.blocksFound;
    }

    public void setBlocksFound(boolean blocksFound) {
        this.blocksFound = blocksFound;
    }
}

