/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import modinfo.ModInfo;
import net.minecraft.client.Minecraft;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.Version;
import net.techbrew.journeymap.cartography.ChunkRenderController;
import net.techbrew.journeymap.cartography.ColorCache;
import net.techbrew.journeymap.common.CommonProxy;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.data.WaypointsData;
import net.techbrew.journeymap.feature.FeatureManager;
import net.techbrew.journeymap.forge.event.EventHandlerManager;
import net.techbrew.journeymap.forge.event.WorldInfoHandler;
import net.techbrew.journeymap.io.FileHandler;
import net.techbrew.journeymap.io.IconSetFileHandler;
import net.techbrew.journeymap.io.ThemeFileHandler;
import net.techbrew.journeymap.io.migrate.Migration;
import net.techbrew.journeymap.log.ChatLog;
import net.techbrew.journeymap.log.JMLogger;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.log.StatTimer;
import net.techbrew.journeymap.properties.CoreProperties;
import net.techbrew.journeymap.properties.FullMapProperties;
import net.techbrew.journeymap.properties.MiniMapProperties;
import net.techbrew.journeymap.properties.MiniMapProperties2;
import net.techbrew.journeymap.properties.PropertiesBase;
import net.techbrew.journeymap.properties.WaypointProperties;
import net.techbrew.journeymap.properties.WebMapProperties;
import net.techbrew.journeymap.render.map.TileDrawStepCache;
import net.techbrew.journeymap.server.JMServer;
import net.techbrew.journeymap.task.main.IMainThreadTask;
import net.techbrew.journeymap.task.main.MainTaskController;
import net.techbrew.journeymap.task.main.MappingMonitorTask;
import net.techbrew.journeymap.task.multi.ITaskManager;
import net.techbrew.journeymap.task.multi.TaskController;
import net.techbrew.journeymap.ui.UIManager;
import net.techbrew.journeymap.ui.fullscreen.Fullscreen;
import net.techbrew.journeymap.waypoint.WaypointStore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class JourneyMap
implements CommonProxy {
    public static final String WEBSITE_URL = "http://journeymap.info/";
    public static final String DOWNLOAD_URL = "http://journeymap.info/download";
    public static final Version JM_VERSION = Version.from("5", "1", "0", "", new Version(5, 1, 0, "dev"));
    public static final String FORGE_VERSION = "10.13.2.1291";
    public static final String EDITION = JourneyMap.getEdition();
    public static final String MOD_NAME = "JourneyMap " + EDITION;
    public static final String VERSION_URL = "https://dl.dropboxusercontent.com/u/38077766/JourneyMap/journeymap-versions.json";
    private static JourneyMap INSTANCE;
    public ModInfo modInfo;
    private volatile CoreProperties coreProperties;
    private volatile FullMapProperties fullMapProperties;
    private volatile MiniMapProperties miniMapProperties1;
    private volatile MiniMapProperties2 miniMapProperties2;
    private volatile WebMapProperties webMapProperties;
    private volatile WaypointProperties waypointProperties;
    private volatile Boolean initialized = false;
    private volatile String currentWorldId = null;
    private Logger logger;
    private boolean threadLogging = false;
    private String playerName;
    private TaskController multithreadTaskController;
    private ChunkRenderController chunkRenderController;
    private volatile MainTaskController mainThreadTaskController;
    private volatile Minecraft mc;

    public JourneyMap() {
        if (INSTANCE != null) {
            throw new IllegalArgumentException("Use instance() after initialization is complete");
        }
        INSTANCE = this;
    }

    public static JourneyMap getInstance() {
        return INSTANCE;
    }

    private static String getEdition() {
        String ed = null;
        try {
            ed = JM_VERSION + " " + FeatureManager.getPolicySetName();
        }
        catch (Throwable t) {
            ed = JM_VERSION + " ?";
            t.printStackTrace(System.err);
        }
        return ed;
    }

    public static Logger getLogger() {
        return LogManager.getLogger((String)"journeymap");
    }

    public static CoreProperties getCoreProperties() {
        return JourneyMap.INSTANCE.coreProperties;
    }

    public static FullMapProperties getFullMapProperties() {
        return JourneyMap.INSTANCE.fullMapProperties;
    }

    public static void disable() {
        JourneyMap.INSTANCE.initialized = false;
        EventHandlerManager.unregisterAll();
        INSTANCE.stopMapping();
        DataCache.instance().purge();
    }

    public static MiniMapProperties getMiniMapProperties(int which) {
        switch (which) {
            case 2: {
                JourneyMap.INSTANCE.miniMapProperties2.setActive(true);
                JourneyMap.INSTANCE.miniMapProperties1.setActive(false);
                return JourneyMap.getMiniMapProperties2();
            }
        }
        JourneyMap.INSTANCE.miniMapProperties1.setActive(true);
        JourneyMap.INSTANCE.miniMapProperties2.setActive(false);
        return JourneyMap.getMiniMapProperties1();
    }

    public static int getActiveMinimapId() {
        if (JourneyMap.INSTANCE.miniMapProperties1.isActive()) {
            return 1;
        }
        return 2;
    }

    public static MiniMapProperties getMiniMapProperties1() {
        return JourneyMap.INSTANCE.miniMapProperties1;
    }

    public static MiniMapProperties getMiniMapProperties2() {
        return JourneyMap.INSTANCE.miniMapProperties2;
    }

    public static WebMapProperties getWebMapProperties() {
        return JourneyMap.INSTANCE.webMapProperties;
    }

    public static WaypointProperties getWaypointProperties() {
        return JourneyMap.INSTANCE.waypointProperties;
    }

    public Boolean isInitialized() {
        return this.initialized;
    }

    public Boolean isMapping() {
        return this.initialized != false && this.multithreadTaskController != null && this.multithreadTaskController.isMapping() != false;
    }

    public Boolean isThreadLogging() {
        return this.threadLogging;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initialize(FMLInitializationEvent event) throws Throwable {
        StatTimer timer = null;
        try {
            timer = StatTimer.getDisposable("elapsed").start();
            boolean migrationOk = new Migration().performTasks();
            this.logger = JMLogger.init();
            this.logger.info("ensureCurrent ENTER");
            if (this.initialized.booleanValue()) {
                this.logger.warn("Already initialized, aborting");
                return;
            }
            this.modInfo = new ModInfo("UA-28839029-4", "en_US", "journeymap", MOD_NAME, JourneyMap.getEdition());
            EntityRegistry.instance();
            this.loadConfigProperties();
            JMLogger.logProperties();
            this.threadLogging = false;
            this.logger.info("ensureCurrent EXIT, " + (timer == null ? "" : timer.stopAndReport()));
        }
        catch (Throwable t) {
            if (this.logger == null) {
                this.logger = LogManager.getLogger((String)"journeymap");
            }
            this.logger.error(LogFormatter.toString(t));
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SideOnly(value=Side.CLIENT)
    public void postInitialize(FMLPostInitializationEvent event) {
        StatTimer timer = null;
        try {
            this.logger.info("postInitialize ENTER");
            timer = StatTimer.getDisposable("elapsed").start();
            this.mc = FMLClientHandler.instance().getClient();
            this.mainThreadTaskController = new MainTaskController(this.mc, this);
            this.mainThreadTaskController.addTask(new MappingMonitorTask());
            EventHandlerManager.registerGeneralHandlers();
            EventHandlerManager.registerGuiHandlers();
            WaypointsData.enableRecheck();
            IconSetFileHandler.initialize();
            ThemeFileHandler.initialize();
            JMServer.setEnabled(this.webMapProperties.enabled.get(), false);
            this.initialized = true;
            this.logger.info("postInitialize EXIT, " + (timer == null ? "" : timer.stopAndReport()));
        }
        catch (Throwable t) {
            try {
                if (this.logger == null) {
                    this.logger = LogManager.getLogger((String)"journeymap");
                }
                this.logger.error(LogFormatter.toString(t));
                this.logger.info("postInitialize EXIT, " + (timer == null ? "" : timer.stopAndReport()));
            }
            catch (Throwable throwable) {
                this.logger.info("postInitialize EXIT, " + (timer == null ? "" : timer.stopAndReport()));
                throw throwable;
            }
        }
        JMLogger.setLevelFromProperties();
    }

    public JMServer getJmServer() {
        return JMServer.getInstance();
    }

    public void toggleTask(Class<? extends ITaskManager> managerClass, boolean enable, Object params) {
        if (this.multithreadTaskController != null) {
            this.multithreadTaskController.toggleTask(managerClass, enable, params);
        }
    }

    public boolean isTaskManagerEnabled(Class<? extends ITaskManager> managerClass) {
        if (this.multithreadTaskController != null) {
            return this.multithreadTaskController.isTaskManagerEnabled(managerClass);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMapping() {
        JourneyMap journeyMap = this;
        synchronized (journeyMap) {
            boolean created;
            File worldDir;
            if (this.mc == null || this.mc.field_71441_e == null || !this.initialized.booleanValue() || !this.coreProperties.mappingEnabled.get()) {
                return;
            }
            if (this.modInfo != null) {
                this.modInfo.reportAppView();
            }
            if (!(worldDir = FileHandler.getJMWorldDir(this.mc, this.currentWorldId)).exists() && !(created = worldDir.mkdirs())) {
                JMLogger.logOnce("CANNOT CREATE DATA DIRECTORY FOR WORLD: " + worldDir.getPath(), null);
                return;
            }
            this.reset();
            ColorCache.instance().ensureCurrent();
            this.multithreadTaskController = new TaskController();
            this.multithreadTaskController.enableTasks();
            long totalMB = Runtime.getRuntime().totalMemory() / 1024L / 1024L;
            long freeMB = Runtime.getRuntime().freeMemory() / 1024L / 1024L;
            String memory = String.format("Memory: %sMB total, %sMB free", totalMB, freeMB);
            this.logger.info(String.format("Mapping started in %s%sDIM%s. %s ", FileHandler.getJMWorldDir(this.mc, this.currentWorldId), File.separator, this.mc.field_71441_e.field_73011_w.field_76574_g, memory));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMapping() {
        JourneyMap journeyMap = this;
        synchronized (journeyMap) {
            if (this.isMapping().booleanValue() && this.mc != null) {
                String dim = ".";
                if (this.mc.field_71441_e != null && this.mc.field_71441_e.field_73011_w != null) {
                    dim = " dimension " + this.mc.field_71441_e.field_73011_w.field_76574_g + ".";
                }
                this.logger.info(String.format("Mapping halted in %s%sDIM%s", FileHandler.getJMWorldDir(this.mc, this.currentWorldId), File.separator, this.mc.field_71441_e.field_73011_w.field_76574_g));
            }
            if (this.multithreadTaskController != null) {
                this.multithreadTaskController.disableTasks();
                this.multithreadTaskController.clear();
                this.multithreadTaskController = null;
            }
        }
    }

    private void reset() {
        if (this.mc != null && this.mc.field_71439_g != null) {
            this.playerName = this.mc.field_71439_g.func_70005_c_();
        }
        if (!this.mc.func_71356_B() && this.currentWorldId == null) {
            WorldInfoHandler.requestWorldID();
        }
        this.loadConfigProperties();
        DataCache.instance().purge();
        this.chunkRenderController = new ChunkRenderController();
        Fullscreen.state().requireRefresh();
        Fullscreen.state().follow.set(true);
        StatTimer.resetAll();
        TileDrawStepCache.clear();
        UIManager.getInstance().getMiniMap().reset();
        UIManager.getInstance().reset();
        WaypointStore.instance().reset();
    }

    public void queueMainThreadTask(IMainThreadTask task) {
        this.mainThreadTaskController.addTask(task);
    }

    public void performMainThreadTasks() {
        try {
            this.mainThreadTaskController.performTasks();
        }
        catch (Throwable t) {
            String error = "Error in JourneyMap.performMainThreadTasks(): " + t.getMessage();
            ChatLog.announceError(error);
            this.logger.error(LogFormatter.toString(t));
        }
    }

    public void performMultithreadTasks() {
        try {
            if (this.isMapping().booleanValue()) {
                this.multithreadTaskController.performTasks();
            }
        }
        catch (Throwable t) {
            String error = "Error in JourneyMap.performMultithreadTasks(): " + t.getMessage();
            ChatLog.announceError(error);
            this.logger.error(LogFormatter.toString(t));
        }
    }

    public ChunkRenderController getChunkRenderController() {
        return this.chunkRenderController;
    }

    public void loadConfigProperties() {
        this.coreProperties = PropertiesBase.reload(this.coreProperties, CoreProperties.class);
        this.fullMapProperties = PropertiesBase.reload(this.fullMapProperties, FullMapProperties.class);
        this.miniMapProperties1 = PropertiesBase.reload(this.miniMapProperties1, MiniMapProperties.class);
        this.miniMapProperties2 = PropertiesBase.reload(this.miniMapProperties2, MiniMapProperties2.class);
        this.webMapProperties = PropertiesBase.reload(this.webMapProperties, WebMapProperties.class);
        this.waypointProperties = PropertiesBase.reload(this.waypointProperties, WaypointProperties.class);
    }

    public String getCurrentWorldId() {
        return this.currentWorldId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentWorldId(String worldId) {
        JourneyMap journeyMap = this;
        synchronized (journeyMap) {
            boolean directoryUnchanged;
            File currentWorldDirectory = FileHandler.getJMWorldDirForWorldId(this.mc, this.currentWorldId);
            File newWorldDirectory = FileHandler.getJMWorldDir(this.mc, worldId);
            boolean worldIdUnchanged = Constants.safeEqual(worldId, this.currentWorldId);
            boolean bl = directoryUnchanged = currentWorldDirectory != null && newWorldDirectory != null && currentWorldDirectory.getPath().equals(newWorldDirectory.getPath());
            if (worldIdUnchanged && directoryUnchanged && worldId != null) {
                JourneyMap.getLogger().info("World UID hasn't changed: " + worldId);
                return;
            }
            boolean wasMapping = this.isMapping();
            if (wasMapping) {
                this.stopMapping();
            }
            this.currentWorldId = worldId;
            JourneyMap.getLogger().info("World UID is set to: " + worldId);
        }
    }

    public String getPlayerName() {
        return this.playerName;
    }
}

