/*
 * Decompiled with CFR 0.152.
 */
package tennox.keyandcodelock.connection;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayerMP;
import tennox.keyandcodelock.GuiNameKey;
import tennox.keyandcodelock.IKeyAndCodeLockPacket;
import tennox.keyandcodelock.KeyAndCodeLock;

public class PacketKeyNameAnswer
implements IKeyAndCodeLockPacket {
    int x;
    int y;
    int z;
    String name;
    int hash;
    boolean answer;

    public PacketKeyNameAnswer() {
    }

    public PacketKeyNameAnswer(int x, int y, int z, String name, int hash, boolean answer) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.name = name;
        this.hash = hash;
        this.answer = answer;
    }

    @Override
    public void writeBytes(ByteBuf buffer) {
        KeyAndCodeLock.debug("Writing PacketKeyNameAnswer... " + this.x + "," + this.y + "," + this.z + "_" + this.name + "_" + this.hash + "_" + this.answer);
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeShort(this.name.length());
        for (int i = 0; i < this.name.length(); ++i) {
            buffer.writeChar((int)Character.valueOf(this.name.charAt(i)).charValue());
        }
        buffer.writeInt(this.hash);
        buffer.writeBoolean(this.answer);
    }

    @Override
    public void readBytes(ByteBuf buffer) {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        int l = buffer.readShort();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < l; ++i) {
            builder.append(buffer.readChar());
        }
        this.name = builder.toString();
        this.hash = buffer.readInt();
        this.answer = buffer.readBoolean();
        KeyAndCodeLock.debug("Read PacketKeyNameAnswer: " + this.x + "," + this.y + "," + this.z + "_" + this.name + "_" + this.hash + "_" + this.answer);
    }

    @Override
    public void executeServer(EntityPlayerMP player) {
    }

    @Override
    public void executeClient() {
        if (this.name == null || this.name.length() == 0 || this.hash <= 0) {
            KeyAndCodeLock.logger.warn("Recieved KeyNameAnswer with wrong data!");
            return;
        }
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui != null && gui instanceof GuiNameKey) {
            GuiNameKey guikey = (GuiNameKey)gui;
            guikey.onPacketAnswer(this.name, this.hash, this.answer);
        } else {
            KeyAndCodeLock.logger.warn("KeyNameChangeAnswer received but no gui?!");
        }
        if (this.answer) {
            KeyAndCodeLock.debug("KeyNameChange was accepted by the Server!");
        } else {
            KeyAndCodeLock.debug("KeyNameChange was denied by the Server!");
        }
    }
}

