/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.scripted.roles;

import foxz.utils.Market;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleTrader;
import noppes.npcs.scripted.NpcAPI;
import noppes.npcs.scripted.interfaces.entity.IPlayer;
import noppes.npcs.scripted.interfaces.item.IItemStack;
import noppes.npcs.scripted.interfaces.roles.IRoleTrader;
import noppes.npcs.scripted.roles.ScriptRoleInterface;

public class ScriptRoleTrader
extends ScriptRoleInterface
implements IRoleTrader {
    private RoleTrader role;

    public ScriptRoleTrader(EntityNPCInterface npc) {
        super(npc);
        this.role = (RoleTrader)npc.roleInterface;
    }

    @Override
    public void setSellOption(int slot, IItemStack currency, IItemStack currency2, IItemStack sold) {
        if (sold == null || slot >= 18 || slot < 0) {
            return;
        }
        if (currency == null) {
            currency = currency2;
        }
        if (currency != null) {
            this.role.inventoryCurrency.items.put(slot, currency.getMCItemStack());
        } else {
            this.role.inventoryCurrency.items.remove(slot);
        }
        if (currency2 != null) {
            this.role.inventoryCurrency.items.put(slot + 18, currency2.getMCItemStack());
        } else {
            this.role.inventoryCurrency.items.remove(slot + 18);
        }
        this.role.inventorySold.items.put(slot, sold.getMCItemStack());
    }

    @Override
    public void setSellOption(int slot, IItemStack currency, IItemStack sold) {
        this.setSellOption(slot, currency, null, sold);
    }

    @Override
    public IItemStack getSellOption(int slot) {
        if (slot >= 18 || slot < 0) {
            return null;
        }
        if (this.role.inventorySold.items.get(slot) == null) {
            return null;
        }
        return NpcAPI.Instance().getIItemStack(this.role.inventoryCurrency.items.get(slot));
    }

    @Override
    public IItemStack[] getCurrency(int slot) {
        if (slot >= 18 || slot < 0) {
            return null;
        }
        IItemStack[] currency = new IItemStack[2];
        if (this.role.inventoryCurrency.items.get(slot) != null) {
            currency[0] = NpcAPI.Instance().getIItemStack(this.role.inventoryCurrency.items.get(slot));
        }
        if (this.role.inventoryCurrency.items.get(slot + 18) != null) {
            currency[1] = NpcAPI.Instance().getIItemStack(this.role.inventoryCurrency.items.get(slot + 18));
        }
        return currency;
    }

    @Override
    public void removeSellOption(int slot) {
        if (slot >= 18 || slot < 0) {
            return;
        }
        this.role.inventoryCurrency.items.remove(slot);
        this.role.inventoryCurrency.items.remove(slot + 18);
        this.role.inventorySold.items.remove(slot);
    }

    @Override
    public void setMarket(String name) {
        this.role.marketName = name;
        Market.load(this.role, name);
    }

    @Override
    public String getMarket() {
        return this.role.marketName;
    }

    @Override
    public int getPurchaseNum(int slot) {
        if (slot >= 18 || slot < 0) {
            return -1;
        }
        return this.role.purchases[slot];
    }

    @Override
    public int getPurchaseNum(int slot, IPlayer player) {
        if (slot >= 18 || slot < 0) {
            return -1;
        }
        return this.role.getArrayByName(player.getDisplayName(), this.role.playerPurchases)[slot];
    }

    @Override
    public void resetPurchaseNum() {
        for (int i = 0; i < this.role.purchases.length; ++i) {
            this.role.purchases[i] = 0;
        }
    }

    @Override
    public void resetPurchaseNum(int slot) {
        if (slot >= 18 || slot < 0) {
            return;
        }
        this.role.purchases[slot] = 0;
    }

    @Override
    public void resetPurchaseNum(int slot, IPlayer player) {
        if (slot >= 18 || slot < 0) {
            return;
        }
        this.role.getArrayByName((String)player.getDisplayName(), this.role.playerPurchases)[slot] = 0;
    }

    @Override
    public boolean isSlotEnabled(int slot) {
        if (slot >= 18 || slot < 0) {
            return false;
        }
        return this.role.disableSlot[slot] > 0;
    }

    @Override
    public boolean isSlotEnabled(int slot, IPlayer player) {
        if (slot >= 18 || slot < 0) {
            return false;
        }
        return this.role.isSlotEnabled(slot, player.getDisplayName());
    }

    @Override
    public void disableSlot(int slot) {
        if (slot >= 18 || slot < 0) {
            return;
        }
        this.role.disableSlot[slot] = 1;
    }

    @Override
    public void disableSlot(int slot, IPlayer player) {
        if (slot >= 18 || slot < 0) {
            return;
        }
        this.role.getArrayByName((String)player.getDisplayName(), this.role.playerDisableSlot)[slot] = 1;
    }

    @Override
    public void enableSlot(int slot) {
        if (slot >= 18 || slot < 0) {
            return;
        }
        this.role.disableSlot[slot] = 0;
    }

    @Override
    public void enableSlot(int slot, IPlayer player) {
        if (slot >= 18 || slot < 0) {
            return;
        }
        this.role.getArrayByName((String)player.getDisplayName(), this.role.playerDisableSlot)[slot] = 0;
    }

    @Override
    public int getType() {
        return 2;
    }
}

