/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import foxz.utils.Market;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleInterface;

public class RoleTrader
extends RoleInterface {
    public String marketName = "";
    public NpcMiscInventory inventoryCurrency = new NpcMiscInventory(36);
    public NpcMiscInventory inventorySold = new NpcMiscInventory(18);
    public boolean ignoreDamage = false;
    public boolean ignoreNBT = false;
    public boolean toSave = false;
    public int[] purchases = new int[18];
    public int[] disableSlot = new int[18];
    public HashMap<String, int[]> playerPurchases = new HashMap();
    public HashMap<String, int[]> playerDisableSlot = new HashMap();

    public RoleTrader(EntityNPCInterface npc) {
        super(npc);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74778_a("TraderMarket", this.marketName);
        this.writeNBT(nbttagcompound);
        if (this.toSave && !this.npc.isRemote()) {
            Market.save(this, this.marketName);
        }
        this.toSave = false;
        return nbttagcompound;
    }

    public NBTTagCompound writeNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74782_a("TraderCurrency", (NBTBase)this.inventoryCurrency.getToNBT());
        nbttagcompound.func_74782_a("TraderSold", (NBTBase)this.inventorySold.getToNBT());
        nbttagcompound.func_74757_a("TraderIgnoreDamage", this.ignoreDamage);
        nbttagcompound.func_74757_a("TraderIgnoreNBT", this.ignoreNBT);
        nbttagcompound.func_74783_a("Purchases", this.purchases);
        nbttagcompound.func_74783_a("DisableSlot", this.disableSlot);
        nbttagcompound.func_74782_a("PlayerPurchases", (NBTBase)NBTTags.nbtStringIntegerArrayMap(this.playerPurchases));
        nbttagcompound.func_74782_a("PlayerDisableSlot", (NBTBase)NBTTags.nbtStringIntegerArrayMap(this.playerDisableSlot));
        return nbttagcompound;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.marketName = nbttagcompound.func_74779_i("TraderMarket");
        this.readNBT(nbttagcompound);
        try {
            Market.load(this, this.marketName);
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void readNBT(NBTTagCompound nbttagcompound) {
        int i;
        this.inventoryCurrency.setFromNBT(nbttagcompound.func_74775_l("TraderCurrency"));
        this.inventorySold.setFromNBT(nbttagcompound.func_74775_l("TraderSold"));
        this.ignoreDamage = nbttagcompound.func_74767_n("TraderIgnoreDamage");
        this.ignoreNBT = nbttagcompound.func_74767_n("TraderIgnoreNBT");
        this.purchases = nbttagcompound.func_74759_k("Purchases");
        if (this.purchases == null || this.purchases.length != 18) {
            this.purchases = new int[18];
            for (i = 0; i < this.purchases.length; ++i) {
                this.purchases[i] = 0;
            }
        }
        this.disableSlot = nbttagcompound.func_74759_k("DisableSlot");
        if (this.disableSlot == null || this.disableSlot.length != 18) {
            this.disableSlot = new int[18];
            for (i = 0; i < this.disableSlot.length; ++i) {
                this.disableSlot[i] = 0;
            }
        }
        this.playerPurchases = NBTTags.getStringIntegerArrayMap(nbttagcompound.func_150295_c("PlayerPurchases", 10), 18);
        this.playerDisableSlot = NBTTags.getStringIntegerArrayMap(nbttagcompound.func_150295_c("PlayerDisableSlot", 10), 18);
    }

    @Override
    public void interact(EntityPlayer player) {
        this.npc.say(player, this.npc.advanced.getInteractLine());
        try {
            Market.load(this, this.marketName);
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
        NoppesUtilServer.sendOpenGui(player, EnumGuiType.PlayerTrader, this.npc);
    }

    public boolean hasCurrency(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        for (ItemStack item : this.inventoryCurrency.items.values()) {
            if (item == null || !NoppesUtilPlayer.compareItems(item, itemstack, this.ignoreDamage, this.ignoreNBT)) continue;
            return true;
        }
        return false;
    }

    public void addPurchase(int slot, String playerName) {
        if (slot >= 18 || slot < 0) {
            return;
        }
        int n = slot;
        this.purchases[n] = this.purchases[n] + 1;
        int[] nArray = this.getArrayByName(playerName, this.playerPurchases);
        int n2 = slot;
        nArray[n2] = nArray[n2] + 1;
    }

    public boolean isSlotEnabled(int slot, String playerName) {
        if (slot >= 18 || slot < 0) {
            return false;
        }
        if (this.disableSlot[slot] > 0) {
            return false;
        }
        return this.getArrayByName(playerName, this.playerDisableSlot)[slot] <= 0;
    }

    public int[] getArrayByName(String name, HashMap<String, int[]> map) {
        map.computeIfAbsent(name, k -> new int[18]);
        return map.get(name);
    }
}

