/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import noppes.npcs.NBTTags;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.scripted.CustomNPCsException;
import noppes.npcs.scripted.NpcAPI;
import noppes.npcs.scripted.interfaces.IWorld;
import noppes.npcs.scripted.interfaces.entity.IEntity;
import noppes.npcs.scripted.interfaces.handler.data.INaturalSpawn;

public class SpawnData
extends WeightedRandom.Item
implements INaturalSpawn {
    public List<String> biomes = new ArrayList<String>();
    public int id = -1;
    public String name = "";
    public NBTTagCompound compound1 = new NBTTagCompound();
    public NBTTagCompound compound2 = new NBTTagCompound();
    public NBTTagCompound compound3 = new NBTTagCompound();
    public NBTTagCompound compound4 = new NBTTagCompound();
    public NBTTagCompound compound5 = new NBTTagCompound();
    public boolean animalSpawning = true;
    public boolean monsterSpawning = false;
    public boolean liquidSpawning = false;
    public boolean airSpawning = false;
    public int spawnHeightMin;
    public int spawnHeightMax;

    public SpawnData() {
        super(10);
    }

    public void readNBT(NBTTagCompound compound) {
        this.id = compound.func_74762_e("SpawnId");
        this.name = compound.func_74779_i("SpawnName");
        this.field_76292_a = compound.func_74762_e("SpawnWeight");
        if (this.field_76292_a == 0) {
            this.field_76292_a = 1;
        }
        this.biomes = NBTTags.getStringList(compound.func_150295_c("SpawnBiomes", 10));
        this.compound1 = compound.func_74775_l("SpawnCompound1");
        this.compound2 = compound.func_74775_l("SpawnCompound2");
        this.compound3 = compound.func_74775_l("SpawnCompound3");
        this.compound4 = compound.func_74775_l("SpawnCompound4");
        this.compound5 = compound.func_74775_l("SpawnCompound5");
        this.animalSpawning = compound.func_74767_n("AnimalSpawning");
        this.monsterSpawning = compound.func_74767_n("MonsterSpawning");
        this.liquidSpawning = compound.func_74767_n("LiquidSpawning");
        this.airSpawning = compound.func_74767_n("CaveSpawning");
        this.spawnHeightMin = compound.func_74762_e("HeightMin");
        this.spawnHeightMax = compound.func_74764_b("HeightMax") ? 100 : compound.func_74762_e("HeightMax");
    }

    public NBTTagCompound writeNBT(NBTTagCompound compound) {
        compound.func_74768_a("SpawnId", this.id);
        compound.func_74778_a("SpawnName", this.name);
        compound.func_74768_a("SpawnWeight", this.field_76292_a);
        compound.func_74782_a("SpawnBiomes", (NBTBase)NBTTags.nbtStringList(this.biomes));
        compound.func_74782_a("SpawnCompound1", (NBTBase)this.compound1);
        compound.func_74782_a("SpawnCompound2", (NBTBase)this.compound2);
        compound.func_74782_a("SpawnCompound3", (NBTBase)this.compound3);
        compound.func_74782_a("SpawnCompound4", (NBTBase)this.compound4);
        compound.func_74782_a("SpawnCompound5", (NBTBase)this.compound5);
        compound.func_74757_a("AnimalSpawning", this.animalSpawning);
        compound.func_74757_a("MonsterSpawning", this.monsterSpawning);
        compound.func_74757_a("LiquidSpawning", this.liquidSpawning);
        compound.func_74757_a("CaveSpawning", this.airSpawning);
        compound.func_74768_a("HeightMin", this.spawnHeightMin);
        compound.func_74768_a("HeightMax", this.spawnHeightMax);
        return compound;
    }

    @Override
    public void setName(String name) {
        if (name != null && !name.isEmpty()) {
            this.name = name;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setEntity(IEntity entity, int slot) {
        if (slot < 1) {
            slot = 1;
        }
        if (slot > 5) {
            slot = 5;
        }
        NBTTagCompound compound = new NBTTagCompound();
        if (!entity.getMCEntity().func_70039_c(compound)) {
            throw new CustomNPCsException("Entity could not be written to NBT", new Object[0]);
        }
        switch (slot) {
            case 1: {
                ServerCloneController.Instance.cleanTags(this.compound1);
                this.compound1 = compound;
                break;
            }
            case 2: {
                ServerCloneController.Instance.cleanTags(this.compound2);
                this.compound2 = compound;
                break;
            }
            case 3: {
                ServerCloneController.Instance.cleanTags(this.compound3);
                this.compound3 = compound;
                break;
            }
            case 4: {
                ServerCloneController.Instance.cleanTags(this.compound4);
                this.compound4 = compound;
                break;
            }
            case 5: {
                ServerCloneController.Instance.cleanTags(this.compound5);
                this.compound5 = compound;
            }
        }
    }

    @Override
    public IEntity getEntity(IWorld world, int slot) {
        if (slot < 1) {
            slot = 1;
        }
        if (slot > 5) {
            slot = 5;
        }
        try {
            NBTTagCompound compound = new NBTTagCompound();
            switch (slot) {
                case 1: {
                    compound = this.compound1;
                    break;
                }
                case 2: {
                    compound = this.compound2;
                    break;
                }
                case 3: {
                    compound = this.compound3;
                    break;
                }
                case 4: {
                    compound = this.compound4;
                    break;
                }
                case 5: {
                    compound = this.compound5;
                }
            }
            Entity entity = EntityList.func_75615_a((NBTTagCompound)compound, (World)world.getMCWorld());
            return NpcAPI.Instance().getIEntity(entity);
        }
        catch (Exception e) {
            throw new CustomNPCsException("Error creating entity from spawn data:\n" + e.getMessage(), new Object[0]);
        }
    }

    @Override
    public void setWeight(int weight) {
        if (weight < 1) {
            weight = 1;
        }
        if (weight > 100) {
            weight = 100;
        }
        this.field_76292_a = weight;
    }

    @Override
    public int getWeight() {
        return this.field_76292_a;
    }

    @Override
    public void setMinHeight(int height) {
        this.spawnHeightMin = height;
    }

    @Override
    public int getMinHeight() {
        return this.spawnHeightMin;
    }

    @Override
    public void setMaxHeight(int height) {
        this.spawnHeightMax = height;
    }

    @Override
    public int getMaxHeight() {
        return this.spawnHeightMax;
    }

    @Override
    public void spawnsLikeAnimal(boolean spawns) {
        this.animalSpawning = spawns;
    }

    @Override
    public boolean spawnsLikeAnimal() {
        return this.animalSpawning;
    }

    @Override
    public void spawnsLikeMonster(boolean spawns) {
        this.monsterSpawning = spawns;
    }

    @Override
    public boolean spawnsLikeMonster() {
        return this.monsterSpawning;
    }

    @Override
    public void spawnsInLiquid(boolean spawns) {
        this.liquidSpawning = spawns;
    }

    @Override
    public boolean spawnsInLiquid() {
        return this.liquidSpawning;
    }

    @Override
    public void spawnsInAir(boolean spawns) {
        this.airSpawning = spawns;
    }

    @Override
    public boolean spawnsInAir() {
        return this.airSpawning;
    }

    @Override
    public String[] getBiomes() {
        return this.biomes.toArray(new String[0]);
    }

    @Override
    public void setBiomes(String[] biomes) {
        this.biomes = new ArrayList<String>(Arrays.asList(biomes));
    }
}

