/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.NBTTags;
import noppes.npcs.controllers.GlobalDataController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.roles.JobItemGiver;
import noppes.npcs.scripted.interfaces.handler.IPlayerItemGiverData;
import noppes.npcs.scripted.interfaces.jobs.IJobItemGiver;
import noppes.npcs.scripted.roles.ScriptJobItemGiver;

public class PlayerItemGiverData
implements IPlayerItemGiverData {
    private final PlayerData parent;
    private HashMap<Integer, Long> itemgivers = new HashMap();
    private HashMap<Integer, Integer> chained = new HashMap();

    public PlayerItemGiverData(PlayerData parent) {
        this.parent = parent;
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.chained = NBTTags.getIntegerIntegerMap(compound.func_150295_c("ItemGiverChained", 10));
        this.itemgivers = NBTTags.getIntegerLongMap(compound.func_150295_c("ItemGiversList", 10));
    }

    public void saveNBTData(NBTTagCompound compound) {
        compound.func_74782_a("ItemGiverChained", (NBTBase)NBTTags.nbtIntegerIntegerMap(this.chained));
        compound.func_74782_a("ItemGiversList", (NBTBase)NBTTags.nbtIntegerLongMap(this.itemgivers));
    }

    public boolean hasInteractedBefore(JobItemGiver jobItemGiver) {
        return this.itemgivers.containsKey(jobItemGiver.itemGiverId);
    }

    public long getTime(JobItemGiver jobItemGiver) {
        return this.itemgivers.get(jobItemGiver.itemGiverId);
    }

    public void setTime(JobItemGiver jobItemGiver, long day) {
        this.itemgivers.put(jobItemGiver.itemGiverId, day);
    }

    public int getItemIndex(JobItemGiver jobItemGiver) {
        if (this.chained.containsKey(jobItemGiver.itemGiverId)) {
            return this.chained.get(jobItemGiver.itemGiverId);
        }
        return 0;
    }

    public void setItemIndex(JobItemGiver jobItemGiver, int i) {
        this.chained.put(jobItemGiver.itemGiverId, i);
    }

    @Override
    public long getTime(IJobItemGiver jobItemGiver) {
        return this.itemgivers.get(((JobItemGiver)jobItemGiver.getJobInterface()).itemGiverId);
    }

    @Override
    public void setTime(IJobItemGiver jobItemGiver, long day) {
        this.itemgivers.put(((JobItemGiver)jobItemGiver.getJobInterface()).itemGiverId, day);
    }

    @Override
    public boolean hasInteractedBefore(IJobItemGiver jobItemGiver) {
        return this.itemgivers.containsKey(((JobItemGiver)jobItemGiver.getJobInterface()).itemGiverId);
    }

    @Override
    public IJobItemGiver[] getItemGivers() {
        ArrayList<ScriptJobItemGiver> list = new ArrayList<ScriptJobItemGiver>();
        for (JobItemGiver jobItemGiver : GlobalDataController.instance.itemGivers.values()) {
            if (jobItemGiver.npc != null) {
                list.add(new ScriptJobItemGiver(jobItemGiver.npc));
                continue;
            }
            list.add(new ScriptJobItemGiver(jobItemGiver));
        }
        return list.toArray(new IJobItemGiver[0]);
    }
}

