/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai.pathfinder;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import noppes.npcs.ai.pathfinder.FlyPathEntity;
import noppes.npcs.ai.pathfinder.FlyPathFinder;
import noppes.npcs.entity.EntityNPCInterface;

public class PathNavigateFlying
extends PathNavigate {
    private EntityNPCInterface theEntity;
    private World worldObj;
    private FlyPathEntity currentPath;
    private double speed;
    private IAttributeInstance pathSearchRange;
    private boolean noSunPathfind;
    private int totalTicks;
    private int ticksAtLastPos;
    private Vec3 lastPosCheck = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    private boolean canPassOpenWoodenDoors = true;
    private boolean canPassClosedWoodenDoors;
    private boolean avoidsWater;
    private boolean canSwim;
    private static final String __OBFID = "CL_00001627";

    public PathNavigateFlying(EntityLiving p_i45873_1_, World worldIn) {
        super(p_i45873_1_, worldIn);
        this.theEntity = (EntityNPCInterface)p_i45873_1_;
        this.worldObj = worldIn;
        this.pathSearchRange = p_i45873_1_.func_110148_a(SharedMonsterAttributes.field_111265_b);
    }

    public void func_75491_a(boolean p_75491_1_) {
        this.avoidsWater = p_75491_1_;
    }

    public boolean func_75486_a() {
        return this.avoidsWater;
    }

    public void func_75498_b(boolean p_75498_1_) {
        this.canPassClosedWoodenDoors = p_75498_1_;
    }

    public void func_75490_c(boolean p_75490_1_) {
        this.canPassOpenWoodenDoors = p_75490_1_;
    }

    public boolean func_75507_c() {
        return this.canPassClosedWoodenDoors;
    }

    public void func_75504_d(boolean p_75504_1_) {
        this.noSunPathfind = p_75504_1_;
    }

    public void func_75489_a(double p_75489_1_) {
        this.speed = p_75489_1_;
    }

    public void func_75495_e(boolean p_75495_1_) {
        this.canSwim = p_75495_1_;
    }

    public float func_111269_d() {
        return (float)this.pathSearchRange.func_111126_e();
    }

    public FlyPathEntity getPathToXYZ(double p_75488_1_, double p_75488_3_, double p_75488_5_) {
        return !this.canNavigate() ? null : this.getEntityPathToXYZ((Entity)this.theEntity, MathHelper.func_76128_c((double)p_75488_1_), (int)p_75488_3_, MathHelper.func_76128_c((double)p_75488_5_), this.func_111269_d(), this.canPassOpenWoodenDoors, this.canPassClosedWoodenDoors, this.avoidsWater, this.canSwim);
    }

    public boolean func_75492_a(double p_75492_1_, double p_75492_3_, double p_75492_5_, double p_75492_7_) {
        FlyPathEntity pathentity = this.getPathToXYZ(MathHelper.func_76128_c((double)p_75492_1_), (int)p_75492_3_, MathHelper.func_76128_c((double)p_75492_5_));
        return this.func_75484_a(pathentity, p_75492_7_);
    }

    public FlyPathEntity getPathToEntityLiving(Entity p_75494_1_) {
        return !this.canNavigate() ? null : this.getPathEntityToEntity((Entity)this.theEntity, p_75494_1_, this.func_111269_d(), this.canPassOpenWoodenDoors, this.canPassClosedWoodenDoors, this.avoidsWater, this.canSwim);
    }

    public boolean func_75497_a(Entity p_75497_1_, double p_75497_2_) {
        FlyPathEntity pathentity = this.getPathToEntityLiving(p_75497_1_);
        return pathentity != null && this.func_75484_a(pathentity, p_75497_2_);
    }

    public boolean func_75484_a(PathEntity pathEntity, double p_75484_2_) {
        FlyPathEntity p_75484_1_ = (FlyPathEntity)pathEntity;
        if (p_75484_1_ == null) {
            this.currentPath = null;
            return false;
        }
        if (!p_75484_1_.func_75876_a(this.currentPath)) {
            this.currentPath = p_75484_1_;
        }
        if (this.noSunPathfind) {
            this.removeSunnyPath();
        }
        if (this.currentPath.func_75874_d() == 0) {
            return false;
        }
        this.speed = p_75484_2_;
        Vec3 vec3 = this.getEntityPosition();
        this.ticksAtLastPos = this.totalTicks;
        this.lastPosCheck.field_72450_a = vec3.field_72450_a;
        this.lastPosCheck.field_72448_b = vec3.field_72448_b;
        this.lastPosCheck.field_72449_c = vec3.field_72449_c;
        return true;
    }

    public PathEntity func_75505_d() {
        return this.currentPath;
    }

    private boolean isInLiquid() {
        return this.theEntity.func_70090_H() || this.theEntity.func_70058_J();
    }

    private boolean canNavigate() {
        return !this.isInLiquid() || this.canSwim && this.isInLiquid();
    }

    public void func_75501_e() {
        ++this.totalTicks;
        if (!this.func_75500_f()) {
            Vec3 vec3;
            if (this.canNavigate()) {
                this.pathFollow();
            }
            if (!this.func_75500_f() && (vec3 = this.currentPath.func_75878_a((Entity)this.theEntity)) != null) {
                this.theEntity.func_70605_aq().func_75642_a(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, this.speed);
            }
        }
    }

    private void pathFollow() {
        int k;
        Vec3 vec3 = this.getEntityPosition();
        int i = this.currentPath.func_75874_d();
        float f = this.theEntity.field_70130_N * this.theEntity.field_70130_N;
        for (k = this.currentPath.func_75873_e(); k < i; ++k) {
            if (!(vec3.func_72436_e(this.currentPath.func_75881_a((Entity)this.theEntity, k)) < (double)f)) continue;
            this.currentPath.func_75872_c(k + 1);
        }
        k = MathHelper.func_76123_f((float)this.theEntity.field_70130_N);
        int l = (int)this.theEntity.field_70131_O + 1;
        int i1 = k;
        for (int j1 = i - 1; j1 >= this.currentPath.func_75873_e(); --j1) {
            if (!this.isDirectPathBetweenPoints(vec3, this.currentPath.func_75881_a((Entity)this.theEntity, j1), k, l, i1)) continue;
            this.currentPath.func_75872_c(j1);
            break;
        }
        if (this.totalTicks - this.ticksAtLastPos > 10) {
            if (vec3.func_72436_e(this.lastPosCheck) < 2.25) {
                this.func_75499_g();
            }
            this.ticksAtLastPos = this.totalTicks;
            this.lastPosCheck.field_72450_a = vec3.field_72450_a;
            this.lastPosCheck.field_72448_b = vec3.field_72448_b;
            this.lastPosCheck.field_72449_c = vec3.field_72449_c;
        }
    }

    public boolean func_75500_f() {
        return this.currentPath == null || this.currentPath.func_75879_b();
    }

    public void func_75499_g() {
        this.currentPath = null;
    }

    private Vec3 getEntityPosition() {
        return Vec3.func_72443_a((double)this.theEntity.field_70165_t, (double)this.getPathableYPos(), (double)this.theEntity.field_70161_v);
    }

    private double getPathableYPos() {
        return this.theEntity.field_70121_D.field_72338_b + 0.05;
    }

    private void removeSunnyPath() {
        if (!this.worldObj.func_72937_j(MathHelper.func_76128_c((double)this.theEntity.field_70165_t), (int)(this.theEntity.field_70121_D.field_72338_b + 0.5), MathHelper.func_76128_c((double)this.theEntity.field_70161_v))) {
            for (int i = 0; i < this.currentPath.func_75874_d(); ++i) {
                PathPoint pathpoint = this.currentPath.func_75877_a(i);
                if (!this.worldObj.func_72937_j(pathpoint.field_75839_a, pathpoint.field_75837_b, pathpoint.field_75838_c)) continue;
                this.currentPath.func_75871_b(i - 1);
                return;
            }
        }
    }

    private boolean isDirectPathBetweenPoints(Vec3 p_75493_1_, Vec3 p_75493_2_, int entityXSize, int entityYSize, int entityZSize) {
        int l = MathHelper.func_76128_c((double)p_75493_1_.field_72450_a);
        int i1 = MathHelper.func_76128_c((double)p_75493_1_.field_72449_c);
        double d0 = p_75493_2_.field_72450_a - p_75493_1_.field_72450_a;
        double d1 = p_75493_2_.field_72449_c - p_75493_1_.field_72449_c;
        double d2 = d0 * d0 + d1 * d1;
        if (d2 < 1.0E-8) {
            return false;
        }
        double d3 = 1.0 / Math.sqrt(d2);
        if (!this.isSafeToStandAt(l, (int)p_75493_1_.field_72448_b, i1, entityXSize += 2, entityYSize, entityZSize += 2, p_75493_1_, d0 *= d3, d1 *= d3)) {
            return false;
        }
        entityXSize -= 2;
        entityZSize -= 2;
        double d4 = 1.0 / Math.abs(d0);
        double d5 = 1.0 / Math.abs(d1);
        double d6 = (double)(l * 1) - p_75493_1_.field_72450_a;
        double d7 = (double)(i1 * 1) - p_75493_1_.field_72449_c;
        if (d0 >= 0.0) {
            d6 += 1.0;
        }
        if (d1 >= 0.0) {
            d7 += 1.0;
        }
        d6 /= d0;
        d7 /= d1;
        int j1 = d0 < 0.0 ? -1 : 1;
        int k1 = d1 < 0.0 ? -1 : 1;
        int l1 = MathHelper.func_76128_c((double)p_75493_2_.field_72450_a);
        int i2 = MathHelper.func_76128_c((double)p_75493_2_.field_72449_c);
        int j2 = l1 - l;
        int k2 = i2 - i1;
        do {
            if (j2 * j1 <= 0 && k2 * k1 <= 0) {
                return true;
            }
            if (d6 < d7) {
                d6 += d4;
                j2 = l1 - (l += j1);
                continue;
            }
            d7 += d5;
            k2 = i2 - (i1 += k1);
        } while (this.isSafeToStandAt(l, (int)p_75493_1_.field_72448_b, i1, entityXSize, entityYSize, entityZSize, p_75493_1_, d0, d1));
        return false;
    }

    private boolean isSafeToStandAt(int p_75483_1_, int p_75483_2_, int p_75483_3_, int p_75483_4_, int p_75483_5_, int p_75483_6_, Vec3 p_75483_7_, double p_75483_8_, double p_75483_10_) {
        int k1 = p_75483_1_ - p_75483_4_ / 2;
        int l1 = p_75483_3_ - p_75483_6_ / 2;
        if (!this.isPositionClear(k1, p_75483_2_, l1, p_75483_4_, p_75483_5_, p_75483_6_, p_75483_7_, p_75483_8_, p_75483_10_)) {
            return false;
        }
        for (int i2 = k1; i2 < k1 + p_75483_4_; ++i2) {
            for (int j2 = l1; j2 < l1 + p_75483_6_; ++j2) {
                double d2 = (double)i2 + 0.5 - p_75483_7_.field_72450_a;
                double d3 = (double)j2 + 0.5 - p_75483_7_.field_72449_c;
                if (!(d2 * p_75483_8_ + d3 * p_75483_10_ >= 0.0)) continue;
                Block block = this.worldObj.func_147439_a(i2, p_75483_2_ - 1, j2);
                Material material = block.func_149688_o();
                if (material == Material.field_151586_h && !this.theEntity.func_70090_H()) {
                    return false;
                }
                if (material != Material.field_151587_i) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isPositionClear(int p_75496_1_, int p_75496_2_, int p_75496_3_, int p_75496_4_, int p_75496_5_, int p_75496_6_, Vec3 p_75496_7_, double p_75496_8_, double p_75496_10_) {
        for (int k1 = p_75496_1_; k1 < p_75496_1_ + p_75496_4_; ++k1) {
            for (int l1 = p_75496_2_; l1 < p_75496_2_ + p_75496_5_; ++l1) {
                for (int i2 = p_75496_3_; i2 < p_75496_3_ + p_75496_6_; ++i2) {
                    Block block;
                    double d2 = (double)k1 + 0.5 - p_75496_7_.field_72450_a;
                    double d3 = (double)i2 + 0.5 - p_75496_7_.field_72449_c;
                    if (!(d2 * p_75496_8_ + d3 * p_75496_10_ >= 0.0) || (block = this.worldObj.func_147439_a(k1, l1, i2)).func_149655_b((IBlockAccess)this.worldObj, k1, l1, i2)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public FlyPathEntity getPathEntityToEntity(Entity p_72865_1_, Entity p_72865_2_, float p_72865_3_, boolean p_72865_4_, boolean p_72865_5_, boolean p_72865_6_, boolean p_72865_7_) {
        this.theEntity.field_70170_p.field_72984_F.func_76320_a("pathfind");
        int i = MathHelper.func_76128_c((double)p_72865_1_.field_70165_t);
        int j = MathHelper.func_76128_c((double)(p_72865_1_.field_70163_u + 1.0));
        int k = MathHelper.func_76128_c((double)p_72865_1_.field_70161_v);
        int l = (int)(p_72865_3_ + 16.0f);
        int i1 = i - l;
        int j1 = j - l;
        int k1 = k - l;
        int l1 = i + l;
        int i2 = j + l;
        int j2 = k + l;
        ChunkCache chunkcache = new ChunkCache(this.theEntity.field_70170_p, i1, j1, k1, l1, i2, j2, 0);
        FlyPathEntity pathentity = new FlyPathFinder((IBlockAccess)chunkcache, p_72865_4_, p_72865_5_, p_72865_6_, p_72865_7_).createEntityPathTo(p_72865_1_, p_72865_2_, p_72865_3_);
        this.theEntity.field_70170_p.field_72984_F.func_76319_b();
        return pathentity;
    }

    public FlyPathEntity getEntityPathToXYZ(Entity p_72844_1_, int p_72844_2_, int p_72844_3_, int p_72844_4_, float p_72844_5_, boolean p_72844_6_, boolean p_72844_7_, boolean p_72844_8_, boolean p_72844_9_) {
        this.theEntity.field_70170_p.field_72984_F.func_76320_a("pathfind");
        int l = MathHelper.func_76128_c((double)p_72844_1_.field_70165_t);
        int i1 = MathHelper.func_76128_c((double)p_72844_1_.field_70163_u);
        int j1 = MathHelper.func_76128_c((double)p_72844_1_.field_70161_v);
        int k1 = (int)(p_72844_5_ + 8.0f);
        int l1 = l - k1;
        int i2 = i1 - k1;
        int j2 = j1 - k1;
        int k2 = l + k1;
        int l2 = i1 + k1;
        int i3 = j1 + k1;
        ChunkCache chunkcache = new ChunkCache(this.theEntity.field_70170_p, l1, i2, j2, k2, l2, i3, 0);
        FlyPathEntity pathentity = new FlyPathFinder((IBlockAccess)chunkcache, p_72844_6_, p_72844_7_, p_72844_8_, p_72844_9_).createEntityPathTo(p_72844_1_, p_72844_2_, p_72844_3_, p_72844_4_, p_72844_5_);
        this.theEntity.field_70170_p.field_72984_F.func_76319_b();
        return pathentity;
    }
}

